function [Dta,Dta1]=f_modelDTA(THETA)

% VERSION IX

global dimK2 dimK0 dimSc dimEc dimXc dimYp dimTc dimUc
global K2 K0 Sc Yp Xc Tc Uc
global dimT tol
global beta tut1 tut2 tut3 rho

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% PARAMETERS
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dt_01   = THETA(01) ;                           % Constant in P(W) 
dt_02   = THETA(01)+THETA(end-1) ;              % Constant in P(W) 
dt_03   = THETA(01)-THETA(end) ;                % Constant in P(W) 
dt_K2   = THETA(02) ;                           % K2 coeff in P(W)
dt_K0   = THETA(03) ;                           % K0 coeff in P(W)
dt_S1   = THETA(04) ;                           % Q1 coeff in P(W) 
dt_S2   = THETA(05) ;                           % Q2 coeff in P(W) 
dt_S3   = THETA(06) ;                           % Q3 coeff in P(W) 
dt_X1   = THETA(07) ;                           % X1 coeff in P(W) 
dt_10   = THETA(08) ;
dt_11   = THETA(09) ;

dt_00=[dt_01, dt_02, dt_03]';                   % dUc
dt_S=[0, dt_S1, dt_S2, dt_S3]';                 % dSc (vector of Schooling effect in P(W)) 
dt_Sa=[0, dt_S1+dt_11, dt_S2, dt_S3]';          % dSc (vector of Schooling effect in P(W)) 

% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% %%% PROBABILITIES
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

auxDt00=repmat(dt_00,[1 dimK2 dimSc dimK0 dimXc]);                  % dUc dK2 dSc dK0 dXc
auxDt10=auxDt00+repmat(dt_10,[dimUc dimK2 dimSc dimK0 dimXc]);      % dUc dK2 dSc dK0 dXc
auxDtK2=K2*[dt_K2];                                                 % dK2 
auxDtK2=repmat(auxDtK2,[1 dimUc dimSc dimK0 dimXc]);                % dK2 dUc dSc dK0 dXc 
auxDtK2=permute(auxDtK2,[2 1 3 4 5]);                               % dUc dK2 dSc dK0 dXc 
auxDtK0=K0*[dt_K0];                                                 % dK0 
auxDtK0=repmat(auxDtK0,[1 dimUc dimK2 dimSc dimXc]);                % dK0 dUc dK2 dSc dXc 
auxDtK0=permute(auxDtK0,[2 3 4 1 5]);                               % dUc dK2 dSc dK0 dXc
auxDtSc=repmat(dt_S,[1 dimUc dimK2 dimK0 dimXc]);                   % dSc dUc dK2 dK0 dXc 
auxDtSc=permute(auxDtSc,[2 3 1 4 5]);                               % dUc dK2 dSc dK0 dXc
auxDtSac=repmat(dt_Sa,[1 dimUc dimK2 dimK0 dimXc]);                 % dSc dUc dK2 dK0 dXc
auxDtSac=permute(auxDtSac,[2 3 1 4 5]);                             % dUc dK2 dSc dK0 dXc
auxDtXc=Xc*[dt_X1];                                                 % dXc
auxDtXc=repmat(auxDtXc,[1 dimUc dimK2 dimSc dimK0]);                % dXc dUc dK2 dSc dK0
auxDtXc=permute(auxDtXc,[2 3 4 5 1]);                               % dUc dK2 dSc dK0 dXc
Dta =auxDt00+auxDtK2+auxDtSc +auxDtK0+auxDtXc;                      % dUc dK2 dSc dK0 dXc
Dta1=auxDt10+auxDtK2+auxDtSac+auxDtK0+auxDtXc;                      % dUc dK2 dSc dK0 dXc

clear auxDt00 auxDtK2 auxDtSc auxDtK0 auxDtXc auxDt10 auxDtSac
