function L=f_likelihoodSCH(THETA)

global dimK2 dimK0 dimSc dimEc dimXc dimYp dimTc dimUc
global K2 K0 Sc Yp Xc Tc Uc
global ind1 ind2 ind3 ind4 ind5 ind6 ind7 ind8 ind9 ind10
global ind11 ind12 ind13 ind14 ind15 ind16 ind17 ind18 ind19 ind20 indW
global id Ab2 Ab0 Prd Sch Qua Wag Exp Ypr
global beta 
global ni nn no np

sigE1=THETA(01); 
sigE2=THETA(02); 
sigE3=THETA(03); 

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% SOLVE MODEL
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

[Vs,Vu,Vwu]=f_modelSCH(THETA);

%%% Expected Next Period Life-Time Rewards
POL=zeros(no,dimUc);
POL(:,1)=MyNormcdf(MyLinear(K2,K0,squeeze(beta*Vwu(1,:,1,:,1,2)-Vs(1,:,1,:,1)),Ab2,Ab0,'linear'),0,sigE1);
POL(:,2)=MyNormcdf(MyLinear(K2,K0,squeeze(beta*Vwu(2,:,1,:,1,2)-Vs(2,:,1,:,1)),Ab2,Ab0,'linear'),0,sigE1);
POL(:,3)=MyNormcdf(MyLinear(K2,K0,squeeze(beta*Vwu(3,:,1,:,1,2)-Vs(3,:,1,:,1)),Ab2,Ab0,'linear'),0,sigE1);

PAL=zeros(no,dimUc);
PAL(:,1)=MyNormcdf(MyLinear(K2,K0,squeeze(Vwu(1,:,2,:,1,2)-Vs(1,:,2,:,2)),Ab2,Ab0,'linear'),0,sigE2);
PAL(:,2)=MyNormcdf(MyLinear(K2,K0,squeeze(Vwu(2,:,2,:,1,2)-Vs(2,:,2,:,2)),Ab2,Ab0,'linear'),0,sigE2);
PAL(:,3)=MyNormcdf(MyLinear(K2,K0,squeeze(Vwu(3,:,2,:,1,2)-Vs(3,:,2,:,2)),Ab2,Ab0,'linear'),0,sigE2);

PHE=zeros(no,dimUc);
PHE(:,1)=MyNormcdf(MyLinear(K2,K0,squeeze(Vwu(1,:,3,:,1,4)-Vs(1,:,3,:,4)),Ab2,Ab0,'linear'),0,sigE3);
PHE(:,2)=MyNormcdf(MyLinear(K2,K0,squeeze(Vwu(2,:,3,:,1,4)-Vs(2,:,3,:,4)),Ab2,Ab0,'linear'),0,sigE3);
PHE(:,3)=MyNormcdf(MyLinear(K2,K0,squeeze(Vwu(3,:,3,:,1,4)-Vs(3,:,3,:,4)),Ab2,Ab0,'linear'),0,sigE3);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% LIKELIHOOD
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

L=ones(no,dimUc);

L(ind5,:)   =1-POL(ind5,:);   % S0 -> S1
L(ind6,:)   =POL(ind6,:);     % S0 -> U

L(ind7,:)   =1-PAL(ind7,:);   % S1 -> S2 | Q1=1
L(ind8,:)   =PAL(ind8,:);     % S1 -> W  | Q1=1
L(ind10,:)  =PAL(ind10,:);    % S1 -> U  | Q1=1

L(ind13,:)  =1-PHE(ind13,:);  % S2 -> S3 | Q2=1
L(ind14,:)  =PHE(ind14,:);    % S2 -> W  | Q2=1
L(ind16,:)  =PHE(ind16,:);    % S2 -> U  | Q2=1

clear Vs Vu Vwu POL PAL PHE

% final value
L=max(L,1e-300);
