function L=f_likelihoodLAM(THETA)

global dimK2 dimK0 dimSc dimEc dimXc dimYp dimTc dimUc
global K2 K0 Sc Yp Xc Tc Uc
global ind1 ind2 ind3 ind4 ind5 ind6 ind7 ind8 ind9 ind10
global ind11 ind12 ind13 ind14 ind15 ind16 ind17 ind18 ind19 ind20 indW
global id Ab2 Ab0 Prd Sch Qua Wag Exp Ypr
global ni nn no np

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% SOLVE MODEL
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

[Lam]=f_modelLAM(THETA); % import output from model

% assign Lambdas (probability of succes in school)
Lam1L=zeros(no,dimUc);
Lam1L(:,1)=MyNormcdf(MyLinear(K2,K0,squeeze(Lam(1,:,1,:)),Ab2,Ab0,'linear')); % dK2 dK0
Lam1L(:,2)=MyNormcdf(MyLinear(K2,K0,squeeze(Lam(2,:,1,:)),Ab2,Ab0,'linear')); % dK2 dK0
Lam1L(:,3)=MyNormcdf(MyLinear(K2,K0,squeeze(Lam(3,:,1,:)),Ab2,Ab0,'linear')); % dK2 dK0

Lam2L=zeros(no,dimUc);
Lam2L(:,1)=MyNormcdf(MyLinear(K2,K0,squeeze(Lam(1,:,2,:)),Ab2,Ab0,'linear')); % dK2 dK0
Lam2L(:,2)=MyNormcdf(MyLinear(K2,K0,squeeze(Lam(2,:,2,:)),Ab2,Ab0,'linear')); % dK2 dK0
Lam2L(:,3)=MyNormcdf(MyLinear(K2,K0,squeeze(Lam(3,:,2,:)),Ab2,Ab0,'linear')); % dK2 dK0

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% LIKELIHOOD
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

L=ones(no,dimUc);

L(ind7,:)   =Lam1L(ind7,:)        ; % S1 -> S2 | Q1=1
L(ind8,:)   =Lam1L(ind8,:)        ; % S1 -> W  | Q1=1
L(ind9,:)   =(1-Lam1L(ind9,:))    ; % S1 -> W  | Q1=0
L(ind10,:)  =Lam1L(ind10,:)       ; % S1 -> U  | Q1=1
L(ind11,:)  =(1-Lam1L(ind11,:))   ; % S1 -> U  | Q1=0

L(ind13,:)  =Lam2L(ind13,:)       ; % S2 -> S3 | Q2=1
L(ind14,:)  =Lam2L(ind14,:)       ; % S2 -> W  | Q2=1
L(ind15,:)  =(1-Lam2L(ind15,:))   ; % S2 -> W  | Q2=0
L(ind16,:)  =Lam2L(ind16,:)       ; % S2 -> U  | Q2=1
L(ind17,:)  =(1-Lam2L(ind17,:))   ; % S2 -> U  | Q2=0

clear Lam Lam1L Lam2L

% final value
L=max(L,1e-300);
