function THETA=f_guessSCH(THETA,pk)

global dimK2 dimK0 dimSc dimYp dimXc dimTc dimUc
global K2 K0 Yp Uc
global beta 
global id Ab2 Ab0 Prd Sch Qua Wag Exp Ypr
global ind1 ind2 ind3 ind4 ind5 ind6 ind7 ind8 ind9 ind10
global ind11 ind12 ind13 ind14 ind15 ind16 ind17 ind18 ind19 ind20 indW
global tSCH

aux=(tSCH-dimUc+1)/3; % # of parameters at each schooling stage

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% HE

[Vs,Vu,Vwu,Rss]=f_modelSCH(THETA);
VG3=MyLinear(K2,K0,squeeze(sum(repmat(pk,[1 dimK2 1 dimK0]).*...
    (Vwu(:,:,3,:,1,4)-Vs(:,:,3,:,4)+3*Rss(:,:,3,:,1)),1)),Ab2,Ab0,'linear'); % net opportunity cost
ind=([ind13;ind14;ind16]);
y3=Sch(ind)==3;
x3=[VG3(ind)]; 
[bhat3,dev,stats] = glmfit(x3,[y3 ones(length(y3),1)],'binomial','probit'); % probit including constant

THETA(03)=-1/bhat3(end); % compute shock's standard deviation using net opportunity cost normalization
THETA(3+(aux-1)*2+1:3+(aux-1)*3)=bhat3(1:end-1)*THETA(03)/3; % compute coeff absolute scale

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% AL

[Vs,Vu,Vwu,Rss]=f_modelSCH(THETA);
VG2=MyLinear(K2,K0,squeeze(sum(repmat(pk,[1 dimK2 1 dimK0]).*...
    (Vwu(:,:,2,:,1,2)-Vs(:,:,2,:,2)+2*Rss(:,:,2,:,1)),1)),Ab2,Ab0,'linear'); % net opportunity cost
ind=([ind7;ind8;ind10]);
y2=Sch(ind)==2;
x2=[VG2(ind)]; % 
[bhat2,dev,stats] = glmfit(x2,[y2 ones(length(y2),1)],'binomial','probit'); % probit including constant

THETA(02)=-1/bhat2(end); % compute shock's standard deviation using net opportunity cost normalization
THETA(3+(aux-1)*1+1:3+(aux-1)*2)=bhat2(1:end-1)*THETA(02)/2; % compute coeff absolute scale 

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% OL

[Vs,Vu,Vwu,Rss]=f_modelSCH(THETA);
VG1=MyLinear(K2,K0,squeeze(sum(repmat(pk,[1 dimK2 1 dimK0]).*...
    (beta*Vwu(:,:,1,:,1,2)-Vs(:,:,1,:,1)+Rss(:,:,1,:,1)),1)),Ab2,Ab0,'linear'); % net opportunity cost
ind=([ind5;ind6]);
y1=Sch(ind)==1;
x1=[VG1(ind)]; % 
[bhat1,dev,stats] = glmfit(x1,[y1 ones(length(y1),1)],'binomial','probit'); % probit including constant

THETA(01)=-1/bhat1(end); % compute shock's standard deviation using net opportunity cost normalization
THETA(3+(aux-1)*0+1:3+(aux-1)*1)=bhat1(1:end-1)*THETA(01); % compute coeff absolute scale 
