function [Y1 Y2] = MySimulvar2(mat,nn)

% y=MySimulvar(mat,nn)
% This is a function written to simulate two variables replicating the 
% joint discrete distributions of two exogenous random variables. 
% Inputs:
% mat - cell array with cell frequencies (from crosstab command) and 
%       two vectors with the values taken by each random variable. 
% nn - number of observations to simulate
% Example
% MySimulvar2(mat,nn)

% Check 1
if nargin<2
    error('too few input arguments')
elseif nargin>3
    error('too many imput arguments')
end

% Check 2 
if iscell(mat)~=1 % is cell array?
    error('first input is not a cell array')
elseif isscalar(nn)~=1 % is scalar?
    error('second input is not a scalar')
elseif ndims(mat{1})~=2 % is 1st element of cell array a contingency table?
    error('1st element of cell array is not a 2D table')
elseif size(mat{2},1)<=1 | size(mat{2},2)~=1 % is 2nd element of cell array n by 1? 
    error('2nd element of cell array is not a n by 1 vector')    
elseif size(mat{3},1)<=1 | size(mat{3},2)~=1 % is 3rd element of cell array n by 1? 
    error('3rd element of cell array is not a n by 1 vector')    
elseif size(mat{2},1)~=size(mat{3},1) % are 2nd and 3rd element of cell array same size?
    error('2nd and 3rd element of cell array have different size')
end


table1=mat{1}; % contingency table
table2=reshape(table1,prod(size(table1)),1); % reshape contingency table into k by 1 vector
tablec=reshape(cumsum(table2),[size(table1)]); % reshape cumulative sum vector into a 2D matrix
tablec=tablec/tablec(end,end)*nn; % adjust table for simulation size

X1=mat{2}; Y1=zeros(nn,1); % take vector of values and initialize vector to simulate
X2=mat{3}; Y2=zeros(nn,1); % take vector of values and initialize vector to simulate

i=1;

for c=1:size(table1,2) % loop over number of columns
    for r=1:size(table1,1) % loop over number of rows
    
    while i<=tablec(r,c)
        Y1(i)=X1(r);
        Y2(i)=X2(c);
        i=i+1;
    end
    
    end
end
   
% crosstab(Y1,Y2);      
    
    