function y=MySimulvar(mat,e,nn,pr)

% y=MySimulvar(x,e,nn,yy)
% This is a function written to simulate a variable mirroring an exogenous 
% one. The routine uses a uniformly distributed shock.
% It conditions on x being observed in Prd yy. 
% Inputs:
% mat - matrix or cell array (from tabulate command)
% e - shock
% nn - number of observations to simulate
% pr - period of interest (optional - requires mat to be nD)
% Example
% MySimulvar(mat,e,nn)

if nargin<3
    error('too few input arguments')
elseif nargin==3
    pr=1;
elseif nargin==4
    pr=pr;
else 
    error('too many imput arguments')
end

if iscell(mat) % is cell array?
    aux=mat{pr}; % go from cell array to numerical array
    aux1=aux(:,1); % define vector of values
    aux2=cumsum(aux(:,3)); % define cumulative probabilities
else % not cell array
    if ndims(mat)==3 % is multi-period matrix?
        aux1=mat(:,1,pr); % define vector of values
        aux2=cumsum(mat(:,3,pr)); % define cumulative probabilities
    elseif ndims(mat)==2 % is 1 period matrix?
        aux1=mat(:,1); % define vector of values
        aux2=cumsum(mat(:,3)); % define cumulative probabilities
    end
end
    
y=zeros(nn,1); % initialize vector 

ind=find(e<(aux2(1)/100)); % first value
y(ind)=aux1(1); % first values

for i=2:size(aux2,1) % loop for remaining values
    ind=find(e>(aux2(i-1)/100));
    y(ind)=aux1(i);
end

