function  y=MyDiscretize(varargin)

% MyDiscretize.m discretize a continous variable x in c points. 
% Inputs:
% x - variable to be discretized
% c - number of points
% Example
% y=MyDiscretize(x,30);

if nargin<2
    error('too few input arguments')
elseif nargin>3
    error('too many input arguments')
end

x=varargin{1}; % variable
c=varargin{2}; % number of points 

% recode original variable in c values grid
kx=(max(x)-min(x))/c;
gx=min(x):kx:max(x);
for i=1:length(gx)-1
    ix=find(x>gx(i) & x<=gx(i+1));
        x(ix)=gx(i);
end

y=x;
