function  wald = wald_homo_iv(del_tsls,e,aux,n,I_kY2,ly2)

% Compute wald test for linear IV models with cluster
% model is y1 = y2*b  + x*g     + u
%          y2 = z*pi.z + x*pi.x + v
% y1   = dependent variable
% y2   = endogenous explanatory variable
% x    = included instruments
% z    = excluded instruments
% NG   = # of observation in each cluster
%(u,v) = residuals
% com  = 'adjust' include the Stata variance adjustment 

sigma2 = (e'*e/n);
Vtsls  = sigma2*(aux\I_kY2);

wald   = del_tsls'*(Vtsls(ly2,ly2)\del_tsls);

end