function  [wald,Vtsls] = wald_cluster_iv(del_tsls,e,W,aux,ly2,NG)

% Compute wald test for linear IV models with cluster
% model is y1 = y2*b  + x*g     + u
%          y2 = z*pi.z + x*pi.x + v
% y1   = dependent variable
% y2   = endogenous explanatory variable
% x    = included instruments
% z    = excluded instruments
% NG   = # of observation in each cluster
%(u,v) = residuals
% com  = 'adjust' include the Stata variance adjustment 

h      = score(e,W, NG,'nr');
Vhh    = vscore( h, h, NG);
Vtsls  = aux'*Vhh*aux;

wald   = del_tsls'*(Vtsls(ly2,ly2)\del_tsls);
%--- Stata correction term for cluster
%ct    =( nG/(nG-1) )*( (nt-1)/(nt-np-kx) );
%ct_md =( nc/(nc-1) )*( (nt-1)/(nt-kz-kx) );

end