function V  = vscore_m( h, q)
%  
% h = [h1'; h2'; ... hG'] score matrix (empirical moment) G x k.h 
% q = [q1'; q2'; ... qG'] score matrix (empirical moment) G x k.q  
% NG = vector G x 1, number of observations per cluster
% return V: covariance matrix between h and q, k.h x k.q  

% k.h  = size(h,2);      % columns number h
% k.q  = size(q,2);      % column number q
% G    = size(NG,1);     % number of cluster

% n    = sum(NG);          % total number of observations   

%--- Score Mean 
% h_bar =  sum(h,1)/n ;
% q_bar =  sum(q,1)/n ; 

% H     = h - NG*h_bar;
% Q     = q - NG*q_bar;

H     = h ;
Q     = q ;

%--- Cluster Variance-Covariance matrix between h and q 
V     = H'*Q;

end
