function h_score  = score(e,w,NG,com)
%
% e  = residuals     n x p  matrix
% w  = instruments   n x kw matrix
% NG = # of observation in each cluster
% com= 'r' recenter the score function, else, do not recenter
% Small sample adjustaments is outside of the function
% h_score is a G x kw*p matrix

n    = size(w,1);      % number of observations
kw   = size(w,2);      % number of instruments
p    = size(e,2);      % number of columns residual matrix (vector)
G    = size(NG,1);     % number of cluster

iota.kw = ones(1,kw);
H       = zeros(n,kw*p);

for i=1:p
    ci = 1+kw*(i-1);
    cf = i*kw;
    H(:,ci:cf) = w.*(e(:,i)*iota.kw);
end

h     = zeros(G,kw*p);  % score matrix

%--- Loop Initialization
gi = 1;
gfi= 0;

if (com(1)=='r')
    h_bar = sum(H,1)/n ;
    for g = 1:G
        
        ng     = NG(g,1);
        gf     = gfi + ng;
        hg     = sum(H(gi:gf,:),1) - ng*h_bar;    % recentered score
        
        h(g,:) = hg;
        
        gi     = gf+1;
        gfi    = gf;
        
    end
else
    for g = 1:G
        
        gf     = gfi + NG(g,1);
        hg     = sum(H(gi:gf,:),1);    
        
        h(g,:) = hg;
        
        gi     = gf+1;
        gfi    = gf;
        
    end
end

%--- h_score = [h1'; h2'; ... ; hG']
h_score= h;     


end
