function dtest = ranktest_svd(mPi, mF, mG, mW, cRank, cT)
%This function returns the rank statistic.
%See Kleibergen and Papp, Journal of Econometrics,2006

%Input
%mPi    : kxm matrix k>=m
%mF     : mxm matrix
%mG     : kxk matrix 
%mW     : (k*m)x(k*m) matrix, variance of vec(mPi)
%cRank  : integer, rank under H0
%cT     : sample size
% choose mF and mG such that kron(mF,mG) * mW * kron(mF,mG) is close to the
% identity matrix
%Output
%dtest  : rank statistics

	q=cRank;
    [k,m]  = size(mPi);
	ml0    = mG*mPi*mF';
    mWt    = kron(mF,mG)*mW*(kron(mF,mG)');
    if q==0		          % simple problem
		%momega=kron(mF,mG)*mW*(kron(mF,mG)');
		dtest=cT*ml0(:)'*(mWt\ml0(:));     % obs ml0(:)=vec(ml0)
        return;
    end
    
	[mu,ms,mv]=svd(ml0); % singular value decomposition C=U*S*V'
    %mv=mv(:,1:m);
	%ms=[ms(1:m,1:m);zeros(k-m,m)];
	mu22       = mu(q+1:k, q+1:k);
	[marg,meig]= eig(mu22*mu22');
	mu22h      = marg*((meig.^(.5))\marg');
    
	mv22       = mv(q+1:m,q+1:m);
	[marg,meig]= eig(mv22*mv22');
	mv22h      = marg*((meig.^(.5))\marg');
    
    
	mlq = mu22h*mu22*ms(q+1:k,q+1:m)*mv22'*mv22h; 
	% note that mu22'mu22h = invert(mu22h*mu22) because U22 is full rank
    maq = mu(:,q+1:k)*mu22'*mu22h;
    % same for V22
	mbq = mv22h*mv22*mv(:,q+1:m)'; 	  

    m1=kron(mbq,maq');
	momega=m1*mWt*m1';

    dtest=cT*mlq(:)'*(momega\mlq(:));
end
