function [resid_N, resid_G] = rand_tdist_size(n_G, n_sim, n_obs, k_Y)

% Generate bootstrap weights and random errors 
% n_G   : number of clusters
% n_boot: number of bootstrap samples
% n_sim : number of monte carlo simulations
% n_obs : number the observations
% k_Y   : total number of endogenous variables


%--- Generate Random numbers outside of the loop.
st      ={ RandStream('swb2712'  ,'Seed',590)  ;
           RandStream('mt19937ar','Seed',3)    ;
           RandStream('mt19937ar','Seed',4110) ;
           RandStream('mt19937ar','Seed',9540) ;
           RandStream('swb2712'  ,'Seed',6541)};

%--- Residuals Simultaneous Equation model
nu      = 4;
norm    = (nu/(nu-2))^.5;
resid_N =  tinv(rand(st{1},n_obs,k_Y,n_sim),nu)/norm;  % idyosincratic  error
resid_G =  tinv(rand(st{2},n_G  ,k_Y,n_sim),nu)/norm;  % cluster error     


