function [w_gamma, w_radem, w_ind] = rand_boot(n_G,n_boot, n_sim)

% Generate bootstrap weights and random errors 
% n_G   : number of clusters
% n_boot: number of bootstrap samples
% n_sim : number of monte carlo simulations

%--- Generate Random numbers outside of the loop.
st      ={ RandStream('swb2712'  ,'Seed',590)  ;
           RandStream('mt19937ar','Seed',3)    ;
           RandStream('mt19937ar','Seed',4110) ;
           RandStream('mt19937ar','Seed',9540) ;
           RandStream('swb2712'  ,'Seed',6541)};

%--- Rademacher weights

w_radem = 2*binoinv(rand(st{2},n_G,n_boot, n_sim),1,0.5)-1;

%--- Gamma weights 
Alpha  =  4; 
Beta   = .5;

w_gamma  = gaminv(rand(st{3},n_G,n_boot, n_sim),Alpha,Beta) - Alpha*Beta;

%--- Random integers for pairs bootstrap

w_ind   = randi(st{4},n_G, n_G,n_boot, n_sim); 


