function [ ] = pvalue_colonial(y1, y2, Z, X, theta0, n_G, l_ini, l_end, v_G, n_boot, savefile, com)
%Compute the bootstrap confidence intervals for
%Daron Acemoglu, Simon Johnson, and James A. Robinson "The Colonial
%Origins of Comparative Development: An Empirical Investigation: Reply"
%   y1 = loggdp    - Log GDP per capita (PPP) in 1995
%   y2 = risk      - Expropriation Risk (endogenous explanatory variable
%   Z  = logmort   - Log Settler Mortality
%   X  = included instruments
%   theta0= points in the parameter space
%   n_G   = # of clusters
%   l_ini = vector with the initial observertation of each cluster
%   l_end = vector with the last observation of each cluster
%   v_G   = # of observations per cluster

%% load the bootstrap random numbers.
[w_gamma, w_radem, w_ind] = civ_rand(n_G,n_boot);


%% indicator to computer pairs bootstrap
com1 = -1;
if (com(1)=='p')
    com1 = 2;
end

%%
Y2 = [y2 X];
W  = [Z X];

k_y1 = size(y1,2);            
k_y2 = size(y2,2);
k_Y  = k_y1+k_y2;     % # of endogenous variables
k_z  = size(Z,2);
k_x  = size(X,2);
k_Y2 = size(Y2,2);
k_w  = k_z+k_x;       % # of instruments

% n_boot = 2999;                      % # of bootstrap samples
n_obs  = sum(v_G);                  % # of observations
n_hom  = n_obs-k_w;                 % degrees of freedom, homoskedatic case
n_par  = sum([k_Y-k_y2;k_y2; k_w]); % # of parameters
col    = cumsum([k_Y-k_y2;k_y2; k_z;k_x]); % column index for pairs bootstrap

%--- Selection Indices
l_z  = 1:k_z;
%l_w  = 1:k_w;
l_wp = 1:(k_w*k_y2);
l_x  = k_z+1:k_w;
l_y2 = 1:k_y2;

% iota_n = X(:,1);
iota_kw= ones(1,k_w);

I_n     = eye(n_obs);
% I_G     = eye(n_G);
I_kw    = eye(k_w); 
% I_kz    = eye(k_z);
I_p     = eye(k_y2); 
% I_kY2   = eye(k_y2+k_x);
% delta_z = zeros(k_z,1);
Weight  = zeros(n_obs);


XX  = X'*X;
XXX = XX\X';
WW  = W'*W;
iWW = WW\I_kw;        
IWW = kron(I_p,WW);
WWW = WW\W';
P_x = X*XXX;
P_w = W*WWW;
M_x = I_n - P_x;
M_w = I_n - P_w;
Z_x = M_x*Z;

Pi_z  = zeros(k_z,k_y2);
Pi_w  = WWW*y2;              % Inefficient First-Stage estimator 
Pi_w0 = [Pi_z; XXX*y2];      % restricted estimator under H0: Piz = 0.

Y2          = [y2 X];
[Par, aux2] = tsls_iv(Y2,y1,WWW, P_w);
e_tsls      = y1 - Y2*Par;
v_hat       = M_w*y2;                  % Inefficient First-Stage Residual
v0          = M_x*y2;                  % error under H0:Piz = 0.

[wald_asym, VTsls]   = wald_cluster_iv(Par(l_y2),e_tsls,W,aux2,l_y2,v_G);

% adjustment factors
ct     = (n_G/(n_G-1))*((n_obs-1)/(n_obs-k_Y2)); % TSLS.
ct_eff = (n_obs)/(n_obs-k_w);                    % effective F
ctar   = (n_G/(n_G-1))*((n_obs-1)/(n_obs-k_w) ); % F

VTsls  = ct*VTsls;

q_hat       = score(v_hat ,W, v_G,'nr') ;
V_hat_PiPi  = (IWW\vscore( q_hat, q_hat, v_G))/IWW;
Ftest       = (Pi_w(l_z)'*(V_hat_PiPi(l_z,l_z)\Pi_w(l_z)))/k_z;

% [Ftest_eff,~] = eff_F_test_simp(Z_x,M_x*y2,I_n,v_G); % effective F

tau        = 0.10;
eps        = 1e-4;
points     = 1e+4;

[Ftest_eff, K_eff, X_eff, K_eff_simp, X_eff_simp] = eff_F_test(M_x*Z,M_x*y1,M_x*y2,I_n,v_G,tau, eps, points);

Ftest_eff_ad = Ftest_eff/ct_eff; 
Ftest_ad     = Ftest/ctar;

prob     = .95;
df       = [K_eff K_eff_simp]; 
ncp      = [X_eff.*K_eff X_eff_simp.*K_eff_simp]; %non centrality parameters
CV_F_eff = ncx2inv(prob,df,ncp)./df;


% parpool('local',8) %parallel computing function

n_f_b     = 3;                % # of F bootstrap tests
f_b1      = zeros(n_boot,1);
f_b2      = zeros(n_boot,1);
f_b3      = zeros(n_boot,1);

parfor b = 1:n_boot
% for b = 1:n_boot    
    wg = w_gamma(:,b);
    wr = w_radem(:,b);
    
    W_Wild_g  = w_matrix(n_G, wg, I_n, Weight, v_G);
    W_Wild_r  = w_matrix(n_G, wr, I_n, Weight, v_G);
    
    %% F tests bootstrap
    y2b       = W*Pi_w0 + W_Wild_g*v0;
    f_b1(b,1) = F_test_col_orig(W,IWW,WWW*y2b,M_w*y2b,v_G,l_z,k_z);
    
    y2b       = W*Pi_w0 + W_Wild_r*v0;
    f_b2(b,1) = F_test_col_orig(W,IWW,WWW*y2b,M_w*y2b,v_G,l_z,k_z);

end

if (com1>0)
    parfor b = 1:n_boot
        wi = w_ind(:,b);
        v_G1    = v_G;
        l_ini1  = l_ini;
        l_end1  = l_end;
        
        DD        = boot_sample([y1 y2 W], n_par, l_ini1(wi),l_end1(wi),v_G1(wi));
        f_b3(b,1) = boot_f_pairs(DD(:,2:end),I_p, l_z,v_G(wi),Pi_w,k_z);
        
    end
end

f_b       = [f_b1 f_b2 f_b3] ;

ws_f           = mean(f_b(:,1:n_f_b)>Ftest);										 
pvalue_F_g_IME = ws_f(1, 1);                                             
pvalue_F_r_IME = ws_f(1, 2);                                             
pvalue_F_pairs = ws_f(1, 3);                                             
																		 
pvalue_Ftest = 1-chi2cdf(Ftest_ad*k_z,k_z);

Theta0 = theta0';
sTh0   = size(Theta0,1); 

%matrix to store the results. omp states for one minus p-value.
omp_ar_homo  = NaN(sTh0,1);  
omp_ar_asym  = NaN(sTh0,1);
omp_ar_md    = NaN(sTh0,1);
omp_wald     = NaN(sTh0,1);
             
omp_ar_g_EE0 = NaN(sTh0,1);
omp_ar_g_SE0 = NaN(sTh0,1);
omp_ar_g_DM  = NaN(sTh0,1);
omp_ar_r_EE0 = NaN(sTh0,1);
omp_ar_r_SE0 = NaN(sTh0,1);
omp_ar_r_DM  = NaN(sTh0,1);

omp_w_g_EME  = NaN(sTh0,1);
omp_w_r_EME  = NaN(sTh0,1);
omp_w_pairs  = NaN(sTh0,1);

n_b       = 6; % # of ar bootstrap tests
n_w_b     = 3; % # of wald bootstrap tests

parfor i=1:sTh0
    
    %II - Calculate the statistics
    th0       = Theta0(i);
    
    %Wald Test
    par      = Par;
    Vtsls    = VTsls;
    th_tsls  = par(l_y2)-th0;
    wald_asym= th_tsls'*(Vtsls(l_y2,l_y2)\th_tsls);
    
    Y0       = y1 - y2*th0;
    g0_ols   = XXX*Y0;
    parr     = [th0; g0_ols]; % constrained TSLS estimator
    
    delta_w  = WWW*Y0;                  % unrestricted estimator
    e_til    = M_x*Y0;                  % e_til = e_tsls0  = y1 - Y2*parr;
    e_hat    = M_w*Y0;
    
    V_hom_deldel = ((e_hat'*e_hat)/n_hom)*iWW;
    
    h_til   = score(e_til ,W, v_G,'nr') ;
    q_hat   = score(v_hat ,W, v_G,'nr') ;
    h_hat   = score(e_hat ,W, v_G,'nr') ;
    
    V_til_deldel_md = (WW\vscore(h_hat, h_hat, v_G))/WW; %variance for the AR MD
    
    V_til_deldel = (WW\vscore(h_til, h_til, v_G))/WW;
    V_til_Pidel  = (IWW\vscore(q_hat, h_til, v_G))/WW;
   
    Pi_w1     = Pi_w;
    
    pi_til_w0 = Pi_w1(:) - V_til_Pidel(l_wp,l_z)*(V_til_deldel(l_z,l_z)\delta_w(l_z));
    Pi_til_w0 = reshape(pi_til_w0,k_w,k_y2);
    
    v_til0   = y2 - W*Pi_til_w0;
    
    %--- gamma MD estimator under H0:   (g0_gmm = g0_md)
    g0_md    = delta_w(l_x) - V_til_deldel(l_x,l_z)*(V_til_deldel(l_z,l_z)\delta_w(l_z));
    
    %---Efficient residuals
    e_til0  = Y0 - X*g0_md;              % e_til0=Y0-X*g0_gmm or e_til0=Y0-W*delta_w0
    h_til0c = score(e_til0 ,W, v_G,'r'); % recentered score for the score bootstrap
    
    ar_asym    = delta_w(l_z)'*((V_til_deldel(l_z,l_z))\delta_w(l_z));
    ar_md      = delta_w(l_z)'*((V_til_deldel_md(l_z,l_z))\delta_w(l_z));
    ar_homo    = delta_w(l_z)'*(V_hom_deldel(l_z,l_z)\delta_w(l_z));
    
    omp_wald(i,1)   = wald_asym;
    omp_ar_asym(i,1)= ar_asym;
    omp_ar_md(i,1)  = ar_md;
    omp_ar_homo(i,1)= ar_homo;
    
    wald_b  = zeros(n_boot,n_w_b);
    ar_b    = zeros(n_boot,n_b);
    
    w_gamma1= w_gamma;
    w_radem1= w_radem;
    l_ini1  = l_ini;
    l_end1  = l_end;
 
    for b = 1:n_boot
        
        wg = w_gamma1(:,b);
        wr = w_radem1(:,b);
        
        %---gamma under H0: g0 = g0_md = g0_gmm
        %--Gamma weight
        ar_b(b,1) =  boot_score_ar(wg, iota_kw, h_til0c, WW, v_G, l_z, 1);
        %--Rademacher weight
        ar_b(b,2) =  boot_score_ar(wr, iota_kw, h_til0c, WW, v_G, l_z, 1);
        
        %% Weights - Residual Bootstraps
        W_g     = w_matrix(n_G, wg, I_n, Weight, v_G);
        W_r     = w_matrix(n_G, wr, I_n, Weight, v_G);
        
        %% Single Equation Residual Bootstrap. Under H0: g0 = XHX\(X'H*Y0)
        %--Gamma weight
        ar_b(b,3)  =  boot_se_ar(e_til0,W_g,M_x,W,WW,WWW, v_G,l_z, 1);
        %-- Rademacher weight
        ar_b(b,4)  =  boot_se_ar(e_til0,W_r,M_x,W,WW,WWW, v_G,l_z, 1);
        
        %% Davidson&MacKinnon Efficient Restricted Bootstrap
        %--- Sampled at cluster level, computed using the homoskedastic version of the weak-IV tests
        %--Gamma weight
        ar_b(b,5) = boot_me_dm_ar(e_til,W_g,M_w,iWW,WWW,l_z,n_hom);
        %--Rademacher weight
        ar_b(b,6) = boot_me_dm_ar(e_til,W_r,M_w,iWW,WWW,l_z,n_hom);
        
        %% Wald residual bootstrap
        %-- DGP based imposing the null in the first and  second stages
        %--Gamma weight
        wald_b(b,1)= boot_me_wald_adj(e_til,v_til0,W_g,X,W,WWW,P_w,l_y2,Pi_til_w0,parr,v_G,ct);
        %--Rademacher weight
        wald_b(b,2)= boot_me_wald_adj(e_til,v_til0,W_r,X,W,WWW,P_w,l_y2,Pi_til_w0,parr,v_G,ct);
        
    end

    %% Wald Pairs Bootstrap
    if (com1>0)
        w_ind1  = w_ind;
        for b = 1:n_boot
            wi = w_ind1(:,b)  ;
            
            DD        = boot_sample([y1 y2 W], n_par, l_ini1(wi),l_end1(wi),v_G(wi)); %sample the observations
            wald_b(b,3)= boot_pairs_wald(DD,par,col,l_y2,v_G(wi));
        end
    end
    ws_ar  = mean(ar_b(:,1:4)<ar_asym);
    omp_ar_g_EE0(i,1) = ws_ar(1, 1);
    omp_ar_r_EE0(i,1) = ws_ar(1, 2);
    omp_ar_g_SE0(i,1) = ws_ar(1, 3);
    omp_ar_r_SE0(i,1) = ws_ar(1, 4);
    
    ws_ar_dm  = mean(ar_b(:,5:6)<ar_homo);
    omp_ar_g_DM(i,1) = ws_ar_dm(1,1);
    omp_ar_r_DM(i,1) = ws_ar_dm(1,2);
    
    ws_w  = mean(wald_b(:,1:3)<wald_asym);
    omp_w_g_EME(i,1) = ws_w(1,1);
    omp_w_r_EME(i,1) = ws_w(1,2);
    omp_w_pairs(i,1) = ws_w(1,3);
end


omp_wald    = chi2cdf(omp_wald(:,1),k_y2);
omp_ar_asym = chi2cdf(omp_ar_asym(:,1),k_z);
omp_ar_md   = chi2cdf(omp_ar_md(:,1),k_z);
omp_ar_homo = chi2cdf(omp_ar_homo(:,1),k_z);

diary off 
diary(['results' '/' savefile '.txt'])

fprintf(1, '\n        p-values for testing H0: theta=0          \n' );

fprintf(1, 'wald_asym  | %8.7f  |  \n', 1- omp_wald    );
fprintf(1, 'wald_g_EME | %8.7f  |  \n', 1- omp_w_g_EME );
fprintf(1, 'wald_r_EME | %8.7f  |  \n', 1- omp_w_r_EME );
fprintf(1, 'wald_pairs | %8.7f  |\n\n', 1- omp_w_pairs );
                                              
fprintf(1, 'ar_homo    | %8.7f  |  \n', 1- omp_ar_homo );
fprintf(1, 'ar_md      | %8.7f  |  \n', 1- omp_ar_md   );
fprintf(1, 'ar_asym    | %8.7f  |  \n', 1- omp_ar_asym );
fprintf(1, 'ar_g_EE0   | %8.7f  |  \n', 1- omp_ar_g_EE0);
fprintf(1, 'ar_g_SE0   | %8.7f  |  \n', 1- omp_ar_g_SE0);
fprintf(1, 'ar_g_DM    | %8.7f  |  \n', 1- omp_ar_g_DM );
fprintf(1, 'ar_r_EE0   | %8.7f  |  \n', 1- omp_ar_r_EE0);
fprintf(1, 'ar_r_SE0   | %8.7f  |  \n', 1- omp_ar_r_SE0);
fprintf(1, 'ar_r_DM    | %8.7f  |\n\n', 1- omp_ar_r_DM );
                      
fprintf(1, 'f_asym     | %8.2f   \n'  ,  Ftest_ad    ) ;
fprintf(1, 'feff_asym  | %8.2f   \n\n',  Ftest_eff_ad) ;
fprintf(1, 'feff_cv    | %8.2f   \n\n',  CV_F_eff);

fprintf(1, 'pf_asym    | %8.3f   \n',  pvalue_Ftest   );
fprintf(1, 'pf_g_IME   | %8.3f   \n',  pvalue_F_g_IME );
fprintf(1, 'pf_r_IME   | %8.3f   \n',  pvalue_F_r_IME );
fprintf(1, 'pf_pairs   | %8.3f \n\n',  pvalue_F_pairs );

diary off                              

 

save(['results' '/' savefile],'theta0','omp_w*','omp_a*','Ftest*','Ftest_eff*', 'CV_F_eff');


%                               
% ind_AR_g_EE0=(omp_ar_g_EE0<=.95); ind_W_g_EME=(omp_w_g_EME <=.95);
% ind_AR_g_SE0=(omp_ar_g_SE0<=.95); ind_W_r_EME=(omp_w_r_EME <=.95);
% ind_AR_g_DM =(omp_ar_g_DM <=.95); ind_W_pairs=(omp_w_pairs <=.95);
% ind_AR_r_EE0=(omp_ar_r_EE0<=.95);
% ind_AR_r_SE0=(omp_ar_r_SE0<=.95);
% ind_AR_r_DM =(omp_ar_r_DM <=.95);


% fprintf(1, '\n        95%% Confidence Intervals          \n' );
% fprintf(1, 'wald_asym  | %6.3f  %6.3f|   \n',  min(theta0(ind_Wald   )), max(theta0(ind_Wald   )));
% fprintf(1, 'wald_g_EME | %6.3f  %6.3f|   \n',  min(theta0(ind_W_g_EME)), max(theta0(ind_W_g_EME)));
% fprintf(1, 'wald_r_EME | %6.3f  %6.3f|   \n',  min(theta0(ind_W_r_EME)), max(theta0(ind_W_r_EME)));
% fprintf(1, 'wald_pairs | %6.3f  %6.3f| \n\n',  min(theta0(ind_W_pairs)), max(theta0(ind_W_pairs)));
% 
% fprintf(1, 'ar_homo    | %6.3f  %6.3f|   \n',  min(theta0(ind_AR_homo )),max(theta0(ind_AR_homo )));
% fprintf(1, 'ar_md      | %6.3f  %6.3f|   \n',  min(theta0(ind_AR_md   )),max(theta0(ind_AR_md   )));
% fprintf(1, 'ar_asym    | %6.3f  %6.3f|   \n',  min(theta0(ind_AR_asym )),max(theta0(ind_AR_asym )));
% fprintf(1, 'ar_g_EE0   | %6.3f  %6.3f|   \n',  min(theta0(ind_AR_g_EE0)),max(theta0(ind_AR_g_EE0)));
% fprintf(1, 'ar_r_EE0   | %6.3f  %6.3f|   \n',  min(theta0(ind_AR_r_EE0)),max(theta0(ind_AR_r_EE0)));
% fprintf(1, 'ar_g_SE0   | %6.3f  %6.3f|   \n',  min(theta0(ind_AR_g_SE0)),max(theta0(ind_AR_g_SE0)));
% fprintf(1, 'ar_r_SE0   | %6.3f  %6.3f|   \n',  min(theta0(ind_AR_r_SE0)),max(theta0(ind_AR_r_SE0)));
% fprintf(1, 'ar_g_DM    | %6.3f  %6.3f|   \n',  min(theta0(ind_AR_g_DM )),max(theta0(ind_AR_g_DM )));
% fprintf(1, 'ar_r_DM    | %6.3f  %6.3f| \n\n',  min(theta0(ind_AR_r_DM )),max(theta0(ind_AR_r_DM )));
%                       
% fprintf(1, 'f_asym     | %6.3f   \n'  ,Ftest_ad    ) ;
% fprintf(1, 'feff_asym  | %6.3f   \n\n',Ftest_eff_ad) ;
% 
% fprintf(1, 'pf_asym    | %6.3f   \n',  pvalue_Ftest   );
% fprintf(1, 'pf_g_IME   | %6.3f   \n',  pvalue_F_g_IME );
% fprintf(1, 'pf_r_IME   | %6.3f   \n',  pvalue_F_r_IME );
% fprintf(1, 'pf_pairs   | %6.3f \n\n',  pvalue_F_pairs );


end

