function [l_ini, l_end, v_G] = position(n_G, n_obs, vec_cluster)
%Returns the initial and last position of each cluster in the data, together with number of obsertation
%   n_G          = # of cluster
%   n_obs        = # of observations
%   vec_cluster  = n_obs x 1 vector with the cluster indicators 
%   l_ini        = vector with the initial observertation of each cluster
%   l_end        = vector with the last observation of each cluster
%   v_G          = # of observations per cluster

i=1;
l_ini= [1 ; zeros(n_G-1,1)];
for g=2:n_G
    while (i<n_obs && vec_cluster(i)==vec_cluster(i+1))
        i = i+1;
    end
    i = i+1;
    l_ini(g,1)=i;
    
end
l_end = [l_ini(2:end)-1;n_obs];
v_G   = l_end-l_ini +1;          % # of observations per cluster  



end

