function [Z, X,M_x, I_n, l_ini,l_end,W_G,W_I,nu] = instruments_dgp_gauss(n_obs, k_z, k_x, n_G, v_G, lambda, het, c)

% Generate Instrumental Variables for the Simulation Exercise
% n_obs = # of observations
% k_z   = # of excluded instruments
% k_x   = # of included instruments
% n_G   = # of clusters
% v_G   = vector with # of observations per cluster

l_ini  = cumsum(v_G) - v_G + 1;
l_end  = cumsum(v_G);
iota_x = ones(n_obs,1);

str = RandStream('swb2712','Seed',90);  % same values of z
Z_c = zeros(n_obs,k_z);                 % excluded instruments
Z_i = zeros(n_obs,k_z);                 % excluded instruments
D   = zeros(n_obs,n_G);                 % cluster effect 

for g=1:n_G
    g_in    = l_ini(g);
    g_end   = l_end(g);
    iota_ng = iota_x(g_in:g_end,1);
    d_g     = randn(str,1,k_z);
    
    Z_c(g_in:g_end,:)= iota_ng*d_g;
    
    v_d = randn(str,v_G(g),k_z);
    Z_i(l_ini(g):l_end(g),:)= v_d - iota_ng*mean(v_d);
    
    D(l_ini(g):l_end(g),g)= iota_ng;
end

X     = [iota_x randn(str,n_obs,k_x-1)]; %included instruments
XX  = X'*X;
P_x = X*((XX)\X');
I_n = eye(n_obs);
M_x = I_n - P_x;      %demean operator

M_xD  = M_x*D;
M_xd  = M_x - M_xD*(M_xD'*M_xD)*M_xD';

Z_c   = orth(M_x*Z_c);
Z_i   = orth(M_xd*Z_i);

Z_c   = sqrt(n_obs)*(Z_c);  %(Z_d'*M_x*Z_d)/n_obs = eye(k_z)
Z_i   = sqrt(n_obs)*(Z_i);  %(V_d'*M_x*V_d)/n_obs = eye(k_z)

Z     = (sqrt(1-lambda)*Z_c + sqrt(lambda)*Z_i);

%--Checking
% ZMxZ  = Z'*M_x*Z;
% ZcMxZc= Z_c'*M_x*Z_c;
% ZiMxZi= Z_i'*M_x*Z_i;


% Residual heterogeneity term; het = 0 => homoskedatic case
nu  = ones(n_obs,1);
% Nu  = ones(n_obs,1);
W_G = zeros(n_obs,n_obs);
% W_I = zeros(n_obs,n_obs);

kappa = het;
for g=1:n_G
    g_in    = l_ini(g);
    g_end   = l_end(g);
    
    W_G(g_in:g_end,g_in:g_end)= 1;
    nu(g_in:g_end,1)= (1 + c*Z(g_in:g_end,1)).^kappa;
    
end

if (kappa==0)
    nu_adj = nu;
else
    sd_nu  = var(nu).^.5;
    nu_adj = nu./sd_nu;
end

% nu_bar     = mean(nu_adj);
% var_nu_bar = var(nu_adj);


W_I = diag(nu_adj.^2);
nu  = nu_adj; 





end
