function B = g_TSLS(beta, W_1, W_12, W_2)
    % g_TSLS computes maximal Nagar bias for given values of beta and variance-covariance matrix W. 
    % This step of the maximization is analytic.*/

        S_2 = W_2;
        S_12= W_12-beta*W_2;
        S_1 = W_1 -2*beta*W_12 +(beta^2)*W_2;
        
        L      = eig(0.5*(S_12 + S_12'));
        L      = real(L);
        mineig = min(L);
        maxeig = max(L);
        
        tr_S_1  = trace(S_1);
        tr_S_2  = trace(S_2);
        tr_S_12 = trace(S_12); 
        den     = sqrt(tr_S_2*tr_S_1);
        
		B = abs(tr_S_12 - 2*mineig);
		C = abs(tr_S_12 - 2*maxeig);
		B = max(B,C)/den;
		
end
