 function [resid_u, resid_v] = error_cluster_sim(resid_g, resid_i,n_G,sqrt_phi,sqrt_varphi,rho,vrho,arho,avrho,l_ini,l_end,iota_n,nu,Nu)
 % return the residuals of a cluster model
% resid_u       = residual second stage
% resid_v       = residual first stage
% resid_g       = n_G x size(resid_cluster,2) matrix  of cluster residuals
% resid_n       = n_obs x size(resid_idio,2) matrix of idiosyncractic residuals
% n_G           = number of clusters
% sqrt_omega    = vector with the heteroskedastic weight for the cluster
% error
% sqrt_varpi    = vector with the heteroskedastic weight for the
% idiosyncratic error
% l_ini         = vector with the initial values of each cluster   
% l_end         = vector with the final values of each cluster

% arho = sqrt(1-rho^2)
% avrho= sqrt(1-vrho^2)

res_cluster_1 = resid_g(:,1);
res_cluster_2 = resid_g(:,2);

res_idio_1 = resid_i(:,1);  
res_idio_2 = resid_i(:,2); 

for g=1:n_G
        u1 = nu(l_ini(g):l_end(g),1).*(sqrt_phi*iota_n(l_ini(g):l_end(g)))*res_cluster_1(g,1);
        u2 = Nu(l_ini(g):l_end(g),1).*(sqrt_varphi*res_idio_1(l_ini(g):l_end(g),1));
        
        e1 = sqrt_phi*iota_n(l_ini(g):l_end(g))*res_cluster_2(g,1);
        e2 = sqrt_varphi*res_idio_2(l_ini(g):l_end(g),1);
        
        resid_u(l_ini(g):l_end(g),1) = u1 + u2;
        resid_v(l_ini(g):l_end(g),1) = rho*u1 + vrho*u2 + arho*e1 + avrho*e2; 
end

end
