function  [f,K_eff] = eff_F_test_simp(Z,y2,I_n,v_G)
    % Computes the efficient F test using the most conservative case.
    % Z: excluded instruments
    % y2: first stage dependent variable
    % I_n: identity matrix of order n
    % v_G: number of observarions per cluster
    %-Normalize the Instruments to be orthogonal
    ZZ    = Z'*Z;
    Z     = Z/sqrtm(ZZ);
    ZZ    = Z'*Z;
    M_z   = I_n- Z*((ZZ)\Z');
    %-Estimate the asymptotic variance of Z'*V

    v_hat = M_z*y2;                  % Inneficient First-Stage Residual  
    q_hat = score(v_hat ,Z, v_G,'nr') ; 
    V_zv  = vscore(q_hat, q_hat, v_G);
    
    aux3  = Z'*y2;
    
    trace_W = trace(V_zv);
    trace_W2= trace_W^2;
    trace_WW= trace(V_zv'*V_zv);
    max_e_W = max(eig(V_zv));
    
    f       = (aux3'*aux3)/trace_W;  
    
    x=10;
    K_eff = trace_W2*(1+2*x)/(trace_WW + 2*x*trace_W*max_e_W);
end
