function [ ] = conf_set_civil(y1, y2, Z, X, theta_1, theta_2, n_G, v_G, n_boot, savefile)
%Compute the bootstrap confidence sets for Edward Miguel, Sahnker Satyanath
%and Ernest Sergenti "Economic Shocks and  Civil COnflit: an instrumental 
%variable approach"
%   y1 = civil war conflict dummy 
%   y2 = economic growth and lagged economic grouwth (endogenous
%   explanatory variables
%   Z  = rainfall precipitation 
%   X  = included instruments
%   theta_1= points in the parameter space
%   theta_2= points in the parameter space
%   n_G   = # of clusters
%   v_G   = # of observations per cluster

%% load the bootstrap random numbers.
[w_gamma, w_radem, ~] = civ_rand(n_G, n_boot);

Y2 = [y2 X];
W  = [Z X];

k_y2 = size(y2,2);    % # of endogenous  explanatory variables
k_z  = size(Z,2);     % # of excluded instruments
k_x  = size(X,2);     % # of included instruments
k_Y2 = size(Y2,2);    % # of explanatory variables
k_w  = k_z+k_x;       % # of instruments

n_obs = sum(v_G);                  % # of observations
n_hom = n_obs-k_w;                 % degrees of freedom, homoskedatic case

%--- Selection Indices
l_z  = 1:k_z;
l_wp = 1:(k_w*k_y2);
l_x  = k_z+1:k_w;
l_y2 = 1:k_y2;

iota_kw = ones(1,k_w);

I_n    = eye(n_obs);
I_kw   = eye(k_w); 
I_p    = eye(k_y2); 
Weight = zeros(n_obs);

XX  = X'*X;
XXX = XX\X';
WW  = W'*W;
iWW = WW\I_kw;       % or I_kw/WW 
IWW = kron(I_p,WW);
WWW = WW\W';
P_x = X*XXX;
P_w = W*WWW;
M_x = I_n - P_x;
M_w = I_n - P_w;

Pi_w     = WWW*y2;              % Inefficient First-Stage estimator 

Y2          = [y2 X];
[Par, aux2] = tsls_iv(Y2,y1,WWW, P_w);
e_tsls      = y1 - Y2*Par;
v_hat       = M_w*y2;                  % Inefficient First-Stage Residual

[~, VTsls]  = wald_cluster_iv(Par(l_y2),e_tsls,W,aux2,l_y2,v_G);

ct   = (n_G/(n_G-1))*((n_obs-1)/(n_obs-k_Y2)); % adjustment factor.
ctar = 1;%(n_G/(n_G-1))*((n_obs-1)/(n_obs-k_w) ); % adjustment factor AR test.

VTsls= ct*VTsls;

q_hat       = score(v_hat ,W, v_G,'nr') ;
V_hat_PiPi  = ctar*(IWW\vscore(q_hat, q_hat, v_G))/IWW;

% First-stage F tests
F1      = Pi_w(l_z,1)'*((V_hat_PiPi(l_z,l_z)\Pi_w(l_z,1)));
F1_k    = Pi_w(l_z,1)'*((V_hat_PiPi(l_z,l_z)\Pi_w(l_z,1)))/k_z;
pvalue1 = 1- chi2cdf(F1,k_z);
F2      = Pi_w(l_z,2)'*((V_hat_PiPi(k_w+l_z,k_w+l_z)\Pi_w(l_z,2)));
F2_k    = Pi_w(l_z,2)'*((V_hat_PiPi(k_w+l_z,k_w+l_z)\Pi_w(l_z,2)))/k_z;
pvalue2 = 1- chi2cdf(F2,k_z);

% Kleibergen and Paap rank test
l_zz   = [l_z k_w+l_z];
G      = I_p;
F      = I_p;
V_Pi_z = n_obs*V_hat_PiPi(l_zz,l_zz);
rk_pi  = 1;
test1  = ranktest_svd(Pi_w(l_z,l_z), F, G, V_Pi_z,rk_pi,n_obs); 
p_rank = 1- chi2cdf(test1, (k_z-rk_pi)*(k_y2-rk_pi));


sth_1   = size(theta_1,2);
sth_2   = size(theta_2,2);
ons_th1 = ones(sth_1,1);
ons_th2 = ones(sth_2,1);
theta   = [kron(ons_th2,theta_1') kron(theta_2',ons_th1)];
stheta  = size(theta,1); 


%matrix to store the results. omp states for one minus p-value.
omp_ar_asym  = NaN(stheta,1);
omp_ar_homo  = NaN(stheta,1);
omp_wald_asym= NaN(stheta,1);

omp_ar_g_EE0 = NaN(stheta,1);
omp_ar_g_SE0 = NaN(stheta,1);
omp_ar_g_DM  = NaN(stheta,1);
omp_ar_r_EE0 = NaN(stheta,1);
omp_ar_r_SE0 = NaN(stheta,1);
omp_ar_r_DM  = NaN(stheta,1);

omp_w_g_EME  = NaN(stheta,1);
omp_w_r_EME  = NaN(stheta,1);

n_ar_b  = 6;                       % # of ar bootstrap tests
n_w_b   = 3;                       % # of wald bootstrap tests

parfor i=1:stheta
% for i=1:stheta
    
    %II - Calculate the statistics
    th0       = theta(i,:)';
    
    %Wald Test
    par      = Par;
    Vtsls    = VTsls;
    th_tsls  = par(l_y2)-th0;
    wald_asym= th_tsls'*(Vtsls(l_y2,l_y2)\th_tsls);
    
    Y0       = y1 - y2*th0;
    g0_ols   = XXX*Y0;
    parr     = [th0; g0_ols]; % constrained TSLS estimator
    
    delta_w  = WWW*Y0;                 % unrestricted estimator
    e_til    = M_x*Y0;                 % e_til = e_tsls0  = y1 - Y2*parr;
    e_hat    = M_w*Y0;
    v_hat    = M_w*y2;                 % Inefficient First-Stage Residual
    
    V_hom_deldel = ((e_hat'*e_hat)/n_hom)*iWW;
    
    h_til   = score(e_til ,W, v_G,'nr') ;
    q_hat   = score(v_hat ,W, v_G,'nr') ;
    
    V_til_deldel = (WW\vscore(h_til, h_til, v_G))/WW;
    V_til_Pidel  = (IWW\vscore(q_hat, h_til, v_G))/WW;
    
    Pi_w1     = Pi_w;
    pi_til_w0 = Pi_w1(:) - V_til_Pidel(l_wp,l_z)*(V_til_deldel(l_z,l_z)\delta_w(l_z));
    Pi_til_w0 = reshape(pi_til_w0,k_w,k_y2);
    
    v_til0 = y2 - W*Pi_til_w0;
    
    %--- gamma MD estimator under H0:   (g0_gmm = g0_md)
    g0_md    = delta_w(l_x) - V_til_deldel(l_x,l_z)*(V_til_deldel(l_z,l_z)\delta_w(l_z));
   
    
    %---Efficient residuals
    e_til0 = Y0 - X*g0_md;              % e_til0=Y0-X*g0_gmm or e_til0=Y0-W*delta_w0
    h_til0c= score(e_til0 ,W, v_G,'r'); % recentered score for the score bootstrap
    
    ar_asym    = delta_w(l_z)'*((ctar*V_til_deldel(l_z,l_z))\delta_w(l_z));
    ar_homo    = delta_w(l_z)'*(V_hom_deldel(l_z,l_z)\delta_w(l_z));
    
    omp_wald_asym(i,1) = wald_asym;
    omp_ar_asym(i,1)   = ar_asym;
    omp_ar_homo(i,1)   = ar_homo;
    
    wald_b  = zeros(n_boot,n_w_b);
    ar_b    = zeros(n_boot,n_ar_b);
    
    w_gamma1= w_gamma;
    w_radem1= w_radem;
    
    for b = 1:n_boot
        
        wg = w_gamma1(:,b);
        wr = w_radem1(:,b);
        
        %---gamma under H0: g0 = g0_md = g0_gmm
        %--Gamma weight
        ar_b(b,1) =  boot_score_ar(wg, iota_kw, h_til0c, WW, v_G, l_z,ctar);
        %--Rademacher weight
        ar_b(b,2) =  boot_score_ar(wr, iota_kw, h_til0c, WW, v_G, l_z,ctar);
        
        %% Weights - Residual Bootstraps
        W_Wild_g     = w_matrix(n_G, wg, I_n, Weight, v_G);
        W_Wild_r     = w_matrix(n_G, wr, I_n, Weight, v_G);
        
        %% Single Equation Residual Bootstrap. Under H0: g0 = XHX\(X'H*Y0)
        %--Gamma weight
        ar_b(b,3)  =  boot_se_ar(e_til0,W_Wild_g,M_x,W,WW,WWW, v_G,l_z,ctar);
        %-- Rademacher weight
        ar_b(b,4)  =  boot_se_ar(e_til0,W_Wild_r,M_x,W,WW,WWW, v_G,l_z,ctar);
        
        %% Davidson&MacKinnon Efficient Restricted Bootstrap
        %--- Sampled at cluster level, computed using the homoskedastic version of the weak-IV tests
        %--Gamma weight
        ar_b(b,5)  = boot_me_dm_ar(e_til,W_Wild_g,M_w,iWW,WWW,l_z,n_hom);
        %--Rademacher weight
        ar_b(b,6) = boot_me_dm_ar(e_til,W_Wild_r,M_w,iWW,WWW,l_z,n_hom);
        
        %% Wald residual bootstrap
        %-- DGP based imposing the null in the first and  second stages
        %--Gamma weight
        wald_b(b,1)= boot_me_wald_adj(e_til,v_til0,W_Wild_g,X,W,WWW,P_w,l_y2,Pi_til_w0,parr,v_G,ct);
        %--Rademacher weight
        wald_b(b,2)= boot_me_wald_adj(e_til,v_til0,W_Wild_r,X,W,WWW,P_w,l_y2,Pi_til_w0,parr,v_G,ct);
        
    end
    

    ws_ar  = mean(ar_b(:,1:4)<ar_asym);
    omp_ar_g_EE0(i,1) = ws_ar(1, 1);
    omp_ar_r_EE0(i,1) = ws_ar(1, 2);
    omp_ar_g_SE0(i,1) = ws_ar(1, 3);
    omp_ar_r_SE0(i,1) = ws_ar(1, 4);
    
    ws_ar_dm  = mean(ar_b(:,5:6)<ar_homo);
    omp_ar_g_DM(i,1) = ws_ar_dm(1,1);
    omp_ar_r_DM(i,1) = ws_ar_dm(1,2);
    
    ws_w  = mean(wald_b(:,1:2)<wald_asym);
    omp_w_g_EME(i,1) = ws_w(1,1);
    omp_w_r_EME(i,1) = ws_w(1,2);
end

omp_wald_asym  = chi2cdf(omp_wald_asym(:,1),k_y2);
omp_ar_asym    = chi2cdf(omp_ar_asym(:,1),k_z);
omp_ar_homo    = chi2cdf(omp_ar_homo(:,1),k_z);

omp_Wald_asym  = reshape(omp_wald_asym ,sth_1,sth_2);
omp_AR_asym    = reshape(omp_ar_asym   ,sth_1,sth_2);
omp_AR_homo    = reshape(omp_ar_homo   ,sth_1,sth_2);

            
omp_Wald_g_EME = reshape(omp_w_g_EME  ,sth_1,sth_2);
omp_Wald_r_EME = reshape(omp_w_r_EME  ,sth_1,sth_2);

omp_AR_g_EE0   = reshape(omp_ar_g_EE0 ,sth_1,sth_2);
omp_AR_g_SE0   = reshape(omp_ar_g_SE0 ,sth_1,sth_2);
omp_AR_g_DM    = reshape(omp_ar_g_DM  ,sth_1,sth_2);
omp_AR_r_EE0   = reshape(omp_ar_r_EE0 ,sth_1,sth_2);
omp_AR_r_SE0   = reshape(omp_ar_r_SE0 ,sth_1,sth_2);
omp_AR_r_DM    = reshape(omp_ar_r_DM  ,sth_1,sth_2);


ind_W_asym_th_1  = ind_bounds(min(omp_Wald_asym,[],2)   <=.95);
ind_W_asym_th_2  = ind_bounds(min(omp_Wald_asym,[],1)'  <=.95);
ind_W_g_EME_th_1 = ind_bounds(min(omp_Wald_g_EME,[],2)  <=.95);
ind_W_g_EME_th_2 = ind_bounds(min(omp_Wald_g_EME,[],1)' <=.95);
ind_W_r_EME_th_1 = ind_bounds(min(omp_Wald_r_EME,[],2)  <=.95);
ind_W_r_EME_th_2 = ind_bounds(min(omp_Wald_r_EME,[],1)' <=.95);

ind_AR_homo_th_1  = ind_bounds(min(omp_AR_homo,[],2)   <=.95);
ind_AR_homo_th_2  = ind_bounds(min(omp_AR_homo,[],1)'  <=.95);
ind_AR_asym_th_1  = ind_bounds(min(omp_AR_asym,[],2)   <=.95);
ind_AR_asym_th_2  = ind_bounds(min(omp_AR_asym,[],1)'  <=.95);

ind_AR_g_EE0_th_1 = ind_bounds(min(omp_AR_g_EE0,[],2)  <=.95);
ind_AR_g_EE0_th_2 = ind_bounds(min(omp_AR_g_EE0,[],1)' <=.95);
ind_AR_g_SE0_th_1 = ind_bounds(min(omp_AR_g_SE0,[],2)  <=.95);
ind_AR_g_SE0_th_2 = ind_bounds(min(omp_AR_g_SE0,[],1)' <=.95);
ind_AR_g_DM_th_1  = ind_bounds(min(omp_AR_g_DM,[],2)   <=.95);
ind_AR_g_DM_th_2  = ind_bounds(min(omp_AR_g_DM,[],1)'  <=.95);

ind_AR_r_EE0_th_1 = ind_bounds(min(omp_AR_r_EE0,[],2)  <=.95);
ind_AR_r_EE0_th_2 = ind_bounds(min(omp_AR_r_EE0,[],1)' <=.95);
ind_AR_r_SE0_th_1 = ind_bounds(min(omp_AR_r_SE0,[],2)  <=.95);
ind_AR_r_SE0_th_2 = ind_bounds(min(omp_AR_r_SE0,[],1)' <=.95);
ind_AR_r_DM_th_1  = ind_bounds(min(omp_AR_r_DM,[],2)   <=.95);
ind_AR_r_DM_th_2  = ind_bounds(min(omp_AR_r_DM,[],1)'  <=.95);



diary off 

diary(['results' '/' savefile '.txt'])

fprintf(1, '\n      95%% Confidence Intervals  theta_1         \n' );

fprintf(1, 'wald_asym  | %8.2f  %8.2f  |  \n',  theta_1(ind_W_asym_th_1   ));
fprintf(1, 'wald_g_EME | %8.2f  %8.2f  |  \n',  theta_1(ind_W_g_EME_th_1  ));
fprintf(1, 'wald_r_EME | %8.2f  %8.2f  |  \n',  theta_1(ind_W_r_EME_th_1  ));
                                                     
fprintf(1, 'ar_homo    | %8.2f  %8.2f  |  \n',  theta_1(ind_AR_homo_th_1  ));
fprintf(1, 'ar_asym    | %8.2f  %8.2f  |  \n',  theta_1(ind_AR_asym_th_1  ));
fprintf(1, 'ar_g_EE0   | %8.2f  %8.2f  |  \n',  theta_1(ind_AR_g_EE0_th_1 ));
fprintf(1, 'ar_r_EE0   | %8.2f  %8.2f  |  \n',  theta_1(ind_AR_r_EE0_th_1 ));
fprintf(1, 'ar_g_SE0   | %8.2f  %8.2f  |  \n',  theta_1(ind_AR_g_SE0_th_1 ));
fprintf(1, 'ar_r_SE0   | %8.2f  %8.2f  |  \n',  theta_1(ind_AR_r_SE0_th_1 ));
fprintf(1, 'ar_g_DM    | %8.2f  %8.2f  |  \n',  theta_1(ind_AR_g_DM_th_1  ));
fprintf(1, 'ar_r_DM    | %8.2f  %8.2f  |\n\n',  theta_1(ind_AR_r_DM_th_1  ));

fprintf(1, '\n      95%% Confidence Intervals  theta_2         \n' );

fprintf(1, 'wald_asym  | %8.2f  %8.2f  |  \n',  theta_2(ind_W_asym_th_2   ));
fprintf(1, 'wald_g_EME | %8.2f  %8.2f  |  \n',  theta_2(ind_W_g_EME_th_2  ));
fprintf(1, 'wald_r_EME | %8.2f  %8.2f  |  \n',  theta_2(ind_W_r_EME_th_2  ));
                                                     
fprintf(1, 'ar_homo    | %8.2f  %8.2f  |  \n',  theta_2(ind_AR_homo_th_2  ));
fprintf(1, 'ar_asym    | %8.2f  %8.2f  |  \n',  theta_2(ind_AR_asym_th_2  ));
fprintf(1, 'ar_g_EE0   | %8.2f  %8.2f  |  \n',  theta_2(ind_AR_g_EE0_th_2 ));
fprintf(1, 'ar_r_EE0   | %8.2f  %8.2f  |  \n',  theta_2(ind_AR_r_EE0_th_2 ));
fprintf(1, 'ar_g_SE0   | %8.2f  %8.2f  |  \n',  theta_2(ind_AR_g_SE0_th_2 ));
fprintf(1, 'ar_r_SE0   | %8.2f  %8.2f  |  \n',  theta_2(ind_AR_r_SE0_th_2 ));
fprintf(1, 'ar_g_DM    | %8.2f  %8.2f  |  \n',  theta_2(ind_AR_g_DM_th_2  ));
fprintf(1, 'ar_r_DM    | %8.2f  %8.2f  |\n\n',  theta_2(ind_AR_r_DM_th_2  ));

                      
fprintf(1, 'f1_asym    | %8.2f  %8.2f  |  \n'  , F1 , F1_k) ;
fprintf(1, 'f2_asym    | %8.2f  %8.2f  |\n\n'  , F2 , F2_k) ;
fprintf(1, 'rank_asym  | %8.2f         |  \n'  , test1);


fprintf(1, 'pf1_asym   | %8.3f   \n',  pvalue1   );
fprintf(1, 'pf2_asym   | %8.3f   \n',  pvalue2   );
fprintf(1, 'p_rank     | %8.3f   \n',  p_rank    );

diary off                              

 

save(['results' '/' savefile],'theta_1', 'theta_2','omp_W*','omp_A*','F*','pvalue*','p_rank','ind*');

