function [w_gamma, w_radem, w_ind] = civ_rand(n_G,n_boot)

% Generate bootstrap weights
% n_G   : number of clusters
% n_boot: number of bootstrap samples 

%--- Parameters of the Gamma Distribution (wild bootstrap)
Alpha  =  4; 
Beta   = .5;


%--- Generate Random numbers outside of the loop.
st      ={ RandStream('swb2712','Seed',590)  ;
           RandStream('mt19937ar','Seed',3)  ;
           RandStream('mt19937ar','Seed',4110);
           RandStream('mt19937ar','Seed',9540)};

%--- Weight Wild Boostrap
w_gamma   = gaminv(rand(st{3},n_G,n_boot),Alpha,Beta) - Alpha*Beta;

w_radem  = 2*binoinv(rand(st{2},n_G,n_boot),1,0.5)-1;

w_ind    = randi(st{4},n_G, n_G,n_boot); % random integers for pairs bootstrap

