function Ds  = boot_sample(D, k, so, si,NG)
% D  = [y1 y2 W] matrix where:   
% y1 = endogenous dependent variable       n x 1   vector
% y2 = endogenous explanatory variable     n x p   matrix
% Z  = matrix of excluded instruments      n x k.z matrix
% X  = matrix of included instruments      n x k.x matrix
% w  = sampled cluster                     G x 1   vector
% Dbb= zero matrix                     n.obs x (k.y+k.w) matrix  
% NG = # of observation in each cluster

G   = size(NG,1);     % number of cluster
gii = 1;
gfi = 0;
% l_ini = cumsum(NG) - NG + 1;
% l_end = cumsum(NG);
n_obs = sum(NG);
Dbb   = zeros(n_obs,k);
 for g = 1:G
    gfi    = gfi + NG(g);  
    gi     = so(g);
    gf     = si(g);             
    Dbb(gii:gfi,:) = D(gi:gf,:);  
    gii    = gfi+1;
 end
 
 Ds = Dbb;

end
