 function [V_deldel, V_Pidel, V_PiPi]  = boot_res(e,v,W,WW,IWW,NG)
%   = [Y0 y2 Z X] matrix where:   
% Y0 = y1-y2*\theta_0                      n x 1   vector
% y2 = endogenous explanatory variable     n x p   matrix
% Z  = matrix of excluded instruments      n x k.z matrix
% X  = matrix of included instruments      n x k.x matrix
% y2 = endogenous explatory variable       n x p   matrix
% del_w = OLS estimator unrestricted model
% I   =  eye(p)
% col= vector with the columns # of variables        
% NG = # of observation in each cluster n.G x 1 vector
% Small sample adjustaments is outside of the function
% 

h        = score(e,W,NG,'nr')  ;
q        = score(v,W,NG,'nr')  ;
V_deldel = WW\(vscore( h, h, NG)/WW);
V_Pidel  = IWW\(vscore( q, h, NG)/WW);
V_PiPi   = IWW\(vscore( q, q, NG)/IWW);
end
