 function wald  = boot_pairs_wald(D,par,col,l_y2,v_G)
% D  = [Y0 y2 W] matrix where:   
% Y0 = y1-y2*\theta_0                      n x 1   vector
% y2 = endogenous explanatory variable     n x p   matrix
% Z  = matrix of excluded instruments      n x k.z matrix
% X  = matrix of included instruments      n x k.x matrix
% I   =  eye(p)
% col= vector with the columns # of variables        
% NG = # of observation in each cluster n.G x 1 vector
% Small sample adjustaments is outside of the function
% 

y1      = D(:,1:col(1));
y2      = D(:,col(1)+1:col(2));
Z       = D(:,col(2)+1:col(3));
X       = D(:,col(3)+1:col(4));

Y2   = [y2 X];

W       = [Z X];
WW      = W'*W;
WWW     = WW\W';
P_w     = W*WWW;

[parb,aux2] = tsls_iv(Y2,y1,WWW, P_w);

e   = y1 - Y2*parb;

wald = wald_cluster_iv(parb(l_y2) - par(l_y2),e,W,aux2,l_y2,v_G);


end
