 function [delta_w, pi_w0_hat, V_deldel,V_Pidel, V_PiPi]  = boot_pairs(D,th0, I, col, lz,lw,NG)
% D  = [y1 y2 W] matrix where:   
% Y0 = y1-y2*\theta_0                      n x 1   vector
% y2 = endogenous explanatory variable     n x p   matrix
% Z  = matrix of excluded instruments      n x k.z matrix
% X  = matrix of included instruments      n x k.x matrix
% I   =  eye(p)
% col= vector with the columns # of variables        
% NG = # of observation in each cluster n.G x 1 vector
% Small sample adjustaments is outside of the function
% 

y1      = D(:,1:col(1));
y2      = D(:,col(1)+1:col(2));
Z       = D(:,col(2)+1:col(3));
X       = D(:,col(3)+1:col(4));

XX      = X'*X;
W       = [Z X];
WW      = W'*W;
IWW     = kron(I,WW);

Y0      = y1-y2*th0;

delta_w = WW\(W'*Y0);
gam0    = XX\(X'*Y0);
Pi_w    = WW\(W'*y2);

e       = Y0-X*gam0;
v       = y2-W*Pi_w;

h       = score(e,W,NG,'nr');
q       = score(v,W,NG,'nr');

V_deldel  = (WW\vscore( h, h, NG))/WW;
V_Pidel   = (IWW\vscore(q, h, NG))/WW;
V_PiPi    = (IWW\vscore( q, q, NG))/IWW;

pi_w0_hat = Pi_w(:) - V_Pidel(lw,lz)*(V_deldel(lz,lz)\delta_w(lz));
                
% V_deldel  = V.deldel;

end
