 function wald  = boot_me_wald_adj(e,v,W_Wild,X,W,WWW,P_w,l_y2,Pi_w,par,v_G,ct)
%   = [Y0 y2 Z X] matrix where:   
% Y0 = y1-y2*\theta_0                      n x 1   vector
% y2 = endogenous explanatory variable     n x p   matrix
% Z  = matrix of excluded instruments      n x k.z matrix
% X  = matrix of included instruments      n x k.x matrix
% y2 = endogenous explatory variable       n x p   matrix
% del_w = OLS estimator unrestricted model
% I   =  eye(p)
% col= vector with the columns # of variables        
% NG = # of observation in each cluster n.G x 1 vector
% Small sample adjustaments is outside of the function
% 

e    = W_Wild*e;
v    = W_Wild*v;
Y2   = [(W*Pi_w+v) X];
y1   = Y2*par + e;

[parb,aux2]= tsls_iv(Y2,y1,WWW, P_w);

% aux1 = Y2'*P_w*Y2;
% aux2 = (WWW*Y2)/aux1;
% parb = aux1\(Y2'*P_w*y1);
eb   = y1 - Y2*parb;

wald = wald_cluster_iv_adj(parb(l_y2) - par(l_y2),eb,W,aux2,l_y2,v_G,ct);


end
