 function [ar]  = boot_me_dm_ar(e,W_Wild,M_w,iWW,WWW,l_z,n_hom)
%   = [Y0 y2 Z X] matrix where:   
% Y0 = y1-y2*\theta_0                      n x 1   vector
% y2 = endogenous explanatory variable     n x p   matrix
% Z  = matrix of excluded instruments      n x k.z matrix
% X  = matrix of included instruments      n x k.x matrix
% y2 = endogenous explatory variable       n x p   matrix
% del_w = OLS estimator unrestricted model
% I   =  eye(p)
% col= vector with the columns # of variables        
% NG = # of observation in each cluster n.G x 1 vector
% Small sample adjustaments is outside of the function
% 

e     = W_Wild*e; % bootstrapped errors
Delta = WWW*e;         % Delta = delta_boot - delta_wr where delta_til = delta_wr +  WW\(W'*e_wtil);
eb    = M_w*e;

V_deldel =  ((eb'*eb)/n_hom)*iWW;

ar    = ar_only(Delta(l_z), V_deldel(l_z,l_z));


end
