 function [ar, k, j]  = boot_me_dm(e,v,W_Wild,M_w,iWW,WWW,l_w,l_z,l_y2,Pi_w,k_w,k_y2,n_hom)
%   = [Y0 y2 Z X] matrix where:   
% Y0 = y1-y2*\theta_0                      n x 1   vector
% y2 = endogenous explanatory variable     n x p   matrix
% Z  = matrix of excluded instruments      n x k.z matrix
% X  = matrix of included instruments      n x k.x matrix
% y2 = endogenous explatory variable       n x p   matrix
% del_w = OLS estimator unrestricted model
% I   =  eye(p)
% col= vector with the columns # of variables        
% NG = # of observation in each cluster n.G x 1 vector
% Small sample adjustaments is outside of the function
% 

e     = W_Wild*e; % bootstrapped errors
v     = W_Wild*v;
Delta = WWW*e;         % Delta = delta_boot - delta_wr where delta_til = delta_wr +  WW\(W'*e_wtil);
Pi_wb = Pi_w +  WWW*v; % or Pi_w  + WW\(sum(q_what))'

eb    = M_w*e;
vb    = M_w*v;

V_deldel =  ((eb'*eb)/n_hom)*iWW;
V_Pidel  =  kron(((vb'*eb)/n_hom),iWW);
% V_PiPi   =  kron(((vb'*vb)/n_hom),iWW);

pi_w0 = Pi_wb(:) -  V_Pidel(l_w,l_z)*(V_deldel(l_z,l_z)\Delta(l_z));
Pi_w0 = reshape(pi_w0,k_w,k_y2);

[ar, k, j] = ar_k_j(Delta(l_z), V_deldel(l_z,l_z), Pi_w0(l_z,l_y2));

% 
% f     = (Pi_wb(l_z)-Pi_w(l_z))'*...
%               (V_PiPi(l_z,l_z)\(Pi_wb(l_z)-Pi_w(l_z)))/k_z;
%           
%         e_w      = e_wtil;        % bootstrap restricted residuals
%         v_whom0  = W_Wild*v_hom0; % bootstrap restricted residuals
%         e_whom0b = M_w*e_wtil;
%         v_whom0b = M_w*v_whom0;
%         [V_deldel, V_Pidel, V_PiPi]= vhom(e_whom0b,v_whom0b,n_hom,iWW);
%         
% 
%         V_delPi  = V_Pidel';
%         
%         delta_til = delta_wr +  WW\(W'*e_wtil);
%         Pi_wb     = Pi_hom_w0 + WW\(W'*v_whom0);
%         pi_w0     = Pi_wb(:) - V_Pidel(l_w,l_z)*(V_deldel(l_z,l_z)\delta_til(l_z));
%         Pi_w0     = reshape(pi_w0,k_w,k_y2);
%         
%         V_rank  = V_PiPi - V_Pidel(l_w,l_z)*(V_deldel(l_z,l_z)\V_delPi(l_z,l_w));
%         rk_w0   = Pi_w0(l_z,l_y2)'*(V_rank(l_z,l_z)\Pi_w0(l_z,l_y2));
%         
%         [ar_b(b,8), k_b(b,8), j_b(b,8)]= ar_k_j(delta_til(l_z), V_deldel(l_z,l_z), Pi_w0(l_z,l_y2));
%         clr_b(b,8) = clr(ar_b(b,8),j_b(b,8),rk_w0);          


end
