 function [ar, k, j]  = boot_me(e,v,W_Wild,M_x,M_w,W,WW,WWW,IWW, NG,l_w,l_z,l_y2,Pi_w,k_w, k_y2)
%  [ar, k, j, f, y2]
%   = [Y0 y2 Z X] matrix where:   
% Y0 = y1-y2*\theta_0                      n x 1   vector
% y2 = endogenous explanatory variable     n x p   matrix
% Z  = matrix of excluded instruments      n x k.z matrix
% X  = matrix of included instruments      n x k.x matrix
% y2 = endogenous explatory variable       n x p   matrix
% del_w = OLS estimator unrestricted model
% I   =  eye(p)
% col= vector with the columns # of variables        
% NG = # of observation in each cluster n.G x 1 vector
% Small sample adjustaments is outside of the function
% 

e     = W_Wild*e; % bootstrapped errors
v     = W_Wild*v;
Delta = WWW*e;         % Delta = delta_til- delta_wr where delta_til = delta_wr +  WW\(W'*e_wtil);
Pi_wb = Pi_w +  WWW*v; % or Pi_w  + WW\(sum(q_what))'

eb    = M_x*e;
vb    = M_w*v;
h     = score(eb,W,NG,'nr');
q     = score(vb,W,NG,'nr');

V_deldel = WW\(vscore( h, h, NG)/WW);
V_Pidel  = IWW\(vscore( q, h, NG)/WW);

pi_w0 = Pi_wb(:) -  V_Pidel(l_w,l_z)*(V_deldel(l_z,l_z)\Delta(l_z));
Pi_w0 = reshape(pi_w0,k_w,k_y2);

[ar, k, j] = ar_k_j(Delta(l_z), V_deldel(l_z,l_z), Pi_w0(l_z,l_y2));

end
