function  [f, K_eff, x, K_eff_simp, x_simp] = F_test_eff(Z,y1,y2,I_n,v_G,tau,brange)
    % Computes the efficient F test using the most conservative case.
    % Z, y1 and y2 enter as projections errors onto the included
    % instruments
    % Z: excluded instruments 
    % y1: dependent variable
    % y2: endogenous explanatory variable
    % I_n: identity matrix of order n
    % v_G: number of observarions per cluster
    % tau: Nagar bias threshold
    % eps: fraction error between g_TSLS and lim g_TSLS, as beta->+/- infty
    % points: number of points between +/-beta_range to set the starting point for maximization 
    %-Normalize the Instruments to be orthogonal
    Z     = orth(Z);
    ZZ    = Z'*Z;
    P_z   = Z*((ZZ)\Z');
    M_z   = I_n- P_z;
    %-Estimate the asymptotic variance of Z'*V
    e_hat = M_z*y1;
    v_hat = M_z*y2;                  % Inneficient First-Stage Residual
    f_hat = score(e_hat ,Z, v_G,'nr');
    q_hat = score(v_hat ,Z, v_G,'nr'); 

    W_11  = vscore(f_hat, f_hat, v_G);
    W_12  = vscore(f_hat, q_hat, v_G);
    W_22  = vscore(q_hat, q_hat, v_G);
    
    aux3  = Z'*y2;
    
    trace_W_22 = trace(W_22);
        
    f          = (aux3'*aux3)/trace_W_22;  
    
    tr_W_22_sq= trace_W_22^2;
    tr_WW_22  = trace(W_22'*W_22);
    max_e_W_22= max(eig(W_22));
    
    
    %-Initial range for searching beta the parameter for the maximization
    %--Find the upper and lower limits of beta range
      
    %brange     =  BTSLS_range_simulation(W_11, W_12, W_22, eps, brange_max);
    %--Grid search method over equally spaced points between -brange and brange
        
%     [~,bstart]  =  BTSLS_start(brange, W_11, W_12, W_22, points); 
    
    %--find beta that maximizes the objective function
    lb  = -brange;
    ub  = brange;
    A   = [];
    b   = [];
    Aeq = [];
    beq = [];
    fun = @(beta)(-g_TSLS(beta, W_11, W_12, W_22));    
%     x0  = bstart;
    x0  = 0;
   
    options = psoptimset('Display','off','SearchMethod',@searchneldermead);  
     
     
    [~, fmin] = patternsearch(fun,x0,A,b,Aeq,beq,lb,ub,options);
        
    %-compute the modified degrees of freedom
    x     = -fmin/tau;
    K_eff = (tr_W_22_sq*(1+2*x))/(tr_WW_22 + 2*x*trace_W_22*max_e_W_22);
        
    %-compute the simplified version of the test    
    x_simp     = 1/tau;
    K_eff_simp = tr_W_22_sq*(1+2*x_simp)/(tr_WW_22 + 2*x_simp*trace_W_22*max_e_W_22);
   
end
