function [cv_CLRt] = Cvalue_CLR(m,k,alpha, rank)
%pvalue_CLR returns the p-value for CLR tests
%   m        = number of tested parameters
%    k       = number of overidentification restrictions
% alpha      = vector of significance level
%  rank      = vector of rank statistics


%---Table: Critical values for GenS-S and GenStilde-S tests
tabCLR  = importdata('table_CLR.mat');
TabCLR  = squeeze(tabCLR(m,k,:,[1 1+200*(1-alpha)] )) ; 
clear tabCLR
sa           =length(alpha);
N            = size(rank,1);
cv_CLRt      = zeros(N,sa);
si           = 2;
sl           = size(TabCLR,1);
ones_tab     = ones(sl-si+1,1);
loc_tau      = TabCLR(si:sl,1);
for n=1:N
  sst         = sum(loc_tau < ones_tab*rank(n,1))+1;
  cv_CLRt(n,:)= TabCLR(sst,2:sa+1);
end

end

