function [b_start, g_TSLS_] = BTSLS_start(brange, W_11, W_12, W_22, points)
% /*Evaluate g_TSLS at equally spaced points.*/
% bstart = beta initial value
% points = number of points points between -bstart and bstart;

bstart_0 = - brange;
b_0      = bstart_0; 
delta    = brange/points;

%/*Evaluate g_TSLS at points equally spaced values and return the maximizing beta.*/
g_TSLS_0 = g_TSLS(bstart_0, W_11, W_12, W_22);
while (bstart_0<=brange)
    
    bstart_1 = bstart_0 + delta;
    g_TSLS_1 = g_TSLS(bstart_1, W_11, W_12, W_22);
    
    g_TSLS_ = max(g_TSLS_1,g_TSLS_0);
    
    if (g_TSLS_1 < g_TSLS_)
        b_start= b_0;
        
    else
        b_start = bstart_1;
        b_0   = b_start;
    end
    
    bstart_0 = bstart_1;
    g_TSLS_0 = g_TSLS_;  
    
    
end

end