function brange = BTSLS_range_test(W_1, W_12, W_22, eps)
% BTSLS_start computes the start point of maximization for given variance-covariance matrix W and deviation parameter eps.*/
% eps = the maximal fractional deviation of B from the limit as beta goes to infinity; default value eps=0.001.*/{

L      = eig(W_22);
L      = real(L);
eigmin = min(L);

%/*Limit_g_TSLS is the limit of g_TSLS as beta approaches +/- infinity. We then find a range [-bstart,bstart]
% so that g_TSLS(bstart) and g_TSLS(-bstart) are within a fraction eps of Limit_g_TSLS

Limit_g_TSLS = 1-(2*eigmin/trace(W_22));

brange    = 0;

g_bstart_plus  = g_TSLS(brange,W_1,W_12,W_22);
g_bstart_minus = g_TSLS(-brange,W_1,W_12,W_22);

ratio_plus  = g_bstart_plus/Limit_g_TSLS;
ratio_minus = g_bstart_minus/Limit_g_TSLS;

val = max(abs(ratio_plus-1), abs(ratio_minus-1));

% If val differs from Limit_g_TSLS by more than a fraction eps, increase betastart until condition is satisfied.
while (val>eps)
    
    g_bstart_plus  = g_TSLS( brange,W_1,W_12,W_22);
    g_bstart_minus = g_TSLS(-brange,W_1,W_12,W_22);
    
    ratio_plus  = g_bstart_plus/Limit_g_TSLS;
    ratio_minus = g_bstart_minus/Limit_g_TSLS;
    
    val       = max(abs(abs(ratio_plus)-1), abs(abs(ratio_minus)-1));
    brange    = brange+1;
end

end


