%Size Cluster IV Bootstrap Paper
clc;
clear;

cd '.../_boot_simulation/nG_20/lognormal'

%--Change 'kz_5'   to 'kz_2', 'kz_10' or 'kz_15' for results with 2, 10 or 15 excluded instruments


label_gauss_rho20   = {'kz_5/boot_lamb1_phi50_mu1_rho20_het0_fix1_gauss.mat' 'kz_5/boot_lamb1_phi50_mu180_rho20_het0_fix1_gauss.mat';
                       'kz_5/boot_lamb1_phi50_mu1_rho20_het1_fix1_gauss.mat' 'kz_5/boot_lamb1_phi50_mu180_rho20_het1_fix1_gauss.mat';
					   'kz_5/boot_lamb1_phi50_mu1_rho20_het2_fix1_gauss.mat' 'kz_5/boot_lamb1_phi50_mu180_rho20_het2_fix1_gauss.mat';
					   };                                                					   

label_gauss_rho50   = {'kz_5/boot_lamb1_phi50_mu1_rho50_het0_fix1_gauss.mat' 'kz_5/boot_lamb1_phi50_mu180_rho50_het0_fix1_gauss.mat';
                       'kz_5/boot_lamb1_phi50_mu1_rho50_het1_fix1_gauss.mat' 'kz_5/boot_lamb1_phi50_mu180_rho50_het1_fix1_gauss.mat';
					   'kz_5/boot_lamb1_phi50_mu1_rho50_het2_fix1_gauss.mat' 'kz_5/boot_lamb1_phi50_mu180_rho50_het2_fix1_gauss.mat';
					   };                                                					   

label_gauss_rho70   = {'kz_5/boot_lamb1_phi50_mu1_rho70_het0_fix1_gauss.mat' 'kz_5/boot_lamb1_phi50_mu180_rho70_het0_fix1_gauss.mat';
                       'kz_5/boot_lamb1_phi50_mu1_rho70_het1_fix1_gauss.mat' 'kz_5/boot_lamb1_phi50_mu180_rho70_het1_fix1_gauss.mat';
					   'kz_5/boot_lamb1_phi50_mu1_rho70_het2_fix1_gauss.mat' 'kz_5/boot_lamb1_phi50_mu180_rho70_het2_fix1_gauss.mat';
					   };                                                					   
					   
label_gauss_rho95   = {'kz_5/boot_lamb1_phi50_mu1_rho95_het0_fix1_gauss.mat' 'kz_5/boot_lamb1_phi50_mu180_rho95_het0_fix1_gauss.mat';
                       'kz_5/boot_lamb1_phi50_mu1_rho95_het1_fix1_gauss.mat' 'kz_5/boot_lamb1_phi50_mu180_rho95_het1_fix1_gauss.mat';
					   'kz_5/boot_lamb1_phi50_mu1_rho95_het2_fix1_gauss.mat' 'kz_5/boot_lamb1_phi50_mu180_rho95_het2_fix1_gauss.mat';
					   };                                                					   
					   
					   
					   
kappa     = [0 1 2];
si_kappa  = length(kappa);      
mu        = [0.1 18];
si_mu     = length(mu);
rho       = [0.20 0.50 0.70 0.95]; 
si_rho    = length(rho);
alpha     =  5;  % significance level
si_alpha  = size(alpha,2);

ar_test_homo = zeros (si_kappa,si_mu,si_rho)  ; k_test_homo = zeros (si_kappa,si_mu,si_rho)  ; clr_test_homo = zeros(si_kappa,si_mu,si_rho) ;  f_test_asym      = zeros(si_kappa,si_mu,si_rho);  
ar_test_asym = zeros (si_kappa,si_mu,si_rho)  ; k_test_asym = zeros (si_kappa,si_mu,si_rho)  ; clr_test_asym = zeros(si_kappa,si_mu,si_rho) ;  f_test_IME       = zeros(si_kappa,si_mu,3,si_rho);  
ar_test_EE   = zeros (si_kappa,si_mu,4,si_rho); k_test_EE   = zeros (si_kappa,si_mu,4,si_rho); clr_test_EE   = zeros(si_kappa,si_mu,4,si_rho); f_test_pairs     = zeros(si_kappa,si_mu,si_rho);    
ar_test_EE0  = zeros (si_kappa,si_mu,4,si_rho); k_test_EE0  = zeros (si_kappa,si_mu,4,si_rho); clr_test_EE0  = zeros(si_kappa,si_mu,4,si_rho); eff_f_test_asym  = zeros(si_kappa,si_mu, si_rho);                        
ar_test_SE   = zeros (si_kappa,si_mu,3,si_rho); k_test_SE   = zeros (si_kappa,si_mu,3,si_rho); clr_test_SE   = zeros(si_kappa,si_mu,3,si_rho); eff_fs_test_asym = zeros(si_kappa,si_mu, si_rho); 
ar_test_SE0  = zeros (si_kappa,si_mu,3,si_rho); k_test_SE0  = zeros (si_kappa,si_mu,3,si_rho); clr_test_SE0  = zeros(si_kappa,si_mu,3,si_rho);  
ar_test_IME  = zeros (si_kappa,si_mu,3,si_rho); k_test_IME  = zeros (si_kappa,si_mu,3,si_rho); wald_test_asym  = zeros(si_kappa,si_mu,si_rho);  T_test_asym   = zeros(si_kappa,si_mu, si_rho);									    
ar_test_EME  = zeros (si_kappa,si_mu,3,si_rho); k_test_EME  = zeros (si_kappa,si_mu,3,si_rho); wald_test_IME = zeros(si_kappa,si_mu,3,si_rho);  T_test_asym_s = zeros(si_kappa,si_mu, si_rho);   
ar_test_EME0 = zeros (si_kappa,si_mu,3,si_rho); k_test_EME0 = zeros (si_kappa,si_mu,3,si_rho); wald_test_EME = zeros(si_kappa,si_mu,3,si_rho);    Cp_k_hom    = zeros(si_kappa,si_mu, si_rho);   
ar_test_DM   = zeros (si_kappa,si_mu,3,si_rho); k_test_DM   = zeros (si_kappa,si_mu,3,si_rho); wald_test_pairs = zeros(si_kappa,si_mu,si_rho);    Bias_theta  = zeros(si_kappa,si_mu,2, si_rho);                             


for m = 1:si_rho
    
    
    if m==1
        label_ = label_gauss_rho20;
    end
    
    if m==2
        label_  = label_gauss_rho50;
    end
    
    if m==3
        label_  = label_gauss_rho70;
    end
    
    if m==4
        label_  = label_gauss_rho95;
    end
    
    for j=1:si_mu
        
        
        for i = 1: si_kappa
            
            hhh = sprintf('%s', label_{i,j})
            load(hhh);
            
            ar_test_homo(i,j,m)  =A_ar_test.homo; k_test_homo(i,j,m)  =A_k_test.homo; clr_test_homo  (i,j,m)  = A_clr_test.homo  ; f_test_asym     (i,j,m)  = A_f_test.asym ;
            ar_test_asym(i,j,m)  =A_ar_test.asym; k_test_asym(i,j,m)  =A_k_test.asym; clr_test_asym  (i,j,m)  = A_clr_test.asym  ; f_test_IME      (i,j,:,m)= A_f_test.IME  ;
            ar_test_EE  (i,j,:,m)=A_ar_test.EE  ; k_test_EE  (i,j,:,m)=A_k_test.EE  ; clr_test_EE    (i,j,:,m)= A_clr_test.EE    ; f_test_pairs    (i,j,m)  = A_f_test.pairs;
            ar_test_EE0 (i,j,:,m)=A_ar_test.EE0 ; k_test_EE0 (i,j,:,m)=A_k_test.EE0 ; clr_test_EE0   (i,j,:,m)= A_clr_test.EE0   ; eff_f_test_asym (i,j,m)  = A_f_test.eff  ;
            ar_test_SE  (i,j,:,m)=A_ar_test.SE  ; k_test_SE  (i,j,:,m)=A_k_test.SE  ; clr_test_SE    (i,j,:,m)= A_clr_test.SE    ; eff_fs_test_asym(i,j,m)  = A_f_test.eff_s;
            ar_test_SE0 (i,j,:,m)=A_ar_test.SE0 ; k_test_SE0 (i,j,:,m)=A_k_test.SE0 ; clr_test_SE0   (i,j,:,m)= A_clr_test.SE0   ;
            ar_test_IME (i,j,:,m)=A_ar_test.IME ; k_test_IME (i,j,:,m)=A_k_test.IME ; wald_test_asym (i,j,m)  = A_wald_test.asym ; T_test_asym  (i,j,m)   = A_T_test.mix  ;
            ar_test_EME (i,j,:,m)=A_ar_test.EME ; k_test_EME (i,j,:,m)=A_k_test.EME ; wald_test_IME  (i,j,:,m)= A_wald_test.IME  ; T_test_asym_s(i,j,m)   = A_T_test.mix_s;
            ar_test_EME0(i,j,:,m)=A_ar_test.EME0; k_test_EME0(i,j,:,m)=A_k_test.EME0; wald_test_EME  (i,j,:,m)= A_wald_test.EME  ; Cp_k_hom     (i,j,m)   = cp_k_hom      ;
            ar_test_DM  (i,j,:,m)=A_ar_test.DM  ; k_test_DM  (i,j,:,m)=A_k_test.DM  ; wald_test_pairs(i,j,m)  = A_wald_test.pairs; Bias_theta   (i,j,:,m) = Mean_Bias     ;
            
            
        end
    end
end


diary off 
cd '.../_boot_simulation/nG_20/lognormal'

diary(['results' '/' 'tab_rho_kappa_mu_kz' '.txt'])

fprintf(1, '\n           Nominal Size - WIR tests          \n' );
fprintf(1, '\n normal errors mu =%2.1f, G=%3.0f,  gamma=%2.0f,  n.sim=%5.0f,  n.boot=%5.0f \n\n', 0.1, 20, 0, 10000, 199);

fprintf(1, 'kappa     | %43.2f| %43.2f| %43.2f|   \n', kappa);
fprintf(1, 'rho       |  %6.2f   %6.2f   %6.2f   %6.2f|  %6.2f   %6.2f   %6.2f   %6.2f|  %6.2f   %6.2f   %6.2f   %6.2f| \n\n', rho, rho, rho);
fprintf(1, 'wald_asym |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  wald_test_asym   (1,1,:),wald_test_asym   (2,1,:),wald_test_asym   (3,1,:));
fprintf(1, 'wald_g_IME|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  wald_test_IME  (1,1,1,:),wald_test_IME  (2,1,1,:),wald_test_IME  (3,1,1,:));
fprintf(1, 'wald_r_IME|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  wald_test_IME  (1,1,2,:),wald_test_IME  (2,1,2,:),wald_test_IME  (3,1,2,:));
fprintf(1, 'waldmm_IME|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  wald_test_IME  (1,1,3,:),wald_test_IME  (2,1,3,:),wald_test_IME  (3,1,3,:));
fprintf(1, 'wald_g_EME|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  wald_test_EME  (1,1,1,:),wald_test_EME  (2,1,1,:),wald_test_EME  (3,1,1,:));
fprintf(1, 'wald_r_EME|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  wald_test_EME  (1,1,2,:),wald_test_EME  (2,1,2,:),wald_test_EME  (3,1,2,:));
fprintf(1, 'waldmm_EME|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  wald_test_EME  (1,1,3,:),wald_test_EME  (2,1,3,:),wald_test_EME  (3,1,3,:));
fprintf(1, 'wald_pairs|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  \n\n',  wald_test_pairs  (1,1,:),wald_test_pairs  (2,1,:),wald_test_pairs  (3,1,:));
                                                                                                                       
fprintf(1, 'ar_asym   |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  ar_test_asym (1,1,:),ar_test_asym  (2,1,:), ar_test_asym  (3,1,:));
fprintf(1, 'ar_m_EE   |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  ar_test_EE  (1,1,1,:),ar_test_EE  (2,1,1,:),ar_test_EE  (3,1,1,:));
fprintf(1, 'ar_g_EE   |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  ar_test_EE  (1,1,2,:),ar_test_EE  (2,1,2,:),ar_test_EE  (3,1,2,:));
fprintf(1, 'ar_r_EE   |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  ar_test_EE  (1,1,3,:),ar_test_EE  (2,1,3,:),ar_test_EE  (3,1,3,:));
fprintf(1, 'ar_mm_EE  |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  ar_test_EE  (1,1,4,:),ar_test_EE  (2,1,4,:),ar_test_EE  (3,1,4,:));
fprintf(1, 'ar_m_EE0  |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  ar_test_EE0 (1,1,1,:),ar_test_EE0 (2,1,1,:),ar_test_EE0 (3,1,1,:));
fprintf(1, 'ar_g_EE0  |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  ar_test_EE0 (1,1,2,:),ar_test_EE0 (2,1,2,:),ar_test_EE0 (3,1,2,:));
fprintf(1, 'ar_r_EE0  |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  ar_test_EE0 (1,1,3,:),ar_test_EE0 (2,1,3,:),ar_test_EE0 (3,1,3,:));
fprintf(1, 'ar_mm_EE0 |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  ar_test_EE0 (1,1,4,:),ar_test_EE0 (2,1,4,:),ar_test_EE0 (3,1,4,:));
fprintf(1, 'ar_g_SE   |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  ar_test_SE  (1,1,1,:),ar_test_SE  (2,1,1,:),ar_test_SE  (3,1,1,:));
fprintf(1, 'ar_r_SE   |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  ar_test_SE  (1,1,2,:),ar_test_SE  (2,1,2,:),ar_test_SE  (3,1,2,:));
fprintf(1, 'ar_mm_SE  |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  ar_test_SE  (1,1,3,:),ar_test_SE  (2,1,3,:),ar_test_SE  (3,1,3,:));
fprintf(1, 'ar_g_SE0  |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  ar_test_SE0 (1,1,1,:),ar_test_SE0 (2,1,1,:),ar_test_SE0 (3,1,1,:));
fprintf(1, 'ar_r_SE0  |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  ar_test_SE0 (1,1,2,:),ar_test_SE0 (2,1,2,:),ar_test_SE0 (3,1,2,:));
fprintf(1, 'ar_mm_SE0 |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  ar_test_SE0 (1,1,3,:),ar_test_SE0 (2,1,3,:),ar_test_SE0 (3,1,3,:));
fprintf(1, 'ar_g_IME  |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  ar_test_IME (1,1,1,:),ar_test_IME (2,1,1,:),ar_test_IME (3,1,1,:));
fprintf(1, 'ar_r_IME  |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  ar_test_IME (1,1,2,:),ar_test_IME (2,1,2,:),ar_test_IME (3,1,2,:));
fprintf(1, 'ar_mm_IME |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  ar_test_IME (1,1,3,:),ar_test_IME (2,1,3,:),ar_test_IME (3,1,3,:));
fprintf(1, 'ar_g_EME  |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  ar_test_EME (1,1,1,:),ar_test_EME (2,1,1,:),ar_test_EME (3,1,1,:));
fprintf(1, 'ar_r_EME  |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  ar_test_EME (1,1,2,:),ar_test_EME (2,1,2,:),ar_test_EME (3,1,2,:));
fprintf(1, 'ar_mm_EME |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  ar_test_EME (1,1,3,:),ar_test_EME (2,1,3,:),ar_test_EME (3,1,3,:));
fprintf(1, 'ar_g_EME0 |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  ar_test_EME0(1,1,1,:),ar_test_EME0(2,1,1,:),ar_test_EME0(3,1,1,:));
fprintf(1, 'ar_r_EME0 |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  ar_test_EME0(1,1,2,:),ar_test_EME0(2,1,2,:),ar_test_EME0(3,1,2,:));
fprintf(1, 'ar_mm_EME0|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  ar_test_EME0(1,1,3,:),ar_test_EME0(2,1,3,:),ar_test_EME0(3,1,3,:));
fprintf(1, 'ar_g_DM   |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  ar_test_DM  (1,1,1,:),ar_test_DM  (2,1,1,:),ar_test_DM  (3,1,1,:));
fprintf(1, 'ar_r_DM   |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  ar_test_DM  (1,1,2,:),ar_test_DM  (2,1,2,:),ar_test_DM  (3,1,2,:));
fprintf(1, 'ar_mm_DM  |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  \n\n',  ar_test_DM  (1,1,3,:),ar_test_DM  (2,1,3,:),ar_test_DM  (3,1,3,:));
                                                                                                                       
                                                                                                                       
fprintf(1, 'k_asym    |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  k_test_asym  (1,1,:), k_test_asym  (2,1,:), k_test_asym  (3,1,:));
fprintf(1, 'k_m_EE    |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  k_test_EE  (1,1,1,:), k_test_EE  (2,1,1,:), k_test_EE  (3,1,1,:));
fprintf(1, 'k_g_EE    |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  k_test_EE  (1,1,2,:), k_test_EE  (2,1,2,:), k_test_EE  (3,1,2,:));
fprintf(1, 'k_r_EE    |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  k_test_EE  (1,1,3,:), k_test_EE  (2,1,3,:), k_test_EE  (3,1,3,:));
fprintf(1, 'k_mm_EE   |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  k_test_EE  (1,1,4,:), k_test_EE  (2,1,4,:), k_test_EE  (3,1,4,:));
fprintf(1, 'k_m_EE0   |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  k_test_EE0 (1,1,1,:), k_test_EE0 (2,1,1,:), k_test_EE0 (3,1,1,:));
fprintf(1, 'k_g_EE0   |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  k_test_EE0 (1,1,2,:), k_test_EE0 (2,1,2,:), k_test_EE0 (3,1,2,:));
fprintf(1, 'k_r_EE0   |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  k_test_EE0 (1,1,3,:), k_test_EE0 (2,1,3,:), k_test_EE0 (3,1,3,:));
fprintf(1, 'k_mm_EE0  |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  k_test_EE0 (1,1,4,:), k_test_EE0 (2,1,4,:), k_test_EE0 (3,1,4,:));
fprintf(1, 'k_g_SE    |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  k_test_SE  (1,1,1,:), k_test_SE  (2,1,1,:), k_test_SE  (3,1,1,:));
fprintf(1, 'k_r_SE    |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  k_test_SE  (1,1,2,:), k_test_SE  (2,1,2,:), k_test_SE  (3,1,2,:));
fprintf(1, 'k_mm_SE   |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  k_test_SE  (1,1,3,:), k_test_SE  (2,1,3,:), k_test_SE  (3,1,3,:));
fprintf(1, 'k_g_SE0   |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  k_test_SE0 (1,1,1,:), k_test_SE0 (2,1,1,:), k_test_SE0 (3,1,1,:));
fprintf(1, 'k_r_SE0   |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  k_test_SE0 (1,1,2,:), k_test_SE0 (2,1,2,:), k_test_SE0 (3,1,2,:));
fprintf(1, 'k_mm_SE0  |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  k_test_SE0 (1,1,3,:), k_test_SE0 (2,1,3,:), k_test_SE0 (3,1,3,:));
fprintf(1, 'k_g_IME   |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  k_test_IME (1,1,1,:), k_test_IME (2,1,1,:), k_test_IME (3,1,1,:));
fprintf(1, 'k_r_IME   |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  k_test_IME (1,1,2,:), k_test_IME (2,1,2,:), k_test_IME (3,1,2,:));
fprintf(1, 'k_mm_IME  |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  k_test_IME (1,1,3,:), k_test_IME (2,1,3,:), k_test_IME (3,1,3,:));
fprintf(1, 'k_g_EME   |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  k_test_EME (1,1,1,:), k_test_EME (2,1,1,:), k_test_EME (3,1,1,:));
fprintf(1, 'k_r_EME   |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  k_test_EME (1,1,2,:), k_test_EME (2,1,2,:), k_test_EME (3,1,2,:));
fprintf(1, 'k_mm_EME  |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  k_test_EME (1,1,3,:), k_test_EME (2,1,3,:), k_test_EME (3,1,3,:));
fprintf(1, 'k_g_EME0  |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  k_test_EME0(1,1,1,:), k_test_EME0(2,1,1,:), k_test_EME0(3,1,1,:));
fprintf(1, 'k_r_EME0  |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  k_test_EME0(1,1,2,:), k_test_EME0(2,1,2,:), k_test_EME0(3,1,2,:));
fprintf(1, 'k_mm_EME0 |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  k_test_EME0(1,1,3,:), k_test_EME0(2,1,3,:), k_test_EME0(3,1,3,:));
fprintf(1, 'k_g_DM    |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  k_test_DM  (1,1,1,:), k_test_DM  (2,1,1,:), k_test_DM  (3,1,1,:));
fprintf(1, 'k_r_DM    |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  k_test_DM  (1,1,2,:), k_test_DM  (2,1,2,:), k_test_DM  (3,1,2,:));
fprintf(1, 'k_mm_DM   |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  \n\n',  k_test_DM  (1,1,3,:), k_test_DM  (2,1,3,:), k_test_DM  (3,1,3,:));
                                                                                                                       
                                                                                                                       
fprintf(1, 'clr_asym  |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n', clr_test_asym  (1,1,:), clr_test_asym  (2,1,:), clr_test_asym  (3,1,:));
fprintf(1, 'clr_m_EE  |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n', clr_test_EE  (1,1,1,:), clr_test_EE  (2,1,1,:), clr_test_EE  (3,1,1,:));
fprintf(1, 'clr_g_EE  |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n', clr_test_EE  (1,1,2,:), clr_test_EE  (2,1,2,:), clr_test_EE  (3,1,2,:));
fprintf(1, 'clr_r_EE  |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n', clr_test_EE  (1,1,3,:), clr_test_EE  (2,1,3,:), clr_test_EE  (3,1,3,:));
fprintf(1, 'clr_mm_EE |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n', clr_test_EE  (1,1,4,:), clr_test_EE  (2,1,4,:), clr_test_EE  (3,1,4,:));
fprintf(1, 'clr_m_EE0 |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n', clr_test_EE0 (1,1,1,:), clr_test_EE0 (2,1,1,:), clr_test_EE0 (3,1,1,:));
fprintf(1, 'clr_g_EE0 |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n', clr_test_EE0 (1,1,2,:), clr_test_EE0 (2,1,2,:), clr_test_EE0 (3,1,2,:));
fprintf(1, 'clr_r_EE0 |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n', clr_test_EE0 (1,1,3,:), clr_test_EE0 (2,1,3,:), clr_test_EE0 (3,1,3,:));
fprintf(1, 'clr_mm_EE0|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n', clr_test_EE0 (1,1,4,:), clr_test_EE0 (2,1,4,:), clr_test_EE0 (3,1,4,:));
fprintf(1, 'clr_g_SE  |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n', clr_test_SE  (1,1,1,:), clr_test_SE  (2,1,1,:), clr_test_SE  (3,1,1,:));
fprintf(1, 'clr_r_SE  |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n', clr_test_SE  (1,1,2,:), clr_test_SE  (2,1,2,:), clr_test_SE  (3,1,2,:));
fprintf(1, 'clr_mm_SE |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n', clr_test_SE  (1,1,3,:), clr_test_SE  (2,1,3,:), clr_test_SE  (3,1,3,:));
fprintf(1, 'clr_g_SE0 |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n', clr_test_SE0 (1,1,1,:), clr_test_SE0 (2,1,1,:), clr_test_SE0 (3,1,1,:));
fprintf(1, 'clr_r_SE0 |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n', clr_test_SE0 (1,1,2,:), clr_test_SE0 (2,1,2,:), clr_test_SE0 (3,1,2,:));
fprintf(1, 'clr_mm_SE0|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  \n\n', clr_test_SE0 (1,1,3,:), clr_test_SE0 (2,1,3,:), clr_test_SE0 (3,1,3,:));
                                                                                                                       
                                                                                                                       
fprintf(1, 'f_asym    |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  f_test_asym  (1,1,:) ,f_test_asym (2,1,:)  , f_test_asym(3,1,:)  );
fprintf(1, 'feff_asym |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  eff_f_test_asym (1,1,:),eff_f_test_asym (2,1,:),eff_f_test_asym (3,1,:));
fprintf(1, 'feff_asyms|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  \n\n',  eff_fs_test_asym(1,1,:),eff_fs_test_asym(2,1,:),eff_fs_test_asym(3,1,:));
                                                                                                                       
fprintf(1, 'Teff_asym |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  T_test_asym  (1,1,:),T_test_asym  (2,1,:),T_test_asym  (3,1,:));
fprintf(1, 'Teff_asyms|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  \n\n',  T_test_asym_s(1,1,:),T_test_asym_s(2,1,:),T_test_asym_s(3,1,:));
                                                                                                                       
fprintf(1, 'cp_k_hom  |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  Cp_k_hom    (1,1,:), Cp_k_hom    (2,1,:), Cp_k_hom    (3,1,:)); 
fprintf(1, 'Mean_bias |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  \n\n',  Bias_theta(1,1,1,:), Bias_theta(2,1,1,:), Bias_theta(3,1,1,:)); 


fprintf(1, '\n #######################################################################\n\n' );

fprintf(1, '\n           Nominal Size - WIR tests          \n' );
fprintf(1, '\n normal errors mu =%2.1f, G=%3.0f,  gamma=%2.0f,  n.sim=%5.0f,  n.boot=%5.0f \n\n', 18, 20, 0, 10000, 199);

fprintf(1, 'kappa     | %43.2f| %43.2f| %43.2f|   \n', kappa);
fprintf(1, 'rho       |  %6.2f   %6.2f   %6.2f   %6.2f|  %6.2f   %6.2f   %6.2f   %6.2f|  %6.2f   %6.2f   %6.2f   %6.2f| \n\n', rho, rho, rho);
fprintf(1, 'wald_asym |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  wald_test_asym   (1,2,:),wald_test_asym   (2,2,:),wald_test_asym   (3,2,:));
fprintf(1, 'wald_g_IME|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  wald_test_IME  (1,2,1,:),wald_test_IME  (2,2,1,:),wald_test_IME  (3,2,1,:));
fprintf(1, 'wald_r_IME|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  wald_test_IME  (1,2,2,:),wald_test_IME  (2,2,2,:),wald_test_IME  (3,2,2,:));
fprintf(1, 'waldmm_IME|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  wald_test_IME  (1,2,3,:),wald_test_IME  (2,2,3,:),wald_test_IME  (3,2,3,:));
fprintf(1, 'wald_g_EME|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  wald_test_EME  (1,2,1,:),wald_test_EME  (2,2,1,:),wald_test_EME  (3,2,1,:));
fprintf(1, 'wald_r_EME|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  wald_test_EME  (1,2,2,:),wald_test_EME  (2,2,2,:),wald_test_EME  (3,2,2,:));
fprintf(1, 'waldmm_EME|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  wald_test_EME  (1,2,3,:),wald_test_EME  (2,2,3,:),wald_test_EME  (3,2,3,:));
fprintf(1, 'wald_pairs|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  \n\n',  wald_test_pairs  (1,2,:),wald_test_pairs  (2,2,:),wald_test_pairs  (3,2,:));
                                                                                                                       
fprintf(1, 'ar_asym   |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  ar_test_asym (1,2,:),ar_test_asym  (2,2,:), ar_test_asym  (3,2,:));
fprintf(1, 'ar_m_EE   |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  ar_test_EE  (1,2,1,:),ar_test_EE  (2,2,1,:),ar_test_EE  (3,2,1,:));
fprintf(1, 'ar_g_EE   |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  ar_test_EE  (1,2,2,:),ar_test_EE  (2,2,2,:),ar_test_EE  (3,2,2,:));
fprintf(1, 'ar_r_EE   |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  ar_test_EE  (1,2,3,:),ar_test_EE  (2,2,3,:),ar_test_EE  (3,2,3,:));
fprintf(1, 'ar_mm_EE  |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  ar_test_EE  (1,2,4,:),ar_test_EE  (2,2,4,:),ar_test_EE  (3,2,4,:));
fprintf(1, 'ar_m_EE0  |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  ar_test_EE0 (1,2,1,:),ar_test_EE0 (2,2,1,:),ar_test_EE0 (3,2,1,:));
fprintf(1, 'ar_g_EE0  |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  ar_test_EE0 (1,2,2,:),ar_test_EE0 (2,2,2,:),ar_test_EE0 (3,2,2,:));
fprintf(1, 'ar_r_EE0  |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  ar_test_EE0 (1,2,3,:),ar_test_EE0 (2,2,3,:),ar_test_EE0 (3,2,3,:));
fprintf(1, 'ar_mm_EE0 |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  ar_test_EE0 (1,2,4,:),ar_test_EE0 (2,2,4,:),ar_test_EE0 (3,2,4,:));
fprintf(1, 'ar_g_SE   |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  ar_test_SE  (1,2,1,:),ar_test_SE  (2,2,1,:),ar_test_SE  (3,2,1,:));
fprintf(1, 'ar_r_SE   |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  ar_test_SE  (1,2,2,:),ar_test_SE  (2,2,2,:),ar_test_SE  (3,2,2,:));
fprintf(1, 'ar_mm_SE  |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  ar_test_SE  (1,2,3,:),ar_test_SE  (2,2,3,:),ar_test_SE  (3,2,3,:));
fprintf(1, 'ar_g_SE0  |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  ar_test_SE0 (1,2,1,:),ar_test_SE0 (2,2,1,:),ar_test_SE0 (3,2,1,:));
fprintf(1, 'ar_r_SE0  |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  ar_test_SE0 (1,2,2,:),ar_test_SE0 (2,2,2,:),ar_test_SE0 (3,2,2,:));
fprintf(1, 'ar_mm_SE0 |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  ar_test_SE0 (1,2,3,:),ar_test_SE0 (2,2,3,:),ar_test_SE0 (3,2,3,:));
fprintf(1, 'ar_g_IME  |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  ar_test_IME (1,2,1,:),ar_test_IME (2,2,1,:),ar_test_IME (3,2,1,:));
fprintf(1, 'ar_r_IME  |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  ar_test_IME (1,2,2,:),ar_test_IME (2,2,2,:),ar_test_IME (3,2,2,:));
fprintf(1, 'ar_mm_IME |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  ar_test_IME (1,2,3,:),ar_test_IME (2,2,3,:),ar_test_IME (3,2,3,:));
fprintf(1, 'ar_g_EME  |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  ar_test_EME (1,2,1,:),ar_test_EME (2,2,1,:),ar_test_EME (3,2,1,:));
fprintf(1, 'ar_r_EME  |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  ar_test_EME (1,2,2,:),ar_test_EME (2,2,2,:),ar_test_EME (3,2,2,:));
fprintf(1, 'ar_mm_EME |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  ar_test_EME (1,2,3,:),ar_test_EME (2,2,3,:),ar_test_EME (3,2,3,:));
fprintf(1, 'ar_g_EME0 |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  ar_test_EME0(1,2,1,:),ar_test_EME0(2,2,1,:),ar_test_EME0(3,2,1,:));
fprintf(1, 'ar_r_EME0 |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  ar_test_EME0(1,2,2,:),ar_test_EME0(2,2,2,:),ar_test_EME0(3,2,2,:));
fprintf(1, 'ar_mm_EME0|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  ar_test_EME0(1,2,3,:),ar_test_EME0(2,2,3,:),ar_test_EME0(3,2,3,:));
fprintf(1, 'ar_g_DM   |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  ar_test_DM  (1,2,1,:),ar_test_DM  (2,2,1,:),ar_test_DM  (3,2,1,:));
fprintf(1, 'ar_r_DM   |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  ar_test_DM  (1,2,2,:),ar_test_DM  (2,2,2,:),ar_test_DM  (3,2,2,:));
fprintf(1, 'ar_mm_DM  |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  \n\n',  ar_test_DM  (1,2,3,:),ar_test_DM  (2,2,3,:),ar_test_DM  (3,2,3,:));
                                                                                                                       
                                                                                                                       
fprintf(1, 'k_asym    |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  k_test_asym  (1,2,:), k_test_asym  (2,2,:), k_test_asym  (3,2,:));
fprintf(1, 'k_m_EE    |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  k_test_EE  (1,2,1,:), k_test_EE  (2,2,1,:), k_test_EE  (3,2,1,:));
fprintf(1, 'k_g_EE    |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  k_test_EE  (1,2,2,:), k_test_EE  (2,2,2,:), k_test_EE  (3,2,2,:));
fprintf(1, 'k_r_EE    |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  k_test_EE  (1,2,3,:), k_test_EE  (2,2,3,:), k_test_EE  (3,2,3,:));
fprintf(1, 'k_mm_EE   |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  k_test_EE  (1,2,4,:), k_test_EE  (2,2,4,:), k_test_EE  (3,2,4,:));
fprintf(1, 'k_m_EE0   |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  k_test_EE0 (1,2,1,:), k_test_EE0 (2,2,1,:), k_test_EE0 (3,2,1,:));
fprintf(1, 'k_g_EE0   |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  k_test_EE0 (1,2,2,:), k_test_EE0 (2,2,2,:), k_test_EE0 (3,2,2,:));
fprintf(1, 'k_r_EE0   |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  k_test_EE0 (1,2,3,:), k_test_EE0 (2,2,3,:), k_test_EE0 (3,2,3,:));
fprintf(1, 'k_mm_EE0  |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  k_test_EE0 (1,2,4,:), k_test_EE0 (2,2,4,:), k_test_EE0 (3,2,4,:));
fprintf(1, 'k_g_SE    |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  k_test_SE  (1,2,1,:), k_test_SE  (2,2,1,:), k_test_SE  (3,2,1,:));
fprintf(1, 'k_r_SE    |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  k_test_SE  (1,2,2,:), k_test_SE  (2,2,2,:), k_test_SE  (3,2,2,:));
fprintf(1, 'k_mm_SE   |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  k_test_SE  (1,2,3,:), k_test_SE  (2,2,3,:), k_test_SE  (3,2,3,:));
fprintf(1, 'k_g_SE0   |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  k_test_SE0 (1,2,1,:), k_test_SE0 (2,2,1,:), k_test_SE0 (3,2,1,:));
fprintf(1, 'k_r_SE0   |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  k_test_SE0 (1,2,2,:), k_test_SE0 (2,2,2,:), k_test_SE0 (3,2,2,:));
fprintf(1, 'k_mm_SE0  |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  k_test_SE0 (1,2,3,:), k_test_SE0 (2,2,3,:), k_test_SE0 (3,2,3,:));
fprintf(1, 'k_g_IME   |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  k_test_IME (1,2,1,:), k_test_IME (2,2,1,:), k_test_IME (3,2,1,:));
fprintf(1, 'k_r_IME   |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  k_test_IME (1,2,2,:), k_test_IME (2,2,2,:), k_test_IME (3,2,2,:));
fprintf(1, 'k_mm_IME  |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  k_test_IME (1,2,3,:), k_test_IME (2,2,3,:), k_test_IME (3,2,3,:));
fprintf(1, 'k_g_EME   |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  k_test_EME (1,2,1,:), k_test_EME (2,2,1,:), k_test_EME (3,2,1,:));
fprintf(1, 'k_r_EME   |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  k_test_EME (1,2,2,:), k_test_EME (2,2,2,:), k_test_EME (3,2,2,:));
fprintf(1, 'k_mm_EME  |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  k_test_EME (1,2,3,:), k_test_EME (2,2,3,:), k_test_EME (3,2,3,:));
fprintf(1, 'k_g_EME0  |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  k_test_EME0(1,2,1,:), k_test_EME0(2,2,1,:), k_test_EME0(3,2,1,:));
fprintf(1, 'k_r_EME0  |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  k_test_EME0(1,2,2,:), k_test_EME0(2,2,2,:), k_test_EME0(3,2,2,:));
fprintf(1, 'k_mm_EME0 |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  k_test_EME0(1,2,3,:), k_test_EME0(2,2,3,:), k_test_EME0(3,2,3,:));
fprintf(1, 'k_g_DM    |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  k_test_DM  (1,2,1,:), k_test_DM  (2,2,1,:), k_test_DM  (3,2,1,:));
fprintf(1, 'k_r_DM    |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  k_test_DM  (1,2,2,:), k_test_DM  (2,2,2,:), k_test_DM  (3,2,2,:));
fprintf(1, 'k_mm_DM   |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  \n\n',  k_test_DM  (1,2,3,:), k_test_DM  (2,2,3,:), k_test_DM  (3,2,3,:));
                                                                                                                       
                                                                                                                       
fprintf(1, 'clr_asym  |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n', clr_test_asym  (1,2,:), clr_test_asym  (2,2,:), clr_test_asym  (3,2,:));
fprintf(1, 'clr_m_EE  |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n', clr_test_EE  (1,2,1,:), clr_test_EE  (2,2,1,:), clr_test_EE  (3,2,1,:));
fprintf(1, 'clr_g_EE  |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n', clr_test_EE  (1,2,2,:), clr_test_EE  (2,2,2,:), clr_test_EE  (3,2,2,:));
fprintf(1, 'clr_r_EE  |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n', clr_test_EE  (1,2,3,:), clr_test_EE  (2,2,3,:), clr_test_EE  (3,2,3,:));
fprintf(1, 'clr_mm_EE |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n', clr_test_EE  (1,2,4,:), clr_test_EE  (2,2,4,:), clr_test_EE  (3,2,4,:));
fprintf(1, 'clr_m_EE0 |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n', clr_test_EE0 (1,2,1,:), clr_test_EE0 (2,2,1,:), clr_test_EE0 (3,2,1,:));
fprintf(1, 'clr_g_EE0 |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n', clr_test_EE0 (1,2,2,:), clr_test_EE0 (2,2,2,:), clr_test_EE0 (3,2,2,:));
fprintf(1, 'clr_r_EE0 |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n', clr_test_EE0 (1,2,3,:), clr_test_EE0 (2,2,3,:), clr_test_EE0 (3,2,3,:));
fprintf(1, 'clr_mm_EE0|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n', clr_test_EE0 (1,2,4,:), clr_test_EE0 (2,2,4,:), clr_test_EE0 (3,2,4,:));
fprintf(1, 'clr_g_SE  |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n', clr_test_SE  (1,2,1,:), clr_test_SE  (2,2,1,:), clr_test_SE  (3,2,1,:));
fprintf(1, 'clr_r_SE  |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n', clr_test_SE  (1,2,2,:), clr_test_SE  (2,2,2,:), clr_test_SE  (3,2,2,:));
fprintf(1, 'clr_mm_SE |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n', clr_test_SE  (1,2,3,:), clr_test_SE  (2,2,3,:), clr_test_SE  (3,2,3,:));
fprintf(1, 'clr_g_SE0 |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n', clr_test_SE0 (1,2,1,:), clr_test_SE0 (2,2,1,:), clr_test_SE0 (3,2,1,:));
fprintf(1, 'clr_r_SE0 |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n', clr_test_SE0 (1,2,2,:), clr_test_SE0 (2,2,2,:), clr_test_SE0 (3,2,2,:));
fprintf(1, 'clr_mm_SE0|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  \n\n', clr_test_SE0 (1,2,3,:), clr_test_SE0 (2,2,3,:), clr_test_SE0 (3,2,3,:));
                                                                                                                       
fprintf(1, 'f_asym    |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  f_test_asym  (1,2,:) ,f_test_asym (2,2,:)  , f_test_asym(3,2,:)  );
fprintf(1, 'feff_asym |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  eff_f_test_asym (1,2,:),eff_f_test_asym (2,2,:),eff_f_test_asym (3,2,:));
fprintf(1, 'feff_asyms|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  \n\n',  eff_fs_test_asym(1,2,:),eff_fs_test_asym(2,2,:),eff_fs_test_asym(3,2,:));
                                                                                                                       
fprintf(1, 'Teff_asym |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  T_test_asym  (1,2,:),T_test_asym  (2,2,:),T_test_asym  (3,2,:));
fprintf(1, 'Teff_asyms|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  \n\n',  T_test_asym_s(1,2,:),T_test_asym_s(2,2,:),T_test_asym_s(3,2,:));
                                                                                                                       
fprintf(1, 'cp_k_hom  |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|    \n',  Cp_k_hom    (1,2,:), Cp_k_hom    (2,2,:), Cp_k_hom    (3,2,:)); 
fprintf(1, 'Mean_bias |  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  %6.2f|  \n\n',  Bias_theta(1,2,1,:), Bias_theta(2,2,1,:), Bias_theta(3,2,1,:)); 



cd '.../_boot_simulation/'


diary off                              
