% Function to run the bootstrap simulations for the Cluster-IV Paper
tic

clear;
clc
addpath('.../functions','-end')

%% Simulation Parameters
cp_kz = [0.1 18];             % concentration parameter divided by k_z
rho   = [0.20 0.50 0.70 0.95];% correlation cluster errors  
het   = [0 1 2];      % heteroskedastic parameter, het==0 homoskedastic model; 
c     = 2;            % parameter that affect the skedastic function
phi   = 0.50;         % weight cluster variance (varphi==weight idiosyncratic variance ) 
n_boot= 199;          % # of bootstrap samples
n_sim = 10000;        % # of simulations
k_z   = [2 5 10 15];  % # of excluded instruments  
k_x   = 1;            % # of included instruments
k_Y   = 2;            % # of endogenous variables
alpha = 0.05;         % significance level
lambda= 0.01;         % proportion of the instruments that vary across cluster;

l.cp_kz = length(cp_kz);
l.kz    = length(k_z);
l.rho   = length(rho);
l.phi   = length(phi);
l.het   = length(het);

n_G     = 20;               %# of clusters
n_obs   = 20*n_G;           % total number of observations
v_G     = zeros(n_G,3);
gamma   = [0 1 2];
for g=1:n_G
    v_G(g,:)=exp(gamma*g/n_G);
end

v_G        = round( n_obs*( v_G./(ones(n_G,1)*sum(v_G))));
v_G(n_G,:) = n_obs - sum(v_G(1:n_G-1,:));

l.g     = length(gamma);
l.rn    = 3;               %# of random error distributions

f_in = {k_z  v_G  het cp_kz rho phi};
brange_max = 50;         %upper(lower) limited for finding beta in the effective F test  

[w_gamma, w_radem, w_ind] = rand_boot(n_G, n_boot, n_sim);

parpool('myCluster',27) %parallel computing function

for n_kz = 1:l.kz    
    
    k_z       = f_in{1}(n_kz);
    label     = 'nG_%d/lognormal/kz_%d';
    dir_label = sprintf(label, n_G, k_z);
    mkdir(dir_label)
    
    for n_g = 1:l.g
        
        v_G    = f_in{2}(:,n_g);
        
        for n_het = 1:l.het

            het = f_in{3}(n_het);
            %create a very simple simulation where instruments comes from a lognormal distribution
            [Z, X,M_x, I_n, l_ini,l_end,W_G,W_I,nu] = instruments_dgp_lognormal(n_obs, k_z, k_x, n_G, v_G, lambda,het, c); 

            for n_cp_kz  = 1:l.cp_kz                
                cp_kz = f_in{4}(n_cp_kz);
                
                for n_rho = 1:l.rho
                    rho     = f_in{5}(n_rho);
                    varrho  = f_in{5}(n_rho);
                    
                    for n_phi = 1: l.phi

                        phi = f_in{6}(n_phi);
                        
                        for n_nr = 1:l.rn
                            
                            if n_nr ==1
                                [resid_N, resid_G] = rand_chisq_size(n_G, n_sim, n_obs, k_Y);
                                f_label      = 'nG_%d/lognormal/kz_%d/boot_lamb%d_phi%d_mu%d_rho%d_het%d_fix%d_chisq';
                            end
                           
                            
                            if n_nr ==2
                                [resid_N, resid_G] = rand_gauss_size(n_G, n_sim, n_obs, k_Y);
                                f_label      = 'nG_%d/lognormal/kz_%d/boot_lamb%d_phi%d_mu%d_rho%d_het%d_fix%d_gauss';
                            end
                            
                            if n_nr ==3
                                [resid_N, resid_G] = rand_tdist_size(n_G, n_sim, n_obs, k_Y);
                                f_label      = 'nG_%d/lognormal/kz_%d/boot_lamb%d_phi%d_mu%d_rho%d_het%d_fix%d_tdist';
                            end
                            
                             
                            file_label = sprintf(f_label, n_G, k_z, 100*lambda,100*phi, 10*cp_kz, 100*rho, het, n_g);
                            
                            FUN_boot_simulation_test(cp_kz,rho, varrho, v_G, n_G, alpha, phi, n_boot, n_sim, k_z, k_x, file_label,...
                                                        w_gamma, w_radem, w_ind, resid_N, resid_G, Z, X,M_x, I_n, l_ini,l_end,W_G,W_I,nu,brange_max); 
                                                    
                        end
                    end
                    
                end
            end
        end
    end
    
end

delete(gcp('nocreate')) %parallel computing function


rmpath('.../functions')


toc