% Function to run the bootstrap simulations for the Cluster-IV Paper
tic

clear;
clc
addpath('U:/cluster_iv/functions','-end')

%% Simulation Parameters
cp_kz = 18;     % concentration parameter divided by k_z [0.1 18]
rho   = 0.20;  % correlation cluster errors  [0.20 0.95]
het   = 0;      % heteroskedastic parameter, het==0 homoskedastic model; [0 1 2] 
c     = 2;            % parameter that affect the skedastic function
phi   = 0.50;       % weight cluster variance (varphi==weight idiosyncratic variance ) 
n_boot= 999;          % # of bootstrap samples
n_sim = 10000;        % # of simulations
k_z   = 5;          % # of excluded instruments  
k_x   = 1;            % # of included instruments
k_Y   = 2;            % # of endogenous variables
alpha = 0.05;         % significance level
lambda= 0.01;         % proportion of the instruments that vary across cluster;

l.cp_kz = length(cp_kz);
l.kz    = length(k_z);
l.rho   = length(rho);
l.phi   = length(phi);
l.het   = length(het);

n_G     = 20;               %# of clusters
n_obs   = 20*n_G;           % total number of observations
v_G     = zeros(n_G,1);
gamma   = 1;
n_g     = 1;
for g=1:n_G
    v_G(g,:)=exp(gamma*g/n_G);
end

v_G        = round( n_obs*( v_G./(ones(n_G,1)*sum(v_G))));
v_G(n_G,:) = n_obs - sum(v_G(1:n_G-1,:));

% l.g     = length(gamma);
% l.rn    = 3;               %# of random error distributions

f_in = {k_z  v_G  het cp_kz rho phi};
brange_max = 50;         %upper(lower) limited for finding beta in the effective F test  

[w_gamma, w_radem, w_ind, w_mam] = rand_boot(n_G, n_boot, n_sim);

parpool('myCluster',27) %parallel computing function

th0   = 0;

Theta_1 =  -2.750:0.125:2.750; %Theta_1 =  [-30 -20 -10 -5  -2.625 -1  1   2.625  5 10 20 30]; 

l.theta1=length(Theta_1);

% for n_g = 1:l.g
%     
%     v_G    = f_in{2}(:,n_g);

for n_th1 = 1:l.theta1
    th1   = Theta_1(n_th1);
    if th1<0
        label     = 'results/lognormal/kz_5/nG_%d_theta_m%04.0f';
    else
        label     = 'results/lognormal/kz_5/nG_%d_theta_p%04.0f';
    end
    dir_label = sprintf(label, n_G, abs(1000*th1));
    mkdir(dir_label)
    
    %create a very simple simulation where instruments comes from a lognormal distribution
    [Z, X,M_x, I_n, l_ini,l_end,W_G,W_I,nu] = instruments_dgp_lognormal(n_obs, k_z, k_x, n_G, v_G, lambda,het, c);
    
    varrho =rho;
    
    [resid_N, resid_G] = rand_gauss_size(n_G, n_sim, n_obs, k_Y);
    if th1<0
        f_label      = 'results/lognormal/kz_5/nG_%d_theta_m%04.0f/boot_lamb%d_phi%d_mu%d_rho%d_het%d_fix%d_gauss';
    else
        f_label      = 'results/lognormal/kz_5/nG_%d_theta_p%04.0f/boot_lamb%d_phi%d_mu%d_rho%d_het%d_fix%d_gauss';
    end
    
    file_label = sprintf(f_label, n_G, abs(1000*th1), 100*lambda,100*phi, 10*cp_kz, 100*rho, het, n_g);
    
    FUN_boot_power(cp_kz,rho, varrho, v_G, n_G, alpha, phi, n_boot, n_sim, k_z, k_x, file_label,...
        w_gamma, w_radem, w_ind, w_mam, resid_N, resid_G, Z, X,M_x, I_n, l_ini,l_end,W_G,W_I,nu,brange_max, th1, th0);
    
end

% end



delete(gcp('nocreate')) %parallel computing function


rmpath('U:/cluster_iv/functions')





toc