function [] = FUN_boot_simulation_test(cp_kz,rho, varrho,v_G, n_G, alpha, phi, n_boot, n_sim, k_z, k_x, slabel,w_gamma, w_radem, w_ind, resid_N, resid_G,Z, X,M_x, I_n, l_ini,l_end,W_G,W_I,nu,brange_max)
                
% cp_kz : concentration parameter divided by kz
% rho   : cluster correlation
% varrho: idiossyncratic correlation
% hom   : homogeneity degree (1, 2, and 3)
% v_G   : number of observations per cluster
% n_G   : number of clusters
% alpha : significance level
% lambda: part of instruments with are common to all observations 
% phi   : weigth between cluster and idiosyncratic residuals
% n_boot: number of bootstrap simulations
% n_sim : number of monte carlo simulations
% k_z   : number of excluded instruments
% k_x   : number of included instruments 
% rnumber: random number matrix
% slabel: label with the folder where to save the results

% tic

th0   = 0;          % theta0

%% Parameters and Instruments
%--- dimensions
k_y1= 1;             
k_y2= 1;         % # of endogenous explanatory variables 
k_Y = k_y1+k_y2; % # of endogenous variables
k_w = k_z+k_x;   % # of instruments

n_obs = sum(v_G);                           % # of observations
n_hom = n_obs-k_w;                          % degrees of freedom, homoskedatic case
n_par = sum([k_Y-k_y2;k_y2; k_w]);          % # of parameters
col   = cumsum([k_Y-k_y2; k_y2; k_z; k_x]); % column index for pairs bootstrap

%--- parameters for the effecttive F test
tau        = 0.10;

%--- Generating  Instruments 

Z1         = Z(:,1);       % The only first instrument is relevant instrument
sqrt_phi   = sqrt(phi);
varphi     = 1-phi;     
sqrt_varphi= sqrt(varphi);

%---Setting c_z
I_kz     =  eye(k_z);
bread    =  Z'*M_x*Z;
meat     =  Z'*M_x*(phi*W_G + varphi*W_I)*M_x*Z;
W2       =  bread\(meat/bread);
inv_VarV =  (W2)\I_kz;
c0       =  sqrt(k_z*cp_kz/inv_VarV(1,1));

S22        = meat/n_obs;
trace_S22  = trace(S22);
c01        = sqrt(cp_kz*trace_S22/n_obs);

g0        = ones(k_x,1);     % gamma0
Pi_x      = 0.5*ones(k_x,1); % true Pi_x

%--- Selection Indices
l_z = 1:k_z;
l_w = 1:k_w;
l_x = k_z+1:k_w;
l_y2= 1:k_y2;

iota_n = X(:,1);
iota_kw= ones(1,k_w);

I_kw = eye(k_w); 
I_p  = eye(k_Y-1); 

Weight = zeros(n_obs);
delta_z= zeros(k_z,1);
Pi_z   = zeros(k_z,1);  

W   = [Z X];
XX  = X'*X;
XXX = XX\X';
WW  = W'*W;
iWW = WW\I_kw;       
IWW = kron(I_p,WW);
WWW = WW\W';
P_x = X*XXX;
P_w = W*WWW;
M_x = I_n - P_x;
M_w = I_n - P_w;
Z_x = M_x*Z;

mu_hom   = (c0^2)*bread(1,1);
cp_k_hom = mu_hom/k_z;

%--- Asymptotic Statistical Tests
AR_homo  = NaN(n_sim,1);   AR_asym = NaN(n_sim,1);
K_homo   = NaN(n_sim,1);    K_asym = NaN(n_sim,1);
J_homo   = NaN(n_sim,1);    J_asym = NaN(n_sim,1);
CLR_homo = NaN(n_sim,1);  CLR_asym = NaN(n_sim,1); 
Rank_homo= NaN(n_sim,1); Rank_asym = NaN(n_sim,1);

Theta_hat  = NaN(n_sim,k_y2+k_x);  %TSLS estimates    
W_asym     = NaN(n_sim,1);
F_asym     = NaN(n_sim,1);
F_eff      = NaN(n_sim,1); 
K_eff      = NaN(n_sim,1);
X_eff      = NaN(n_sim,1);
K_eff_simp = NaN(n_sim,1);
X_eff_simp = NaN(n_sim,1);

S_AR_EE   = NaN(n_sim,4); S_K_EE   = NaN(n_sim,4);  S_J_EE   = NaN(n_sim,4);
S_AR_EE0  = NaN(n_sim,4); S_K_EE0  = NaN(n_sim,4);  S_J_EE0  = NaN(n_sim,4);
S_AR_SE   = NaN(n_sim,3); S_K_SE   = NaN(n_sim,3);  S_J_SE   = NaN(n_sim,3);
S_AR_SE0  = NaN(n_sim,3); S_K_SE0  = NaN(n_sim,3);  S_J_SE0  = NaN(n_sim,3);
S_AR_IME  = NaN(n_sim,3); S_K_IME  = NaN(n_sim,3);  S_J_IME  = NaN(n_sim,3);
S_AR_EME  = NaN(n_sim,3); S_K_EME  = NaN(n_sim,3);  S_J_EME  = NaN(n_sim,3);
S_AR_EME0 = NaN(n_sim,3); S_K_EME0 = NaN(n_sim,3);  S_J_EME0 = NaN(n_sim,3);
S_AR_DM   = NaN(n_sim,3); S_K_DM   = NaN(n_sim,3);  S_J_DM   = NaN(n_sim,3);

S_CLR_EE  = NaN(n_sim,4); S_W_IME  = NaN(n_sim,3);  S_F_IME   = NaN(n_sim,3); 
S_CLR_EE0 = NaN(n_sim,4); S_W_EME  = NaN(n_sim,3);  S_F_pairs = NaN(n_sim,1); 
S_CLR_SE  = NaN(n_sim,3); S_W_pairs= NaN(n_sim,1);     
S_CLR_SE0 = NaN(n_sim,3);

n_b       =26; % # of ar,k,j bootstrap tests
n_b_clr   =14; % # of clr bootstrap tests
n_w_b     = 7; % # of wald bootstrap tests
n_f_b     = 4; % # of F bootstrap tests

col_boot= cumsum([n_b; n_b; n_b; n_b_clr; n_w_b;n_f_b]); 

% bootstrap position
po = (n_boot+1)*(1-alpha);

arho = sqrt(1-rho^2);
avrho= sqrt(1-varrho^2);

RanK_hom     =  @Rank;
if  n_G<=10  
    boot_f_Pairs =  @boot_f_pairs1;
    RanK         =  @Rank_10;
else
    boot_f_Pairs =  @boot_f_pairs;
    RanK         =  @Rank;
end

parfor s = 1:n_sim
    %--- Cluster and Idiosyncratic Residuals
    
    resid_n       = resid_N(:,:,s);
    resid_g       = resid_G(:,:,s);
    
    [resid_u,resid_v]=...
        error_cluster_dgp(resid_g, resid_n,n_G,sqrt_phi,sqrt_varphi,rho,varrho,arho,avrho,l_ini,l_end,iota_n,nu);
    
    %--- DGP
    y2  = Z1*c0   + X*Pi_x +  resid_v;
    y1  = y2*th0  + X*g0   +  resid_u;
    Y0  = y1 - y2*th0;
    
    %---- TSLS estimate and residuals
    Y2          = [y2 X];
    [par, aux2] = tsls_iv(Y2,y1,WWW, P_w);
    e_tsls      = y1 - Y2*par;
    wald_asym   = wald_cluster_iv(par(l_y2)-th0,e_tsls,W,aux2,l_y2,v_G);
    
    Theta_hat(s,:)=par';
    
    g0_ols   = XXX*Y0;
    parr     = [th0; g0_ols]; % constrained TSLS estimator
    
    %--- Auxiliary regression estimates and residuals
    delta_w  = WWW*Y0;                  % unrestricted estimator
    delta_wr = [delta_z ; g0_ols];      % restricted estimator
    Pi_w     = WWW*y2;                  % Inefficient First-Stage estimator
    Pi_w0    = [Pi_z; XX\(X'*y2)];      % restricted estimator under H0: Piz = 0.
    e_til    = M_x*Y0;                  % e_til = e_tsls0  = y1 - Y2*parr;
    e_hat    = M_w*Y0;                  % or e_hat = Y0 - W*delta_w; e_hat for homosk_ case
    v_hat    = M_w*y2;                  % Inefficient First-Stage Residual
    v0       = M_x*y2;                  % error under H0:Piz = 0.
    
    %--- score vectors
    h_til   = score(e_til ,W, v_G,'nr') ;
    h_tilc  = score(e_til ,W, v_G,'r')  ; %recentered score for the score bootstrap
    q_hat   = score(v_hat ,W, v_G,'nr') ;
    
    %--- Covariance Matrices:
    %-   V_hom = covariances homoskedastic case
    [V_hom_deldel, V_hom_Pidel, V_hom_PiPi]= vhom(e_hat,v_hat,n_hom,iWW);
    V_hom_delPi = V_hom_Pidel';
    V_hom_rank  = V_hom_PiPi - V_hom_Pidel(l_w,l_z)*(V_hom_deldel(l_z,l_z)\V_hom_delPi(l_z,l_w));
    
    %--- Meat  = ct*V; ct== Stata adjustment factor(optional)
    %--- V_til= covariances cluster case, restricted residuals
    %--- V_hat= covariances cluster case, unrestricted residuals
    V_til_deldel = (WW\vscore(h_til, h_til, v_G))/WW;
    V_til_Pidel  = (IWW\vscore(q_hat, h_til, v_G))/WW;
    V_til_delPi  = V_til_Pidel';
    V_hat_PiPi   = (IWW\vscore( q_hat, q_hat, v_G))/IWW;
    V_til_rank   = V_hat_PiPi - V_til_Pidel(l_w,l_z)*(V_til_deldel(l_z,l_z)\V_til_delPi(l_z,l_w));
    
    %--- vec(Pi_w0)
    pi_hom_w0  = Pi_w(:) - V_hom_Pidel(l_w,l_z)*(V_hom_deldel(l_z,l_z)\delta_w(l_z));
    pi_til_w0  = Pi_w(:) - V_til_Pidel(l_w,l_z)*(V_til_deldel(l_z,l_z)\delta_w(l_z));
    %--- Rematricizing
    Pi_hom_w0 = reshape(pi_hom_w0,k_w,k_y2); % or Pi_dm_w0 = (W'*M_e*W)\(W'*M_e*y2);
    Pi_til_w0 = reshape(pi_til_w0,k_w,k_y2);
    
    %--- rank (one endogenous variable case)
        
    rk_homo = RanK_hom(Pi_hom_w0(l_z,l_y2),V_hom_rank(l_z,l_z));
    rk_til  = RanK(Pi_til_w0(l_z,l_y2),V_til_rank(l_z,l_z));
        
    v_hom0 = y2 - W*Pi_hom_w0;
    v_til0 = y2 - W*Pi_til_w0;
    
    %--- gamma MD estimator under H0:   (g0_gmm = g0_md)
    g0_md    = delta_w(l_x) - V_til_deldel(l_x,l_z)*(V_til_deldel(l_z,l_z)\delta_w(l_z));
    parr0    = [th0; g0_md];           % constrained MD estimator
    delta_w0 = [delta_z ; g0_md];      % constrained MD estimator - Auxiliary Regression
    
    %---Efficient residuals
    e_til0 = Y0 - X*g0_md;              % e_til0=Y0-X*g0_gmm or e_til0=Y0-W*delta_w0
    h_til0c= score(e_til0 ,W, v_G,'r'); % recentered score for the score bootstrap
    
    %---Weak IV tests
    [ar_homo, k_homo, j_homo]= ar_k_j(delta_w(l_z), V_hom_deldel(l_z,l_z),Pi_hom_w0(l_z,l_y2));
    clr_homo= clr(ar_homo,j_homo,rk_homo);
    
    [ar_asym, k_asym, j_asym]= ar_k_j(delta_w(l_z),V_til_deldel(l_z,l_z),Pi_til_w0(l_z,l_y2));
    clr_asym= clr(ar_asym,j_asym,rk_til);
    
    %--- F-tests: testing instrument strength
    Ftest     = (Pi_w(l_z)'*(V_hat_PiPi(l_z,l_z)\Pi_w(l_z)))/k_z;
	
	%--- effective F based on TSLS
	[Ftest_eff, k_eff, x_eff, k_eff_simp, x_eff_simp] = F_test_eff(Z_x,M_x*y1,M_x*y2,I_n,v_G,tau, brange_max); 
	
    F_asym(s,1)      = Ftest;
    F_eff(s,1)       = Ftest_eff; 
    K_eff(s,1)       = k_eff      ; X_eff(s,1)     = x_eff; 
    K_eff_simp(s,1)  = k_eff_simp ; X_eff_simp(s,1)= x_eff_simp; 
    
    W_asym(s,1) = wald_asym;
    
    AR_homo(s,1)= ar_homo;   K_homo(s,1)  = k_homo;
    AR_asym(s,1)= ar_asym;   K_asym(s,1)  = k_asym;
    
    J_homo(s,1) = j_homo;    CLR_homo(s,1)= clr_homo; Rank_homo(s,1)= rk_homo;
    J_asym(s,1) = j_asym;    CLR_asym(s,1)= clr_asym; Rank_asym(s,1)= rk_til;
    
    wald_b  = zeros(n_boot,n_w_b);
    ar_b    = zeros(n_boot,n_b);
    k_b     = zeros(n_boot,n_b);
    j_b     = zeros(n_boot,n_b);
    clr_b   = zeros(n_boot,n_b_clr);
    f_b     = zeros(n_boot,n_f_b);


    for b = 1:n_boot
        
        %--- Bootstrap Weights
        wi = w_ind  (:,b,s);
        wg = w_gamma(:,b,s);
        wr = w_radem(:,b,s);
        
        %% Estimating Equation Bootstrap or Score Bootstrap (Jacobian is constant)
                
        %---gamma under H0: g0 = XX\(X'*Y0)
        %-- Kleibergen type Bootstrap gamma under H0: g0 = XX\(X'*Y0))
        [ar_b(b,1), k_b(b,1), j_b(b,1)] =  boot_score_m(wi,h_tilc, WW, v_G, l_z, l_y2, Pi_til_w0);      
        clr_b(b,1) = clr(ar_b(b,1),j_b(b,1),rk_til);
        %--Gamma weight
        [ar_b(b,2),  k_b(b,2), j_b(b,2)] =  boot_score(wg, iota_kw, h_tilc, WW, v_G, l_z, l_y2, Pi_til_w0);
        clr_b(b,2) = clr(ar_b(b,2),j_b(b,2),rk_til);
        %--Rademacher weight
        [ar_b(b,3),  k_b(b,3), j_b(b,3)]= boot_score(wr, iota_kw, h_tilc, WW, v_G, l_z, l_y2, Pi_til_w0);
        clr_b(b,3) = clr(ar_b(b,3),j_b(b,3),rk_til);
        
        %---gamma under H0: g0 = g0_md = g0_gmm
        %--Kleibergen type Bootstrap
        [ar_b(b,5), k_b(b,5), j_b(b,5)] =  boot_score_m(wi,h_til0c, WW, v_G, l_z, l_y2, Pi_til_w0);      
        clr_b(b,5) = clr(ar_b(b,5),j_b(b,5),rk_til);
        %--Gamma weight
        [ar_b(b,6),  k_b(b,6), j_b(b,6)]   = boot_score(wg,iota_kw,h_til0c,WW, v_G, l_z, l_y2, Pi_til_w0);
        clr_b(b,6) = clr(ar_b(b,6),j_b(b,6),rk_til);
        %--Rademacher weight
        [ar_b(b,7),  k_b(b,7), j_b(b,7)]= boot_score(wr,iota_kw,h_til0c,WW, v_G, l_z, l_y2, Pi_til_w0);
        clr_b(b,7) = clr(ar_b(b,7),j_b(b,7),rk_til);
        
        %% Weights - Residual Bootstraps
        W_Wild_g     = w_matrix(n_G, wg, I_n, Weight, v_G);
        W_Wild_r     = w_matrix(n_G, wr, I_n, Weight, v_G);
        
        %% Single Equation Residual Bootstrap. Under H0: g0 = XX\(X'*Y0)
        
        %--Gamma weight
        [ar_b(b,9),k_b(b,9),j_b(b,9)]=  boot_se(e_til,W_Wild_g,M_x,W,WW,WWW, v_G,l_z,l_y2,Pi_til_w0);
        clr_b(b,9) = clr(ar_b(b,9),j_b(b,9),rk_til);
        %-- Rademacher weight
        [ar_b(b,10),k_b(b,10),j_b(b,10)]=  boot_se(e_til,W_Wild_r,M_x,W,WW,WWW, v_G,l_z,l_y2,Pi_til_w0);
        clr_b(b,10) = clr(ar_b(b,10),j_b(b,10),rk_til);
        
        %--Gamma weight
        [ar_b(b,12),k_b(b,12),j_b(b,12)]=  boot_se(e_til0,W_Wild_g,M_x,W,WW,WWW, v_G,l_z,l_y2,Pi_til_w0);
        clr_b(b,12) = clr(ar_b(b,12),j_b(b,12),rk_til);
        %-- Rademacher weight
        [ar_b(b,13),k_b(b,13),j_b(b,13)]=  boot_se(e_til0,W_Wild_r,M_x,W,WW,WWW, v_G,l_z,l_y2,Pi_til_w0);
        clr_b(b,13) = clr(ar_b(b,13),j_b(b,13),rk_til);
        
        %% Multi-Equation Residual Bootstrap
        
        %---Inefficient Wild Restricted (not imposing restrictions on the first stage)
        %--Gamma weight
        [ar_b(b,15),k_b(b,15),j_b(b,15)]= boot_me(e_til,v_hat,W_Wild_g,M_x,M_w,W,WW,WWW,IWW,v_G,l_w,l_z,l_y2,Pi_w,k_w,k_y2);
        
        %--Rademacher weight
        [ar_b(b,16),k_b(b,16),j_b(b,16)]= boot_me(e_til,v_hat,W_Wild_r,M_x,M_w,W,WW,WWW,IWW,v_G,l_w,l_z,l_y2,Pi_w,k_w,k_y2);
       
        %---Efficient Wild Restricted
        %--Gamma weight
        [ar_b(b,18),k_b(b,18),j_b(b,18)]= boot_me(e_til,v_til0,W_Wild_g,M_x,M_w,W,WW,WWW,IWW,v_G,l_w,l_z,l_y2,Pi_til_w0,k_w,k_y2);
        %--Rademacher weight
        [ar_b(b,19),k_b(b,19),j_b(b,19)]= boot_me(e_til,v_til0,W_Wild_r,M_x,M_w,W,WW,WWW,IWW,v_G,l_w,l_z,l_y2,Pi_til_w0,k_w,k_y2);
        
        %---New Efficient Wild Restricted
        %--Gamma weight
        [ar_b(b,21),k_b(b,21),j_b(b,21)]= boot_me(e_til0,v_til0,W_Wild_g,M_x,M_w,W,WW,WWW,IWW,v_G,l_w,l_z,l_y2,Pi_til_w0,k_w,k_y2);
        %--Rademacher weight
        [ar_b(b,22),k_b(b,22),j_b(b,22)]= boot_me(e_til0,v_til0,W_Wild_r,M_x,M_w,W,WW,WWW,IWW,v_G,l_w,l_z,l_y2,Pi_til_w0,k_w,k_y2);

        %% Davidson&MacKinnon Efficient Restricted Bootstrap
        %--- Sampled at cluster level, computed using the homoskedastic version of the weak-IV tests
        %--Gamma weight
        [ar_b(b,24),k_b(b,24),j_b(b,24)]= boot_me_dm(e_til,v_hom0,W_Wild_g,M_w,iWW,WWW,l_w,l_z,l_y2,Pi_hom_w0,k_w,k_y2,n_hom);
        %--Rademacher weight
        [ar_b(b,25),k_b(b,25),j_b(b,25)]= boot_me_dm(e_til,v_hom0,W_Wild_r,M_w,iWW,WWW,l_w,l_z,l_y2,Pi_hom_w0,k_w,k_y2,n_hom);

        %% Wald residual bootstrap
        %-- DGP based on 2sls estimator
        %--Gamma weight
        wald_b(b,1)= boot_me_wald(e_tsls,v_hat,W_Wild_g,X,W,WWW,P_w,l_y2,Pi_w,par,v_G);
        %--Rademacher weight
        wald_b(b,2)= boot_me_wald(e_tsls,v_hat,W_Wild_r,X,W,WWW,P_w,l_y2,Pi_w,par,v_G);
        
        %-- DGP based imposing the null in the first and  second stages
        %--Gamma weight
        wald_b(b,4)= boot_me_wald(e_til,v_til0,W_Wild_g,X,W,WWW,P_w,l_y2,Pi_til_w0,parr,v_G);
        %--Rademacher weight
        wald_b(b,5)= boot_me_wald(e_til,v_til0,W_Wild_r,X,W,WWW,P_w,l_y2,Pi_til_w0,parr,v_G);
        
        %% Wald Pairs Bootstrap
        DD = boot_sample([y1 y2 W], n_par, l_ini(wi),l_end(wi),v_G(wi));
        wald_b(b,7)= boot_pairs_wald(DD,par,col,l_y2,v_G(wi));
        
    end
    ws= sort([ar_b k_b j_b clr_b wald_b f_b]);
    col_boo=col_boot;
    ws_ar  = ws(:,1:col_boo(1))               ;  ws_k  = ws(:,col_boo(1)+1:col_boo(2));
    S_AR_EE  (s,:) = (ws_ar(po, 1: 4)<ar_asym);  S_K_EE  (s,:) = (ws_k(po, 1: 4)<k_asym);
    S_AR_EE0 (s,:) = (ws_ar(po, 5: 8)<ar_asym);  S_K_EE0 (s,:) = (ws_k(po, 5: 8)<k_asym);
    S_AR_SE  (s,:) = (ws_ar(po, 9:11)<ar_asym);  S_K_SE  (s,:) = (ws_k(po, 9:11)<k_asym);
    S_AR_SE0 (s,:) = (ws_ar(po,12:14)<ar_asym);  S_K_SE0 (s,:) = (ws_k(po,12:14)<k_asym);
    S_AR_IME (s,:) = (ws_ar(po,15:17)<ar_asym);  S_K_IME (s,:) = (ws_k(po,15:17)<k_asym);
    S_AR_EME (s,:) = (ws_ar(po,18:20)<ar_asym);  S_K_EME (s,:) = (ws_k(po,18:20)<k_asym);
    S_AR_EME0(s,:) = (ws_ar(po,21:23)<ar_asym);  S_K_EME0(s,:) = (ws_k(po,21:23)<k_asym);
    S_AR_DM  (s,:) = (ws_ar(po,24:26)<ar_homo);  S_K_DM  (s,:) = (ws_k(po,24:26)<k_homo);
    
    ws_j  = ws(:,col_boo(2)+1:col_boo(3))   ;    ws_clr  = ws(:,col_boo(3)+1:col_boo(4));
    S_J_EE   (s,:) = (ws_j(po, 1: 4)<j_asym);    S_CLR_EE (s,:)= (ws_clr(po, 1: 4) <clr_asym);
    S_J_EE0  (s,:) = (ws_j(po, 5: 8)<j_asym);    S_CLR_EE0(s,:)= (ws_clr(po, 5: 8) <clr_asym);
    S_J_SE   (s,:) = (ws_j(po, 9:11)<j_asym);    S_CLR_SE (s,:)= (ws_clr(po, 9:11) <clr_asym);
    S_J_SE0  (s,:) = (ws_j(po,12:14)<j_asym);    S_CLR_SE0(s,:)= (ws_clr(po,12:14) <clr_asym);
    S_J_IME  (s,:) = (ws_j(po,15:17)<j_asym);    
    S_J_EME  (s,:) = (ws_j(po,18:20)<j_asym);    
    S_J_EME0 (s,:) = (ws_j(po,21:23)<j_asym);    
    S_J_DM   (s,:) = (ws_j(po,24:26)<j_homo);    
        
    ws_w  = ws(:,col_boo(4)+1:col_boo(5))      ;  ws_f  = ws(:,col_boo(5)+1:col_boo(6));
    S_W_IME   (s,:)= (ws_w(po, 1: 3)<wald_asym);  S_F_IME   (s,:)= (ws_f(po,1: 3)<Ftest);
    S_W_EME   (s,:)= (ws_w(po, 4: 6)<wald_asym);  S_F_pairs (s,:)= (ws_f(po, 4)  <Ftest);
    S_W_pairs (s,:)= (ws_w(po, 7)<wald_asym);    
       
end

% delete(gcp('nocreate')) %parallel computing function

%----Critical Values
prob     = 1-alpha;
CV_AR    = chi2inv(prob,k_z) ;
CV_K     = chi2inv(prob,k_y2);
CV_J     = chi2inv(prob,k_z-k_y2);
CV_F     = chi2inv(prob,k_z)/k_z;       % CV first-stage F-test

df       = [K_eff K_eff_simp]; 
ncp      = [X_eff.*K_eff X_eff_simp.*K_eff_simp]; %non centrality parameters
CV_F_eff = ncx2inv(prob,df,ncp)./df;

%% --- Saving the results
ones_n_sim = ones(n_sim,1);

Size_F_asym     = 100*(mean(ones_n_sim*CV_F < F_asym));                  
Size_F_eff      = 100*(mean(CV_F_eff(:,1)   < F_eff));
Size_F_eff_simp = 100*(mean(CV_F_eff(:,2)   < F_eff));

Size_W_asym     = 100*(mean(ones_n_sim*CV_K < W_asym));

Size_AR_homo    = 100*(mean(ones_n_sim*CV_AR < AR_homo));
Size_K_homo     = 100*(mean(ones_n_sim*CV_K  < K_homo));
Size_J_homo     = 100*(mean(ones_n_sim*CV_J  < J_homo));

Size_AR_asym    = 100*(mean(ones_n_sim*CV_AR < AR_asym));
Size_K_asym     = 100*(mean(ones_n_sim*CV_K  < K_asym));
Size_J_asym     = 100*(mean(ones_n_sim*CV_J  < J_asym));

Size_T_mix      = 100* (mean((F_eff  < CV_F_eff(:,1))& (ones_n_sim*CV_AR < AR_asym) | ...
                       (CV_F_eff(:,1)< F_eff )       & (ones_n_sim*CV_K  < W_asym)));

Size_T_mix_simp = 100*(mean((F_eff    < CV_F_eff(:,2))& (ones_n_sim*CV_AR < AR_asym) | ...
                      (CV_F_eff(:,2)< F_eff )         & (ones_n_sim*CV_K < W_asym)));			   
                   
%---Critical values CLR test
CV_CLR       = Cvalue_CLR(k_y2,k_z,alpha, Rank_homo);
Size_CLR_homo= 100*(mean(CV_CLR< CLR_homo));

CV_CLR       = Cvalue_CLR(k_y2,k_z,alpha, Rank_asym);
Size_CLR_asym= 100*(mean(CV_CLR< CLR_asym));

Theta_0    = [th0 g0'] ;
Mean_Bias  = mean(Theta_hat)  - Theta_0;
SD_Bias    = std(Theta_hat);

A_f_test= struct( 'asym'      , Size_F_asym,...
                  'IME'       , squeeze(100*nanmean(S_F_IME))  ,...
				  'pairs'     , squeeze(100*nanmean(S_F_pairs)),...
				  'eff'       , Size_F_eff,...
				  'eff_s'     , Size_F_eff_simp,...
				  'k_eff'     , mean(K_eff),... 
				  'k_eff_s'   , mean(K_eff_simp),...
				  'x_eff'     , mean(X_eff),...
				  'x_eff_simp', mean(X_eff_simp)); 
				  
A_T_test= struct('mix' ,  Size_T_mix,...
				 'mix_s', Size_T_mix_simp);
			  
A_wald_test=struct('asym', Size_W_asym,...
                  'IME'  , squeeze(100*nanmean(S_W_IME)),...
                  'EME'  , squeeze(100*nanmean(S_W_EME)),...
                  'pairs', squeeze(100*nanmean(S_W_pairs)));  				  
              
A_ar_test=struct('homo'  , Size_AR_homo  ,...
                 'asym'  , Size_AR_asym  ,...
                 'EE'    , squeeze(100*nanmean(S_AR_EE  ))  ,...
                 'EE0'   , squeeze(100*nanmean(S_AR_EE0 ))  ,...
                 'SE'    , squeeze(100*nanmean(S_AR_SE  ))  ,...
                 'SE0'   , squeeze(100*nanmean(S_AR_SE0 ))  ,...
                 'IME'   , squeeze(100*nanmean(S_AR_IME ))  ,...
                 'EME'   , squeeze(100*nanmean(S_AR_EME ))  ,...
                 'EME0'  , squeeze(100*nanmean(S_AR_EME0))  ,...
                 'DM'    , squeeze(100*nanmean(S_AR_DM  )));

A_k_test =struct('homo'  , Size_K_homo  ,...
                 'asym'  , Size_K_asym  ,...
                 'EE'    , squeeze(100*nanmean(S_K_EE  ))  ,...
                 'EE0'   , squeeze(100*nanmean(S_K_EE0 ))  ,...
                 'SE'    , squeeze(100*nanmean(S_K_SE  ))  ,...
                 'SE0'   , squeeze(100*nanmean(S_K_SE0 ))  ,...
                 'IME'   , squeeze(100*nanmean(S_K_IME ))  ,...
                 'EME'   , squeeze(100*nanmean(S_K_EME ))  ,...
                 'EME0'  , squeeze(100*nanmean(S_K_EME0))  ,...
                 'DM'    , squeeze(100*nanmean(S_K_DM  )));				 
				 
A_j_test =struct('homo'  , Size_J_homo  ,...
                 'asym'  , Size_J_asym  ,...
                 'EE'    , squeeze(100*nanmean(S_J_EE  ))  ,...
                 'EE0'   , squeeze(100*nanmean(S_J_EE0 ))  ,...
                 'SE'    , squeeze(100*nanmean(S_J_SE  ))  ,...
                 'SE0'   , squeeze(100*nanmean(S_J_SE0 ))  ,...
                 'IME'   , squeeze(100*nanmean(S_J_IME ))  ,...
                 'EME'   , squeeze(100*nanmean(S_J_EME ))  ,...
                 'EME0'  , squeeze(100*nanmean(S_J_EME0))  ,...
                 'DM'    , squeeze(100*nanmean(S_J_DM  )));				 				 
          
A_clr_test=struct('homo', Size_CLR_homo  ,...
                 'asym' , Size_CLR_asym  ,...
                 'EE'   , squeeze(100*nanmean(S_CLR_EE  ))  ,...
                 'EE0'  , squeeze(100*nanmean(S_CLR_EE0 ))  ,...
                 'SE'   , squeeze(100*nanmean(S_CLR_SE  ))  ,...
                 'SE0'  , squeeze(100*nanmean(S_CLR_SE0 )));
				 
clear Size* CV*  resid* W*       
             
save(slabel, 'A_f_test'     , 'A_T_test'   , 'A_wald_test', 'A_ar_test', 'A_k_test' , 'A_j_test', 'A_clr_test',...
                'alpha'     , 'Mean_Bias'  , 'SD_Bias' , 'mu_hom'     ,  'cp_k_hom', 'c0'       ,'c01')
 

toc