%Daron Acemoglu, Simon Johnson, and James A. Robinson "The Colonial
%Origins of Comparative Development: An Empirical Investigation: Reply"

%original AJR mortality series capped at 250

addpath('.../functions','-end')

clear;
data  = sortrows(xlsread('data_colonial.xls','data'),1);

ind_nneo    = (data(:,8)==0);
ind_mal     = ~isnan(data(:,24));
ind_nafrica = (data(:,10)==0);

data_nneo    = data(ind_nneo,:);
data_mal     = data(ind_mal,:);
data_nafrica = data(ind_nafrica,:);

n_boot    = 2999;                   % # of bootstrap samples

mkdir('results');

parpool('local',8) %parallel computing function

n_obs = size(data,1);
% Organizing the data for estimation
n_G = 36;
i=1;
l_ini= [1 ; zeros(n_G-1,1)];
for g=2:n_G
    while (i<n_obs && data(i,1)==data(i+1,1))
        i = i+1;
    end
    i = i+1;
    l_ini(g,1)=i;
    
end
l_end = [l_ini(2:end)-1;n_obs];
v_G   = l_end-l_ini +1;          % # of observations per cluster  

%% No Covariates

y1 = data(:,3);
y2 = data(:,2);
Z  = data(:,21);
X  = ones(n_obs,1);              
theta0 = 0.20:.01:2.5;        % values of theta under H0

tic
conf_int_colonial(y1, y2, Z, X, theta0, n_G, l_ini, l_end, v_G, n_boot, 'T1_C2_R1', 'p')
toc

%% With latitude

X  = [ones(n_obs,1) data(:,7)];   

theta0 = 0.20:0.01:3.5 ;      % values of theta under H0
      
tic
conf_int_colonial(y1, y2, Z, X, theta0, n_G, l_ini, l_end, v_G, n_boot, 'T1_C2_R2', 'p')
toc

%% With continent dummies

X  = [ones(n_obs,1) data(:,9:11)];  

theta0 = -2:.01:5 ;      % values of theta under H0

tic
conf_int_colonial(y1, y2, Z, X, theta0, n_G, l_ini, l_end, v_G, n_boot, 'T1_C2_R4', 'n')
toc

%% With continent dummies and latitude

X  = [ones(n_obs,1) data(:,7) data(:,9:11)]; 

theta0 = -2:.01:5 ;      % values of theta under H0

tic
conf_int_colonial(y1, y2, Z, X, theta0, n_G, l_ini, l_end, v_G, n_boot, 'T1_C2_R5', 'n')
toc

%% with percentage of european descent in 1975

X  = [ones(n_obs,1) data(:,12)]; 

theta0 = -2.0:.01:2.5 ;      % values of theta under H0

tic
conf_int_colonial(y1, y2, Z, X, theta0, n_G, l_ini, l_end, v_G, n_boot, 'T1_C2_R6', 'p')
toc

%% without neo Europes

n_obs = size(data_nneo,1);
% Organizing the data for estimation
n_G = 33;
i=1;
l_ini= [1 ; zeros(n_G-1,1)];
for g=2:n_G
    while (i<n_obs && data_nneo(i,1)==data_nneo(i+1,1))
        i = i+1;
    end
    i = i+1;
    l_ini(g,1)=i;
    
end
l_end = [l_ini(2:end)-1;n_obs];
v_G   = l_end-l_ini +1;          % # of observations per cluster  


y1 = data_nneo(:,3);
y2 = data_nneo(:,2);
Z  = data_nneo(:,21);
X  = ones(n_obs,1);              


theta0 = -2:0.01:10 ;      % values of theta under H0

tic
conf_int_colonial(y1, y2, Z, X, theta0, n_G, l_ini, l_end, v_G, n_boot, 'T1_C2_R3', 'p')
toc

% with malaria

n_obs = size(data_mal,1);
% Organizing the data for estimation
n_G = 35;
i=1;
l_ini= [1 ; zeros(n_G-1,1)];
for g=2:n_G
    while (i<n_obs && data_mal(i,1)==data_mal(i+1,1))
        i = i+1;
    end
    i = i+1;
    l_ini(g,1)=i;
    
end
l_end = [l_ini(2:end)-1;n_obs];
v_G   = l_end-l_ini +1;          % # of observations per cluster  

y1 = data_mal(:,3);
y2 = data_mal(:,2);
Z  = data_mal(:,21);
X  = [ones(n_obs,1) data_mal(:,24)];              


theta0 = -2:.01:10 ;      % values of theta under H0

tic
conf_int_colonial(y1, y2, Z, X, theta0, n_G, l_ini, l_end, v_G, n_boot, 'T1_C2_R7', 'p')
toc

%% Without Africa 

n_obs = size(data_nafrica,1);
% Organizing the data for estimation
n_G = 19;
i=1;
l_ini= [1 ; zeros(n_G-1,1)];
for g=2:n_G
    while (i<n_obs && data_nafrica(i,1)==data_nafrica(i+1,1))
        i = i+1;
    end
    i = i+1;
    l_ini(g,1)=i;
    
end
l_end = [l_ini(2:end)-1;n_obs];
v_G   = l_end-l_ini +1;          % # of observations per cluster  


y1 = data_nafrica(:,3);
y2 = data_nafrica(:,2);
Z  = data_nafrica(:,21);
X  = ones(n_obs,1);              

theta0 = -2:0.01:10 ;      % values of theta under H0

tic
conf_int_colonial(y1, y2, Z, X, theta0, n_G, l_ini, l_end, v_G, n_boot, 'T1_C2_R8', 'p')
toc

delete(gcp('nocreate')) %parallel computing function


rmpath('.../functions')



