%Edward Miguel, Sahnker Satyanath and Ernest Sergenti "Economic Shocks and
%Civil COnflit: an instrumental variable approach"

clear;
clc;

tic

addpath('.../functions','-end')

load('data_civil_war.mat');

% Organizing the data for estimation
data = sortrows(data_civil_war,[1 18:1:58]);

clear data_civil_war

mkdir('results');

n_boot= 1999;                      % # of bootstrap samples
n_obs = size(data,1);

n_G   = 41;

i=1;
l_ini= [1 ; zeros(n_G-1,1)];
for g=2:n_G
    while (i<n_obs && data(i,1)==data(i+1,1))
        i = i+1;
    end
    i = i+1;
    l_ini(g,1)=i;
    
end
l_end = [l_ini(2:end)-1;n_obs];
v_G   = l_end-l_ini +1;          % # of observations per cluster 


y1 = data(:,8);
y2 = data(:, 9:10);
Z  = data(:, 100:101);

parpool('local',8) %parallel computing function

theta_1 = -6:.25:4;      % values of theta under H0
theta_2 = -8:.25:5;      % values of theta under H0  .25

%% IV-2SLS - Table C3 - equation (5) - with country specific time trend and fixed effects
    
X  = [ones(n_obs,1) data(:,18:58) data(:,59:87) data(:,89:99)];

tic
conf_set_civil(y1, y2, Z, X, theta_1, theta_2, n_G, v_G, n_boot, 'TC3_C5')
toc

delete(gcp('nocreate')) %parallel computing function
 
toc

rmpath('.../functions')



