%Edward Miguel, Sahnker Satyanath and Ernest Sergenti "Economic Shocks and
%Civil COnflit: an instrumental variable approach"

clear;
clc;

tic

addpath('.../functions','-end')

load('data_civil_war.mat');

% Organizing the data for estimation
data = sortrows(data_civil_war,[1 18:1:58]);

clear data_civil_war

mkdir('results');

n_boot= 1999;                      % # of bootstrap samples

var = ~isnan(data(:,3));

data = data(var,:);
% Organizing the data for estimation

n_obs = size(data,1);
n_G   = 40;


i=1;
l_ini= [1 ; zeros(n_G-1,1)];
for g=2:n_G
    while (i<n_obs && data(i,1)==data(i+1,1))
        i = i+1;
    end
    i = i+1;
    l_ini(g,1)=i;
    
end
l_end = [l_ini(2:end)-1;n_obs];
v_G   = l_end-l_ini +1;          % # of observations per cluster 

y1 = data(:,3);
y2 = data(:, 9:10);
Z  = data(:, 100:101);

parpool('local',8) %parallel computing function

theta_1 = -20:.25:8;      % values of theta under H0
theta_2 = -15:.25:40;      % values of theta under H0

%% IV-2SLS - Table 6 - equation (1) - with country specific time trend and fixed effects 
    
X  = [ones(n_obs,1) data(:,18:46) data(:,48:58)  data(:,59:76) data(:,78:84) data(:,86:87) data(:,89:99)];

tic
conf_set_civil(y1, y2, Z, X, theta_1, theta_2, n_G, l_ini, l_end, v_G, n_boot, 'T6_C1')
toc


delete(gcp('nocreate')) %parallel computing function
 
toc

rmpath('.../functions')



