%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% 1. Setup and load data and results %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
clear;
clc;
close all;

BETA    = [.97 .98];
RHO     = ones(1,2)*1.5;
SIGMA   = ones(1,2)*0.1;

G = [];
for EDUC=0:1
    name = ['_educ' num2str(EDUC) '_beta' num2str(BETA(EDUC+1)) '_rho' num2str(RHO(EDUC+1)) '_sigma' num2str(SIGMA(EDUC+1))];
    load(['results\est' name '.mat']);  
    est_pars{EDUC+1} = par;
    
    G(:,EDUC+1) = par.G;
end

for EDUC = [0 1]
    
    % a. load estimates
    par = est_pars{EDUC+1};
    
    % b. load data
    data = est.load_data(EDUC,par);
    
    % c. initial values and draws
    rng(par.seed)
    draws = est.draws(par,data);
    
    % d. simulate data
    sol = mex_solve(par);
    sim = est.simulate(par,sol,draws);
    
    FontSize = 17;
    hist_color = .3;
    
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % 2. Initial distributions           %
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    vars = {'A','P','k'};
    x_vars = {'wealth','permanent income','children'};
    nums = [25 25 5];
    for v=1:numel(vars)
        var = vars{v};
        x_var = x_vars{v};
        num   = nums(v);
        
        figure()
        h = histogram(data.init.(var),num,'Normalization','probability','FaceColor',hist_color*ones(1,3));
        if strcmp(var,'k')
            h.BinEdges = -.5:3.5;
            xlim([-.5 3.5])
        else
            %grid on
        end
        xlabel(x_var)
        ylabel('share')
        
        set(gca,'FontSize',FontSize)
        print('-depsc',['Results\cali_init' var num2str(EDUC) '.eps'])
    end
    
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % 3. Income and wealth growth        %
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    age_grid = 24:60;
    vars     = {'Y','A','a'};
    x_vars = {'income','wealth','wealth to income'};
    data.a = data.A./data.Y;
    sim.a  = sim.A./sim.Y;
    
    for i=1:numel(vars)
        Profile(EDUC+1).data.(vars{i}) = est.age_profile(age_grid,data.age,data.(vars{i}));
        Profile(EDUC+1).sim.(vars{i})  = est.age_profile(age_grid,sim.age,sim.(vars{i}));
        
        figure()
        plot(age_grid,Profile(EDUC+1).data.(vars{i}),'.-black','LineWidth',2,'MarkerSize',20)
        hold on
        plot(age_grid,Profile(EDUC+1).sim.(vars{i}),'--black','LineWidth',2)
        hold off
        xlim([min(age_grid) max(age_grid)])
        grid on
        legend('BHPS data','Model','Location','NorthWest')
        ylabel(x_vars{i})
        xlabel('age')
        set(gca,'FontSize',FontSize)
        
        print('-depsc',['Results\cali_' vars{i} num2str(EDUC) '.eps'])
    end
    
end % educational loop

%%
figure()
plot(age_grid,Profile(1).data.Y,'-black','LineWidth',2.5,'MarkerSize',20)
hold on
plot(age_grid,Profile(2).data.Y,'--black','LineWidth',2.5,'MarkerSize',20)

plot(age_grid,Profile(1).sim.Y,'-black','LineWidth',1)

plot(age_grid,Profile(2).sim.Y,'-black','LineWidth',1)
hold off
xlim([min(age_grid) max(age_grid)])
grid on
legend('BHPS, low skilled','BHPS, high skilled','Model','Location','NorthWest')
ylabel('Income')
xlabel('age')
set(gca,'FontSize',FontSize)
print('-depsc',['Results\cali_Y.eps'])

%%

age_grid = par.agemin:(par.agemin-1+numel(par.G));

figure()
plot(age_grid,G(1:numel(age_grid),1),'-black',age_grid,G(1:numel(age_grid),2),'--black','LineWidth',2)
legend('Low skilled','High skilled','Location','NorthEast')
ylabel('permanent income growth, G')
xlabel('age')
xlim([min(age_grid) max(age_grid)])
set(gca,'FontSize',FontSize)
grid on
print('-depsc',['Results\cali_G.eps'])

figure()
plot(age_grid,G(1:numel(age_grid),1),'-black','LineWidth',2)
ylabel('permanent income growth, G')
xlabel('age')
xlim([min(age_grid) max(age_grid)])
set(gca,'FontSize',FontSize)
grid on
print('-depsc',['Results\cali_G0.eps'])

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% 4. Bioligical fecundity            %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Trussel and Wilson (1985, Table 8)
TWage = [ 22  27  32   37   42   47]';
TWinf = [4.6 9.1 16.6 25.4 62.2 92.9]'./100; % infertility share
x     = [ones(numel(TWage),1), TWage];
b     =(x'*x)\(x'*log(TWinf));

fit_fun  = @(age) min( 1 , exp([ones(size(age,1),1), age ]*b) );
fert_fun = @(age) 1 - fit_fun(age);
age_grid = (20:.1:50)' ;

figure()
plot(TWage,TWinf,'.black',age_grid,fit_fun(age_grid),'-black','LineWidth',2,'MarkerSize',20)
grid on
xlim([20 50])
legend('Trussel and Wilson (1985)','Exponential in age','Location','NorthWest')
xlabel('age')
ylabel('infertilty rate')
set(gca,'FontSize',FontSize,'XTick',20:5:50)
print('-depsc','Results\cali_infertility.eps')

figure()
plot(age_grid,fert_fun(age_grid),'-black','LineWidth',2,'MarkerSize',20)
grid on
xlabel('age')
ylabel('biological fecundity')
xlim([20 50])
set(gca,'FontSize',FontSize,'XTick',20:5:50)
print('-depsc','Results\cali_fecundity.eps')