

namespace vfi {

    void construct_EV_pd(double *EV_pd,par_struct *par,size_t t,size_t g,size_t k, double P);
    double vfi_obj_pd(double C,size_t e, size_t q,par_struct *par,double M, size_t t,size_t g, size_t k, size_t i_P,double *EV_pd);
    double vfi_obj(double C,size_t e, size_t q,par_struct *par,double M, size_t t,size_t g, size_t k, size_t i_P);
    
    void solve(par_struct *par)
    {
        #pragma omp parallel num_threads(THREADS)
        {

        // a. setup
        //auto sol = new sol_struct;
        //sol::setup(par,sol);
        double *EV_pd;
        if(par->do_pd==1){
            EV_pd = new double[par->Ne*par->Nq*par->Na];
        } else {
            EV_pd = new double[1];
        }

        if(par->do_nlopt==1){
        }

        for(size_t t=par->TR ; t--> 0 ;){

            #pragma omp for collapse(1)
            for(size_t i_P=0 ; i_P<par->Np ; i_P++){ 

            for(size_t g=0 ; g<par->Ng ; g++){
            for(size_t k=0 ; k<par->Nk ; k++){

                // restrict attention to situations which are relevant TODO: move this perhaps into a function that determines num_g_now
                if(k==par->Nk-1 && g>0){             continue; } // have maximum amount of children so cannot be pregnant
                if(t>par->max_age_pregnant && g>0 ){ continue; } // older than maximum pregnancy age, so cannot be pregnant

                // construct EV_pd
                if(par->do_pd==1){
                    vfi::construct_EV_pd(EV_pd,par,t,g,k,par->grid_P[i_P]);
                }

                for(size_t i_m=0; i_m<par->Nm;i_m++){ // loop through resources
                    double m_now = par->grid_m[i_m];
                    double M_now = m_now*par->grid_P[i_P];

                    // find optimal choice
                    double V_opt = -LARGE_NUMBER; 
                    double C_opt = 0.0; 
                    double Vd_opt,Cd_opt; 
                    for(size_t e=0; e<par->Ne; e++) {// loop through discrete choices available
                    for(size_t q=0; q<par->Nq; q++) {
                        if(g<2 && q>0){        continue;} // not pregnant or intended pregnancy so cannot have an abortion [TODO: asign perhaps a very large negative number]
                        //if(k==par->Nk-1 && e>0){continue;} // have maximum number of children so cannot get pregnant. Since there is no effort, cost households would be indifferent between trying and not

                            // loop through consumption guesses
                            Vd_opt = -LARGE_NUMBER;
                            Cd_opt = 0.0;
                            if(par->do_nlopt==1){


                            } else {
                                    // loop through discrete grid of consumption guesses
                                for(size_t i_C=0; i_C<par->Nc_guess; i_C++){
                                    double delta = ((double) i_C)/((double) par->Nc_guess-1.0);
                                    //double C_now = par->min_C + delta*(M_now - par->min_C); // cannot borrow here
                                    double C_now = par->min_C + delta*(M_now + par->credit*par->grid_P[i_P] - par->min_C); // can borrow here

                                    double V_now;
                                    if(par->do_pd==0){
                                        V_now = vfi::vfi_obj(C_now,e,q,par,M_now,t,g,k,i_P);
                                    } else {
                                        V_now = vfi::vfi_obj_pd(C_now,e,q,par,M_now,t,g,k,i_P,EV_pd);
                                    }

                                    // update discrete choice-specific maximum
                                    if(V_now>Vd_opt){
                                        Cd_opt = C_now;
                                        Vd_opt = V_now;
                                    }    

                                } // discrete consumption
                            
                            }

                            // Store choice-specific value functions
                            size_t d  = index::discrete(e,q,par->Nq);
                            size_t id = index::d5(d,g,k,i_P,i_m,par->Ng,par->Nk,par->Np,par->Nm);
                            par->Vd[t][id] = Vd_opt;

                            // update maximum over discrete choices
                            if(Vd_opt>V_opt){
                                V_opt = Vd_opt;
                                C_opt = Cd_opt;
                            }
                    
                    } // abortion   
                    } // effort

                    // store solution in par struct TODO: move this outside such that only t-loop. for parallelization
                    #pragma omp critical
                    {
                    size_t i = index::d4(g,k,i_P,i_m,par->Nk,par->Np,par->Nm);
                    par->C[t][i] = C_opt;
                    par->V[t][i] = V_opt;
                    par->m[t][i] = m_now;
                    
                    } // critical

                } // resources

            }
            }
            }
        }

        // destroy
        //sol::destroy(sol);
        //delete sol;
        delete[] EV_pd;
        if(par->do_nlopt==1){
        
        }

        } // pragma

    } // vfi solve function

    double EV_pd(size_t t,size_t k,size_t g, double P, double A,
                size_t k_next, size_t num_g,double *p_g_vec,
                par_struct *par)
    {
        double P_next, Y_next, m_next;
        //size_t k_next = k + b;
        double P_alpha = P;
        if(par->alpha<1){
            P_alpha = pow(P , par->alpha);
        }
        
        // Income shocks (depend on retirement)
        size_t Nshocks  = par->Nshocks*par->Nshocks;
        double perm     = 1.0;
        double trans    = 1.0;
        double p_Y_next = 1.0;
        double ret_adj  = 1.0;
        double credit_adj = 0.0;
        if(t==par->TR-1){ // retirement next period-> no uncertainty
            Nshocks     = 1;
            ret_adj     = par->gamma;
            // credit_adj = par->credit; // TODO
        }

        double EV         = 0.0;
        double check_prob = 0.0;
        for(size_t i_shock=0; i_shock<Nshocks ; i_shock++){

            if(t<par->TR-1){
                perm     = par->perm[i_shock];
                trans    = par->trans[i_shock];
                p_Y_next = par->weight[i_shock];
            }

            // Next-period income
            util::next_period_resources(t,&m_next,&P_next,&Y_next,
                            k,g,P_alpha,A,  
                            k_next,perm,trans,par);
            m_next = m_next - credit_adj; // adjust the next-period level of resources if the next period is retirement. This is rather than adjusting the grid itself

            for(size_t g_next=0; g_next<num_g;g_next++){

                // interpolate next-period value function
                size_t i_next        = index::d4(g_next,k_next,0,0,par->Nk,par->Np,par->Nm); 
                double interp_V_next = interp::vfi(&(par->V[t+1][i_next]), par->grid_P,par->grid_m, P_next, m_next,par->Np,par->Nm,1,1,par);

                // update expectations and check-sum
                EV         += p_g_vec[g_next]*p_Y_next*interp_V_next; 
                check_prob += p_g_vec[g_next]*p_Y_next;

            }
        } 

        if(check_prob<0.999 || check_prob>1.000001){ printf("WARNING: check_prob=%g\n",check_prob); }

        return ret_adj*EV;
    }

    double vfi_obj(double C,size_t e, size_t q,par_struct *par,double M, size_t t,size_t g, size_t k, size_t i_P)
    {
        // next period states: allocation
        size_t num_g, k_next; 
        auto g_vec   = new size_t[2];
        auto p_g_vec = new double[2];
        util::next_period_children(&k_next,g_vec,p_g_vec,&num_g,
                                    t,g,k,
                                    e,q,par);
        //size_t b       = k_next!=k; // a birth. does not matter how it came about (q/g)
        double A       = M - C; // post-decision variables

        // calculate expected value:
        double EV_next = vfi::EV_pd(t,k,g,par->grid_P[i_P] ,A,k_next,num_g,p_g_vec,par);

        // Calculate value of choice
        double val     = util::U(C,q,k,t,par) + par->beta*EV_next;

        delete[] g_vec;
        delete[] p_g_vec;

        return val; 

    }

    double vfi_obj_pd(double C,size_t e, size_t q,par_struct *par,double M, size_t t,size_t g, size_t k, size_t i_P,double *EV_pd)
    {
  
        double P = par->grid_P[i_P];

        // next period states (allocation)
        size_t num_g, k_next; 
        auto g_vec   = new size_t[2];
        auto p_g_vec = new double[2];
        util::next_period_children(&k_next,g_vec,p_g_vec,&num_g,
                                    t,g,k,
                                    e,q,par);
        double a       = (M - C)/P; // post-decision variables

        // interpolate expected value:
        size_t i_pd    = index::d3(e,q,0,par->Nq,par->Na);
        double EV_next = interp::d1(&(EV_pd[i_pd]), par->grid_a,  a ,par->Na,1,par);

        // Calculate value of choice
        double val     = util::U(C,q,k,t,par) + par->beta*EV_next;

        delete[] g_vec;
        delete[] p_g_vec;

        return val; 

    }

    void construct_EV_pd(double *EV_pd,par_struct *par,size_t t,size_t g,size_t k, double P)
    {
        size_t num_g, k_next; // k_next not used here (the output that relies on q)
        auto g_vec   = new size_t[2];
        auto p_g_vec = new double[2];

        for(size_t e=0; e<par->Ne; e++) {// loop through discrete choices available
            for(size_t q=0; q<par->Nq; q++) {
                if(g<2 && q>0){        continue;}


                        for(size_t i_a=0; i_a<par->Na;i_a++){ // loop through resources
                            double A = par->grid_a[i_a]*P;

                            util::next_period_children(&k_next,g_vec,p_g_vec,&num_g,
                                                                t,g,k,
                                                                e,q,par);

                            //size_t b = k != k_next; // birth of a child
                            // calculate expected value:
                            size_t i_pd = index::d3(e,q,i_a,par->Nq,par->Na);
                            EV_pd[i_pd] = vfi::EV_pd(t,k,g,P,A,k_next,num_g,p_g_vec,par);
                        }

            }
        }

        delete[] g_vec;
        delete[] p_g_vec;
        
    }

} // namespace