#define LARGE_NUMBER 10000000000000000000000000000.0

namespace util {
    double kids_marg(size_t k, size_t t, par_struct *par);
    double kids_add(size_t k, size_t t,par_struct *par);
    double cost_abortion(size_t q,size_t k, size_t t,par_struct *par);

    double U(double C, size_t q, size_t k,size_t t,par_struct *par)
    {
        double marg = kids_marg(k,t,par);
        double add  = kids_add(k,t,par);
        double cost = cost_abortion(q,k,t,par);

        return marg*pow(C,1.0-par->rho)/(1.0-par->rho) 
                + add - cost; 
    }

    double marg_U(double C,  size_t k,size_t t,par_struct *par)
    {
        double marg = kids_marg(k,t,par);
        return marg*pow(C,-par->rho) ; 
    }

    double marg_U_inv(double u, size_t k,size_t t,par_struct *par)
    {
        double marg = kids_marg(k,t,par);
        return pow(u/marg , -1.0/par->rho) ; 
    }


    double cost_perm(size_t k, size_t k_next, size_t g,par_struct *par)
    {
        double cost = 0.0;
        if(k_next==1 && k==(k_next-1)){
            cost = par->cost_perm_1 + ((double) (g>1))*par->cost_perm_1_u;
        } else if(k_next==2 && k==(k_next-1)){
            cost = par->cost_perm_2 + ((double) (g>1))*par->cost_perm_2_u;
        } else if(k_next==3 && k==(k_next-1)){
            cost = par->cost_perm_3 + ((double) (g>1))*par->cost_perm_3_u;
        }
        return 1.0 + cost;
    }

    double cost_trans(size_t k, size_t k_next, size_t g,par_struct *par)
    {
        double cost = 0.0;
        if(k_next==1 && k==(k_next-1)){
            cost = par->cost_trans_1;
        } else if(k_next==2 && k==(k_next-1)){
            cost = par->cost_trans_2;
        } else if(k_next==3 && k==(k_next-1)){
            cost = par->cost_trans_3;
        }
        return 1.0 + cost;

    }


    double prob_pregnant(size_t e,size_t k,size_t t,par_struct *par)
    {
        double prob = 0.0;
        if(k<par->Nk-1 && (t+par->agemin) <= par->max_age_pregnant ){
            if(e==1){
                prob = par->fecundity[t];
            } else {
                prob = par->p_unplanned*par->fecundity[t]; 
            }
        }

        return prob;
    }

    void next_period_children(size_t *k_next, size_t *g_vec, double *p_g_vec, size_t *num_g,
                              size_t t, size_t g, size_t k,
                              size_t e, size_t q, par_struct *par)
    {
        // Birth of a child 
        if(g == 0 || q == 1 ){   
            k_next[0] = k;// Not pregnant or have an abortion -> no change to the number of children
        } else{
            k_next[0] = k + 1;
        }
        if(k_next[0]>par->Nk-1){printf("WARNING: k_next(%d)>Nk(%d)\n",k_next[0],par->Nk );}

        // pregnancy outcome posibilities
        size_t age_next = t+1 + par->agemin;
        if(k_next[0]==par->Nk-1 || (age_next)>par->max_age_pregnant || par->Ng==1){   // Too old to get pregnant in the end of this period or have too many children
            num_g[0] = 1;
            g_vec[0] = 0; 
        } else {
            num_g[0] = 2;
            g_vec[0] = 0;
            g_vec[1] = 1; 
        }
        
        // likelihood of each pregnancy event
        if(num_g[0] > 1){
            p_g_vec[1] = util::prob_pregnant(e,k,t,par);           
            p_g_vec[0] = 1.0 - p_g_vec[1];
        } else {
            p_g_vec[0]    = 1.0;
        }
    }

    void next_period_resources(size_t t,double *m_next,double *P_next, double *Y_next,
                            size_t k, size_t g, double P_alpha,double A,  
                            size_t k_next, double perm, double trans, par_struct *par)
    {
        // income and resources
        double cost_trans = util::cost_trans(k,k_next,g,par); 
        double cost_perm  = util::cost_perm(k,k_next,g,par); 

        P_next[0]     = cost_perm * par->G[t+1] * P_alpha * perm;
        Y_next[0]     = (1.0-par->cost_welfare)*cost_trans* P_next[0]   * trans;
        m_next[0]     = (par->R*A + Y_next[0])/P_next[0];
    }





    // sub-functions
    double kids_marg(size_t k, size_t t, par_struct *par)
    {
        if(t>=par->TR){
            return 1.0;
        }
        return 1.0 + par->marg*( (double) k) ; //exp(par->marg*( (double) k) );
    }

    double kids_add(size_t k, size_t t,par_struct *par)
    {   
        if(t>=par->TR){
            return 0.0;
        }
        // cumulative value of additional children
        double add = 0.0;
        if(k>0){
            add += par->add_1;
        }
        if(k>1){
            add += par->add_2;
        }
        if(k>2){
            add += par->add_3;
        }

        return add; // scale because the parameters are in percent
    }
    double cost_abortion(size_t q,size_t k, size_t t,par_struct *par)
    {
        double cost = 0.0;
        if(q==1){
            cost = par->cost_abort;
        }
        return cost;

    }

} // namespace
