//////////////////////////
// 1. external includes //
//////////////////////////

#include <cmath>
#include <cstdio>
#include <cstdlib>
#include <cstdarg>
#include <string>
#include <omp.h>
#include "mex.h"
#include "matrix.h"


//////////////////////////
// 2. define statements //
//////////////////////////
#define MAX(X,Y) ((X)>(Y)?(X):(Y))
#define MIN(X,Y) ((X)<(Y)?(X):(Y))
#define BOUND(X,A,B) MIN(MAX(X,A),B)
#define THREADS MAXTHREADS


//////////////////////////
// 3. internal includes //
//////////////////////////

// a. generic
#include "HighResTimer_class.hpp" // timer class
//#include "includes\assert.cpp"             // assert() function
#include "logs.cpp"               // log:: functions
//#include "includes\linear_interp.cpp"      // linear_interp:: functions
#include "index.cpp"              // index:: functions
#include "misc.cpp"              // functions to interact with mex

// b. basic
#include "par_struct.cpp"  // define par_struct + setup/destroy functions
#include "sol_struct.cpp"  // define sol_struct + setup/destroy functions
#include "util.cpp"   // transformation and utility functions

// c. solve
#include "interpolate.cpp"     // setup and interpolant gatewys
#include "vfi.cpp"             // solution (VFI)
#include "egm.cpp"             // solution (EGM)
// #include "solve.cpp"             // solution (VFI)

////////////////
// 4. gateway //
////////////////

void mexFunction(int nlhs, mxArray *plhs[],
                 int nrhs, const mxArray *prhs[])
{
     
    //HighResTimer timer_all, timer;
    //timer_all.StartTimer();

        //logs::solve(0,"Solving model.\n"); // reset log file
        

    //////////////////
    // 5. setup par //
    //////////////////
    par_struct* par = new par_struct;
    par::setup(par,plhs,prhs,1);
    
        //logs::solve(1,"Setup completed.\n");

    // Solve retirement problem
    egm::retirement(par);

        //logs::solve(1,"Retirement solved.\n");
    // solve remaining time periods
    if (par->do_egm==1){
        egm::solve(par);
        
    } else {
        // Solve using VFI brute force
        vfi::solve(par);
    }


    /////////////////
    // 7. clean up //
    /////////////////
    
    par::destroy(par,1);
    delete par;

        //double time_all = timer_all.StopTimer();
        //logs::solve(1,"Time: %5.2f secs\n",time_all);
        //logs::solve(1,"Done.\n");

        // clean assertions file
        //FILE* log_file = fopen("log_assert.txt","w");
        //fprintf(log_file,"\n");
        //fclose(log_file);

} // mex gateway