namespace interp {

size_t binary_search(size_t imin, size_t Nx, double *x, double xi)
{
    size_t imid, half;

    // a. checks
    if(xi <= x[0]){
        return 0;
    } else if(xi >= x[Nx-2]) {
        return Nx-2;
    }

    // b. binary search
    while((half = Nx/2)){
        imid = imin + half;
        imin = (x[imid] <= xi) ? imid:imin;
        Nx  -= half;
    }

    return imin;
}

void d1_2out(double *interpC,double *interpV,double *C, double *V, double *M , double Mi, 
                size_t NM,size_t NMi,par_struct *par)
{

    // determine the position left of Mi
    size_t pos_left = binary_search(0, NM, M, Mi);  
    double reldiff  = (Mi - M[pos_left]) / (M[pos_left+1] - M[pos_left]);

    *interpC = C[pos_left] + (C[pos_left+1]-C[pos_left])*reldiff;
    *interpV = V[pos_left] + (V[pos_left+1]-V[pos_left])*reldiff;
}

double d1(double *V, double *M , double Mi, 
                size_t NM,size_t NMi,par_struct *par)
{

    // determine the position left of Mi
    size_t pos_left = binary_search(0, NM, M, Mi);  
    double reldiff  = (Mi - M[pos_left]) / (M[pos_left+1] - M[pos_left]);

    return V[pos_left] + (V[pos_left+1]-V[pos_left])*reldiff;
}

double vfi(double *V, double *P , double *M , double Pi, double Mi, 
                size_t NP,size_t NM,size_t NPi,size_t NMi,par_struct *par)
{
    // left nodes in P
    size_t P_left;
    if(Pi<P[0]){
        P_left = 0;
    } else if (Pi>P[NP-1]){
        P_left = NP-1-1;
    } else {
        P_left = binary_search(0, NP, P, Pi);
    }
    double reldiff_P;
    if(NP>1){
        reldiff_P = (Pi - P[P_left]) / (P[P_left+1] - P[P_left]);
    } else {
        reldiff_P = 0.0;
    }

    // left nodes in M (assumes tensor product grid. If not, then M_left would depend on P_left)
    size_t M_left;
    if(Mi<M[0]){
        M_left = 0;
    } else if (Mi>M[NM-1]){
        M_left = NM-1-1;
    } else {
        M_left = binary_search(0, NM, M, Mi);
    }
    double reldiff_M = (Mi - M[M_left]) / (M[M_left+1] - M[M_left]);

    // interpolate in the M-direction
    size_t i11 = index::d2(P_left,M_left,NM);
    size_t i12 = index::d2(P_left,M_left+1,NM);
    double interp_V1 = V[i11] +  (V[i12]-V[i11])*reldiff_M;
    if(NP>1){
        size_t i21 = index::d2(P_left+1,M_left,NM);
        size_t i22 = index::d2(P_left+1,M_left+1,NM);
        double interp_V2 = V[i21] +  (V[i22]-V[i21])*reldiff_M;
        
        // interpolate in the P direction
        return interp_V1 + (interp_V2-interp_V1)*reldiff_P;

    } else {
        return interp_V1;
    }
    
}


void d2_2out(double *interpV, double *interpC,double *V, double *C,
                 double *P , double *M , double Pi, double Mi, 
                size_t NP,size_t NM, size_t M_left_in, size_t *M_left_out)
{

    // left nodes in P
    size_t P_left;
    if(Pi<P[0]){
        P_left = 0;
    } else if (Pi>P[NP-1]){
        P_left = NP-1-1;
    } else {

        P_left = binary_search(0, NP, P, Pi);
        
    }
    double reldiff_P;
    if(NP>1){
        reldiff_P = (Pi - P[P_left]) / (P[P_left+1] - P[P_left]);
    } else {
        reldiff_P = 0.0;
    }

    // left nodes in M (assumes tensor product grid. If not, then M_left would depend on P_left)
    size_t M_left;
    if(Mi<M[0]){
        M_left = 0;
    } else if (Mi>M[NM-1]){
        M_left = NM-1-1;
    } else {

        if(M_left_in>0){
 
            M_left = M_left_in;
            while(Mi>M[M_left+1] && M_left<NM-2){
                M_left++;
            }

        } else {
            M_left = binary_search(0, NM, M, Mi);
        }
        
        
        
    }
    double reldiff_M = (Mi - M[M_left]) / (M[M_left+1] - M[M_left]);

    // interpolate in the M-direction
    size_t i11 = index::d2(P_left,M_left,NM);
    size_t i12 = index::d2(P_left,M_left+1,NM);
    double interp_V1 = V[i11] +  (V[i12]-V[i11])*reldiff_M;
    double interp_C1 = C[i11] +  (C[i12]-C[i11])*reldiff_M;
    if(NP>1){
        size_t i21 = index::d2(P_left+1,M_left,NM);
        size_t i22 = index::d2(P_left+1,M_left+1,NM);
        double interp_V2 = V[i21] +  (V[i22]-V[i21])*reldiff_M;
        double interp_C2 = C[i21] +  (C[i22]-C[i21])*reldiff_M;
        
        // interpolate in the P direction
        interpV[0] = interp_V1 + (interp_V2-interp_V1)*reldiff_P;
        interpC[0] = interp_C1 + (interp_C2-interp_C1)*reldiff_P;

    } else {
        interpV[0] = interp_V1;
        interpC[0] = interp_C1;
    }

    // output index (potentially)
    if(M_left_out){
        M_left_out[0] = M_left;
    }
    
}

void d2_2out_old(double *interpV, double *interpC,double *V, double *C,
                 double *P , double *M , double Pi, double Mi, 
                size_t NP,size_t NM)
{
    // left nodes in P
    size_t P_left;
    if(Pi<P[0]){
        P_left = 0;
    } else if (Pi>P[NP-1]){
        P_left = NP-1-1;
    } else {
        P_left = binary_search(0, NP, P, Pi);
    }
    double reldiff_P;
    if(NP>1){
        reldiff_P = (Pi - P[P_left]) / (P[P_left+1] - P[P_left]);
    } else {
        reldiff_P = 0.0;
    }

    // left nodes in M (assumes tensor product grid. If not, then M_left would depend on P_left)
    size_t M_left;
    if(Mi<M[0]){
        M_left = 0;
    } else if (Mi>M[NM-1]){
        M_left = NM-1-1;
    } else {
        M_left = binary_search(0, NM, M, Mi);
    }
    double reldiff_M = (Mi - M[M_left]) / (M[M_left+1] - M[M_left]);

    // interpolate in the M-direction
    size_t i11 = index::d2(P_left,M_left,NM);
    size_t i12 = index::d2(P_left,M_left+1,NM);
    double interp_V1 = V[i11] +  (V[i12]-V[i11])*reldiff_M;
    double interp_C1 = C[i11] +  (C[i12]-C[i11])*reldiff_M;
    if(NP>1){
        size_t i21 = index::d2(P_left+1,M_left,NM);
        size_t i22 = index::d2(P_left+1,M_left+1,NM);
        double interp_V2 = V[i21] +  (V[i22]-V[i21])*reldiff_M;
        double interp_C2 = C[i21] +  (C[i22]-C[i21])*reldiff_M;
        
        // interpolate in the P direction
        interpV[0] = interp_V1 + (interp_V2-interp_V1)*reldiff_P;
        interpC[0] = interp_C1 + (interp_C2-interp_C1)*reldiff_P;

    } else {
        interpV[0] = interp_V1;
        interpC[0] = interp_C1;
    }
    
}


} // namespace