

namespace egm {
    void retirement(par_struct *par)
    {

        #pragma omp parallel num_threads(THREADS)
        {

        // allocate 
        size_t dim = par->Na_ret;
        auto C      = new double[dim];
        auto m      = new double[dim];
        auto V      = new double[dim];
        auto C_next = new double[dim];
        auto m_next = new double[dim];
        auto V_next = new double[dim];

        size_t q = 0; // no abortions
      
        // loop over time-invariant states
        #pragma omp for collapse(2)
        for(size_t k=0; k<par->Nk ; k++){
            for(size_t i_P=0; i_P<par->Np ; i_P++){
                double P = par->grid_P[i_P];

                double EV_no_save=0.0;
                for(size_t t=par->T-2; t>=par->TR ; t--){
                    // update next-period solution
                    if(t== (par->T-2) ){// Consume everything in the last period

                        for(size_t i_a=0; i_a<dim ; i_a++){
                            m_next[i_a] = par->grid_a_ret[i_a];
                            C_next[i_a] = m_next[i_a]*P;
                            V_next[i_a] = util::U(C_next[i_a],q,k,t,par);
                        }
                    } else { // swap pointers such that _next refers to the solution just found
                        for(size_t i_a=0; i_a<dim ; i_a++){
                            m_next[i_a] = m[i_a];
                            C_next[i_a] = C[i_a];
                            V_next[i_a] = V[i_a];
                        }
                    }

                    for(size_t i_a=0; i_a<dim ; i_a++){

                        double A      = par->grid_a_ret[i_a]*P;
                        double m_plus = (par->R*A + par->kappa*P)/P;

                        // interpolate next period solution
                        double interp_C_next,interp_V_next;
                        if(m_plus < m_next[0]){ // below constraint
                            interp_C_next = m_plus*P;
                            interp_V_next = util::U(interp_C_next,q,k,t,par) + par->beta*EV_no_save;
                        } else {

                            // interp::d1_2out(&interp_C_next,&interp_V_next,C_next,V_next,m_next,m_plus,par->Nm,1,par);

                            interp::d1_2out(&interp_C_next,&interp_V_next,C_next,V_next,m_next,m_plus,par->Na_ret,1,par);
                        }

                        // EGM gives consumption and value function in closed form
                        double marg_U = util::marg_U(interp_C_next , k, t , par);

                        C[i_a] = util::marg_U_inv( par->R*par->beta * marg_U , k, t, par  )  ;
                        m[i_a] = (C[i_a] + A)/P;
                        V[i_a] = util::U(C[i_a],q,k,t,par) + par->beta*interp_V_next;

                        if(i_a==0){
                            EV_no_save = interp_V_next;
                        }
                    }
                    
                }

                // store the current retirement solution in the sol-struct on common grid
                size_t t = par->TR;
                for(size_t i_m=0; i_m<par->Nm ; i_m++){

                    double m_now = par->grid_m[i_m] ;// TODO:+ par->credit; // not allowed to borrow (now they are!)
                    
                    double interp_C,interp_V;
                    if(m_now<m[0]){
                        interp_C = (m_now + par->credit)*P; // TODO: added credit here such that they can borrow here too
                        interp_V = util::U(interp_C,q,k,t,par) + par->beta*EV_no_save;
                    } else {
                        interp::d1_2out(&interp_C,&interp_V,C,V,m,m_now,dim,1,par); 
                    }

                    size_t i = index::d3(k,i_P,i_m,par->Np,par->Nm);
                    #pragma omp critical
                    {
                    par->C[t][i] = interp_C;
                    par->m[t][i] = m_now;
                    par->V[t][i] = interp_V;
                    } // critical
                }
            }
        }
        
        // free memory
        delete[] C;
        delete[] m;
        delete[] V;
        delete[] C_next;
        delete[] m_next;
        delete[] V_next;

        } // pragma
    } // retirement function

    void EV_pd_vec(double *EV, double *EmargU,
                size_t t,size_t k,size_t g, double P,
                size_t k_next, size_t num_g,double *p_g_vec,
                par_struct *par)
    {
        
        double P_next, Y_next, m_next;
        double interp_V_next, interp_C_next;
        double P_alpha = P;
        if(par->alpha<1){
            P_alpha = pow(P , par->alpha);
        }

        // index pointer
        size_t M_left_out = 0;
        size_t M_left_in  = 0;

        // Income shocks (depend on retirement)
        size_t Nshocks  = par->Nshocks*par->Nshocks;
        double perm     = 1.0;
        double trans    = 1.0;
        double p_Y_next = 1.0;
        double ret_adj  = 1.0;
        double credit_adj = 0.0; // adjustment of the end-of-period wealth grid
        if(t==(par->TR-1)){ // retirement next period-> no uncertainty
            Nshocks     = 1;
            ret_adj     = par->gamma;
           // TODO // credit_adj  = par->credit; // if retired next period, you are not allowed to carry on any debt -> adjust the grid
        }

        // initialize containers to store the expected values for each level of end-of-period wealth
        auto check_prob = new double[par->Na];
        for (size_t i_a = 0; i_a < par->Na; i_a++){ 
            EmargU[i_a]       = 0.0;
            EV[i_a]           = 0.0;
            check_prob[i_a]   = 0.0;
        }

        // loop through shocks
        for(size_t g_next=0; g_next<num_g;g_next++){    
        for(size_t i_shock=0; i_shock<Nshocks ; i_shock++){

            if(t<par->TR-1){
                perm     = par->perm[i_shock];
                trans    = par->trans[i_shock];
                p_Y_next = par->weight[i_shock];
            }

            // likelihood of current combination
            double w         = p_g_vec[g_next]*p_Y_next;

            M_left_in = 0; // reset the index every time 
            for(size_t i_a=0; i_a<par->Na;i_a++){ // loop through resources
                double A = (par->grid_a[i_a] + credit_adj)*P;

                // Next-period income
                util::next_period_resources(t,&m_next,&P_next,&Y_next,
                                k,g,P_alpha,A,  
                                k_next,perm,trans,par);

                    // interpolate next-period value function 
                    size_t i_next        = index::d4(g_next,k_next,0,0,par->Nk,par->Np,par->Nm); 
                    m_next = m_next - credit_adj; // adjust the next-period level of resources if the next period is retirement. This is rather than adjusting the grid itself
                    
                    interp::d2_2out(&interp_V_next,&interp_C_next,&(par->V[t+1][i_next]),&(par->C[t+1][i_next]),
                                    par->grid_P,par->grid_m, P_next, m_next,par->Np,par->Nm,
                                    M_left_in, &M_left_out);

                    // update the index:
                    M_left_in = M_left_out;

                    // update expectations and check-sum
                    EmargU[i_a]     += ret_adj*w*util::marg_U(interp_C_next,k_next,t+1,par);
                    EV[i_a]         += ret_adj*w*interp_V_next; 
                    check_prob[i_a] += w;

                } // asset
            } // shocks
        } // pregnancy

        // output and check
        for(size_t i_a=0; i_a<par->Na;i_a++){ // loop through resources
            if(check_prob[i_a]<0.999 || check_prob[i_a]>1.000001){ printf("WARNING: check_prob[%d]=%g\n",i_a,check_prob[i_a]); }
        }

        // delete memory
        delete[] check_prob;
    }

void upper_envelope(double *m,double *C,double *V,double *Mraw,double *Craw,double *Vraw,size_t do_upper,double *EVraw,
                       double Mraw_min,double P, size_t q,size_t k,size_t t,par_struct *par);
    void inv_euler(double *C, double *V,double *m,
                    size_t e, size_t q,par_struct *par, size_t t,size_t g, size_t k, size_t i_P)
    {
        double P = par->grid_P[i_P];
        // storage for raw solution
        auto Vraw = new double[par->Na];
        auto Craw = new double[par->Na];
        auto Mraw = new double[par->Na];

        // next period states: allocation
        size_t num_g, k_next; 
        auto g_vec   = new size_t[2];
        auto p_g_vec = new double[2];
        util::next_period_children(&k_next,g_vec,p_g_vec,&num_g,
                                    t,g,k,
                                    e,q,par);

        // Calculate expected value for each element in a. Loop through shocks first to utilize the memory allocation in the a-direction
        auto EmargU_vec      = new double[par->Na];
        auto EV_vec          = new double[par->Na];
        egm::EV_pd_vec(EV_vec,EmargU_vec,t,k,g,P,k_next,num_g,p_g_vec,par);

        double credit_adj = 0.0; // TODO
        // if(t==par->TR-1){
            // credit_adj = par->credit;
        // }
        size_t do_upper = 0;
        double minM     = LARGE_NUMBER;
        for(size_t i_a=0; i_a<par->Na;i_a++){ // loop through resources
            double A = (par->grid_a[i_a] + credit_adj)*P; // adjust grid if in last period

            // optimal consumption: invert the Euler equation
            Craw[i_a] = util::marg_U_inv(par->R*par->beta*EmargU_vec[i_a] ,k,t,par);

            // value of optimal consumption
            Vraw[i_a] = util::U(Craw[i_a],q,k,t,par) + par->beta*EV_vec[i_a];

            // endogeneous level of resources
            Mraw[i_a] = Craw[i_a] + A;

            // variables to be used in relation to upper envelope
            if(i_a>0 && (Mraw[i_a-1]>Mraw[i_a] || Vraw[i_a-1]>Vraw[i_a])){
                do_upper = 1; // determine if the upper envelope is needed at all. If not save time
            }
            if(Mraw[i_a]<minM){ // this is to ensure that the upper envelope is taking the constrinat into account properly
                minM = Mraw[i_a];
            }

        } // resources

        // call upper envelope
        egm::upper_envelope(m,C,V,Mraw,Craw,Vraw,do_upper,EV_vec,
                            minM,P,q,k,t,par);

        // delete memory allocated
        delete[] g_vec;
        delete[] p_g_vec;
        delete[] Vraw;
        delete[] Craw;
        delete[] Mraw;
        delete[] EmargU_vec;
        delete[] EV_vec;


        return; 

    }

    void solve(par_struct *par)
    {

        #pragma omp parallel num_threads(THREADS)
        {

        // a. setup
        //auto sol = new sol_struct;
        //sol::setup(par,sol);
        
        auto Cd_opt = new double[par->Nm]; 
        auto md     = new double[par->Nm];  
        auto V_opt  = new double[par->Nm]; 

        for(size_t t=par->TR ; t--> 0 ;){

            #pragma omp for collapse(3)
            for(size_t i_P=0 ; i_P<par->Np ; i_P++){ 
            for(size_t g=0 ; g<par->Ng ; g++){
            for(size_t k=0 ; k<par->Nk ; k++){

                // restrict attention to situations which are relevant TODO: move this perhaps into a function that determines num_g_now
                if(k==par->Nk-1 && g>0){             continue; } // have maximum amount of children so cannot be pregnant
                if(t+par->agemin>par->max_age_pregnant && g>0 ){ continue; }

                    // find optimal choice
                    for(size_t i_m=0;i_m<par->Nm;i_m++){
                        V_opt[i_m] = -LARGE_NUMBER;  // initialize
                    }                    

                    for(size_t e=0; e<par->Ne; e++) {// loop through discrete choices available
                    for(size_t q=0; q<par->Nq; q++) {
                        if(g<2 && q>0){        continue;} // not pregnant or intended pregnancy so cannot have an abortion [TODO: asign perhaps a very large negative number]
                        if(k==(par->Nk-1) && e>0){continue;} // have maximum number of children so cannot get pregnant. Since there is no effort, cost households would be indifferent between trying and not

                        // EGM returns choice-specific values for a vector of a-levels
                        size_t d  = index::discrete(e,q,par->Nq);
                        size_t id = index::d5(d,g,k,i_P,0,par->Ng,par->Nk,par->Np,par->Nm);
                        
                        egm::inv_euler(Cd_opt,&(par->Vd[t][id]),md,
                                        e,q,par,t,g,k,i_P);
                            
                            for(size_t i_m=0;i_m<par->Nm;i_m++){

                                // update maximum over discrete choices
                                if(par->Vd[t][id+i_m]>V_opt[i_m]){
                                    V_opt[i_m] = par->Vd[t][id+i_m];

                                    size_t i = index::d4(g,k,i_P,i_m,par->Nk,par->Np,par->Nm);
                                    #pragma omp critical
                                    {
                                    par->V[t][i]  = V_opt[i_m]; // this could be done below
                                    par->C[t][i]  = Cd_opt[i_m];
                                    par->m[t][i]  = md[i_m]; // TODO: not really needed in the end

                                    //par->e[t][i]  = (double) e; // TODO: not really needed in the end
                                    //par->q[t][i]  = (double) q; // TODO: not really needed in the end
                                    } // critical
                                }
                            }
                    
                    } // abortion   
                    } // effort

            }
            }
            }
        }

        // destroy
        delete[] Cd_opt;
        delete[] md;
        delete[] V_opt;

        //sol::destroy(sol);
        //delete sol;

        } // pragma

    } // egm solve function




    void upper_envelope(double *m,double *C,double *V,double *Mraw,double *Craw,double *Vraw,size_t do_upper,double *EVraw,
                       double Mraw_min,double P, size_t q,size_t k,size_t t,par_struct *par)
    {

        double credit_adj = 0.0;
        // if(t==par->TR-1){
            credit_adj = par->credit*P;
        // }
         if(do_upper==0){

            for(size_t i_m=0; i_m<par->Nm;i_m++){ // loop through resources
                double m_now = par->grid_m[i_m];
                double M_now = m_now*P;

                m[i_m] = m_now;
                if (M_now<Mraw_min){ // on the constraint
                    C[i_m] = M_now + credit_adj;
                    V[i_m] = util::U(C[i_m],q,k,t,par) + par->beta*EVraw[0];
                } else {
                    interp::d1_2out(&(C[i_m]),&(V[i_m]),Craw, Vraw, Mraw , M_now,par->Na,1,par); 
                }

            }
            
        }  else {

            // 1. initialize value on common grid m
            for(size_t i_m=0;i_m<par->Nm;i_m++){
                V[i_m] = -mxGetInf(); 
                m[i_m] = par->grid_m[i_m];

                // insert constrained region
                double M_now = par->grid_m[i_m]*P;
                if(M_now<Mraw_min){ // on the constraint
                    C[i_m] = M_now + credit_adj;
                    V[i_m] = util::U(C[i_m],q,k,t,par) + par->beta*EVraw[0];
                }
            }

            for(size_t i_a=0;i_a<(par->Na - 1);i_a++){ // loop through found points
                // 2. current m interval and slope in endogenous grid
                double M_low      = Mraw[i_a];
                double M_high     = Mraw[i_a+1];
                double inv_diff_m = 1.0/(M_high-M_low); 

                // b. loop through common grid m
                for(size_t i_m=0; i_m<par->Nm;i_m++){
                    double M_now = par->grid_m[i_m]*P;
                    
                    if(M_now<Mraw_min){ 
                        continue; // on the constraint -> this part has been inserted above
                    }

                    if( (M_now >= M_low) & (M_now <= M_high) ){ // if common grid points are in the interval

                            // i. consumption
                            double c_guess = Craw[i_a] + (Craw[i_a+1]-Craw[i_a])*(M_now - M_low)*inv_diff_m;
                            
                            // ii. value (interpolate this too)
                            double Ev_guess = EVraw[i_a] + (EVraw[i_a+1]-EVraw[i_a])*(M_now - M_low)*inv_diff_m;
                            double v_guess  = util::U(c_guess,q,k,t,par) + par->beta*Ev_guess;
                            //double v_guess = Vraw[i_a] + (Vraw[i_a+1]-Vraw[i_a])*(M_now - M_low)*inv_diff_m;
                            
                            // iii. update
                            if(v_guess>V[i_m]){
                                V[i_m] = v_guess;
                                C[i_m] = c_guess;
                            }
                            
                    } // if constraint or in relevant interval
                    
                } // i_m

            }
        }        
        
    } // upper envelope





} // namespace