****************************************
* Output data to be used in Matlab *
************************************************************
clear all


global probUnPlannedL=0.10
global probUnPlannedH=0.04

set seed 119

use ${output_data}\BHPSpanelAdjustedHouseholds, replace
sort hid wave
xtset hid wave 

keep if age<40 & age>19

g newborn 			= noBaby>0
g NumKids 			= NnChildren
g wave_out		    = wave

* Set the variables to be stored
global MatlabData 		age Wealth SavingRate NumKids Income newborn ExpChildUpdate Unplanned wave_out /*Variables that should be stored for all available observations: Used for comparing moments*/
format hid %12.0f

replace NumKids = 3 if NumKids>3 /*cap the number of children to the maximum*/
/* Check moments */

gen lExpChildUpdate=l.ExpChildUpdate
gen lExpChild=l.ExpChild
gen agesq=age^2

gen factor=(NumKids==1)+1.3*(NumKids==2)+3.1*(NumKids==3)
sort hid wave

gen lUnExpChildUpdate=1-lExpChildUpdate

gen d2saving=SavingRate-l2.SavingRate
gen Planned=0 if newborn==0
replace Planned         = l.ExpChild if newborn>0 &  !missing(newborn) & !missing(l.ExpChild)
gen Unplanned=0 if newborn==0
replace Unplanned         = 1-l.ExpChild  if newborn>0 &  !missing(newborn) & !missing(l.ExpChild) 

gen u=.
gen dd=.
gen Xunplan=.
gen Xplan=.
 
program sim_reg, rclass
 replace u=runiform()
 replace dd=(u>$probUnPlannedL*factor) if Highskilled==0
 replace dd=(u>$probUnPlannedH*factor) if Highskilled==1
 replace Xplan=.  
 replace Xplan         = Planned
 replace Xplan         = dd  if newborn>0 & Xplan==. & !missing(newborn) 
 replace Xunplan=.
 replace Xunplan        = Unplanned
 replace Xunplan       = 1-dd  if newborn>0 & Xunplan==. & !missing(newborn) 
reg d2saving Xplan Xunplan  age agesq i.wave if  Highskilled==0 & age>24 
return scalar alpha1=_b[Xplan]
return scalar alpha2=_b[Xunplan]
reg Xunplan if newborn>0 &  NumKids==1 & Highskilled==0 & age>24 
return scalar alpha3a=_b[_cons]
reg Xunplan if newborn>0 &  NumKids==2 & Highskilled==0 & age>24 
return scalar alpha3b=_b[_cons]
reg Xunplan if newborn>0 &  NumKids>2 & Highskilled==0 & age>24 
return scalar alpha3c=_b[_cons]

reg d2saving Xplan Xunplan  age agesq i.wave if  Highskilled==1 & age>24 
return scalar alpha4=_b[Xplan]
return scalar alpha5=_b[Xunplan]
reg Xunplan if newborn>0 & NumKids==1 & Highskilled==1 & age>24 
return scalar alpha6a=_b[_cons] 
reg Xunplan if newborn>0 & NumKids==2 & Highskilled==1 & age>24 
return scalar alpha6b=_b[_cons] 
reg Xunplan if newborn>0 & NumKids>2 & Highskilled==1 & age>24 
return scalar alpha6c=_b[_cons] 

end



simulate alpha1=r(alpha1) alpha2=r(alpha2) alpha3a=r(alpha3a) alpha3b=r(alpha3b) alpha3c=r(alpha3c) ///
         alpha4=r(alpha4) alpha5=r(alpha5) alpha6a=r(alpha6a) alpha6b=r(alpha6b) alpha6c=r(alpha6c), ///
		 seed(119) reps(1000) : sim_reg

eststo RandImp: qui estpost sum 
collapse (sd) alpha*
eststo RandSE: qui estpost sum

drop alpha*


use ${output_data}\BHPSpanelAdjustedHouseholds, replace
sort hid wave
xtset hid wave 

keep if age<40 & age>19

g newborn 			= noBaby>0
g NumKids 			= NnChildren
g Unplanned 		= newborn>0 & l.ExpChildUpdate==0 & !missing(newborn) & !missing(l.ExpChildUpdate)
g Planned           = newborn>0 & l.ExpChildUpdate==1 & !missing(newborn) & !missing(l.ExpChildUpdate)
g wave_out		    = wave

* Set the variables to be stored
global MatlabData 		age Wealth SavingRate NumKids Income newborn ExpChildUpdate Unplanned wave_out /*Variables that should be stored for all available observations: Used for comparing moments*/
format hid %12.0f

replace NumKids = 3 if NumKids>3 /*cap the number of children to the maximum*/
/* Check moments */

gen lExpChildUpdate=l.ExpChildUpdate
gen lExpChild=l.ExpChild
gen agesq=age^2

sort hid wave

gen lUnExpChildUpdate=1-lExpChildUpdate

gen d2saving=SavingRate-l2.SavingRate



forvalue i=1/3{

replace Unplanned       = 0 if newborn==0 & `i'==2
replace Unplanned 		= newborn>0 & l.ExpChild==0 & !missing(newborn) & !missing(l.ExpChild) if `i'==2
*replace Unplanned 		= .  if missing(l.ExpChild) & newborn>0 & `i'==2



replace Planned         = 0 if newborn==0 & `i'==2
replace Planned         =newborn>0 & l.ExpChild==1 & !missing(newborn) & !missing(l.ExpChild) if `i'==2
*replace Planned 		= .  if missing(l.ExpChild) & newborn>0 & `i'==2
display `i'
/* Chech moments */
gen UnKnown=0
replace UnKnown=1 if newborn>0 & Planned==0 & Unplanned==0
replace Planned=1 if UnKnown==1 & `i'==3 
replace UnKnown=0 if `i'==3

quiet reg d2saving Planned Unplanned UnKnown age agesq i.wave if  Highskilled==0 & age>24 
gen alpha1=_b[Planned]
gen alpha2=_b[Unplanned]
gen se1=_se[Planned]
gen se2=_se[Unplanned]
gen dd=0
replace dd=1 if !missing(lExpChildUpdate) & `i'==1
replace dd=1 if !missing(lExpChild) & `i'==2
replace dd=1 if `i'==3 
display `i'
quiet reg Unplanned if newborn==1 & NumKids==1& Highskilled==0 & age>24 & dd==1
gen alpha3a=_b[_cons]
gen se3a=_se[_cons]
quiet reg Unplanned if newborn==1 & NumKids==2& Highskilled==0 & age>24 & dd==1
gen alpha3b=_b[_cons]
gen se3b=_se[_cons]
quiet reg Unplanned if newborn==1 & NumKids>2& Highskilled==0 & age>24 & dd==1
gen alpha3c=_b[_cons]
gen se3c=_se[_cons]
drop dd

quiet reg d2saving Planned Unplanned UnKnown age agesq i.wave if  Highskilled==1 & age>24 
gen alpha4=_b[Planned]
gen alpha5=_b[Unplanned]
gen se4=_se[Planned]
gen se5=_se[Unplanned]
gen dd=0 
replace dd=1 if !missing(lExpChildUpdate) & `i'==1
replace dd=1 if !missing(lExpChild) & `i'==2 
replace dd=1 if `i==3'
quiet reg Unplanned if newborn==1 & NumKids==1& Highskilled==1 & age>24 & dd==1 
gen alpha6a=_b[_cons]
gen se6a=_se[_cons]
quiet reg Unplanned if newborn==1 & NumKids==2& Highskilled==1 & age>24 & dd==1
gen alpha6b=_b[_cons]
gen se6b=_se[_cons]
quiet reg Unplanned if newborn==1 & NumKids>2& Highskilled==1 & age>24 & dd==1
gen alpha6c=_b[_cons]
gen se6c=_se[_cons]
eststo Model`i': qui estpost sum alpha* 
drop alpha*
rename se1 alpha1
rename se2 alpha2
rename se4 alpha4 
rename se5 alpha5

foreach s in a b c {
rename se3`s' alpha3`s'
rename se6`s' alpha6`s'
}
eststo SE`i': qui estpost sum alpha* 

drop UnKnown dd
drop alpha*

}

estout Model1 SE1 Model2 SE2 Model3 SE3 RandImp RandSE using ${output_fig}\moment.tex, replace style(tex) cells("mean(fmt(3))  ")   ///
	varlabels(alpha1 "Wanted" alpha2 "Unwanted" alpha3a "1.child" alpha3b "2.child" alpha3c "3.child"  ///
	 alpha4 "Wanted" alpha5 "Unwanted" alpha6a "1.child" alpha6b "2.child" alpha6c "3.child")  ///
	mlabels("Paper" "Paper SE" "No imput." "No imp. SE" "All wanted" "All wanted SE" "Rand. Imput." "Rand. Imp. SE") collabel("mean" "SE" "mean" "SE" "mean" "SE")
