****************************************
* Output data to be used in Matlab *
************************************************************
clear all

use ${output_data}\BHPSpanelAdjustedHouseholds, replace
sort hid wave
xtset hid wave 

keep if age<40 & age>19

g newborn 			= noBaby>0
g NumKids 			= NnChildren
g Unplanned 		= newborn>0 & l.ExpChildUpdate==0 & !missing(newborn) & !missing(l.ExpChildUpdate)
g wave_out		    = wave

* Set the variables to be stored
global MatlabData 		age Wealth SavingRate NumKids Income newborn ExpChildUpdate Unplanned wave_out /*Variables that should be stored for all available observations: Used for comparing moments*/
format hid %12.0f

/*xtsum Income if EstSample==1
xtsum Income if EstSample==1 & Highskilled==1
xtsum Income if EstSample==1 & Highskilled==0

keep if !missing(Income) & EstSample==1 & !missing(EstSample)*/

* replace missings with -2 such that they are stored in the txt files
replace ExpChildUpdate = -2 if missing(ExpChildUpdate)

sort hid wave

format Wealth Income %12.5f

******************************************************
* Save matlab .txt data files
******************************************************
quietly {
	set more off
	forvalues educ = 0/1 {
		* Prepare data: Replace missing with -2 such that importation of data in Matlab works 
		foreach var in $MatlabData {
			preserve
			keep if Highskilled == `educ' 
			keep hid wave `var'
			reshape wide `var', i(hid) j(wave)

			outfile `var'* using "${output_matlab}\\`var'_`educ'.txt", comma wide replace 
			
			restore
		}
		
		* Variables only stored for the fist observation
		preserve
		keep if Highskilled == `educ' 
		drop if missing(Initial24) /* Keep only first nonmissing observation*/

		keep hid wave Wealth NumKids Income age
		replace NumKids = 3 if NumKids>3 /*cap the number of children to the maximum*/
		
		foreach var in Wealth NumKids Income age{
			outfile `var' using "${output_matlab}\\init`var'_`educ'.txt", comma wide replace 
		}
		
		restore
	} 
}

