 *This do file generates the moments used for estimation
clear all
set scheme s1mono

use ${output_data}\BHPSpanelAdjustedHouseholds
cap log close

xtset hid wave

keep if age<40 & age>19

/* check sample size */

/* Numbers to the table - Sample selection */
xtsum NnChildren if Highskilled==1
xtsum NnChildren if Highskilled==0

/* check newborns */
/* number of births  - numbers in text */
gen Birth=(noBaby>0) if !missing(noBaby) 
tab Birth Highskilled



/* define lables and groups*/

gen lExpChildUpdate=l.ExpChildUpdate

gen ageG = floor(age/5)-3
label var ageG "Age groups "
label define  lageg  1 "20-24" 2 "25-29" 3 "30-34" 4 "35-39"
label value ageG lageg

gen NChildG = NnChildren
replace NChildG=3 if NnChildren>3 & !missing(NnChildren)
label var NChildG "Number of Children"
label define  lNChildg  0 "0 children" 1 "One child" 2  "Two children" 3 "More than two children" 
label value NChildG lNChildg

gen Parity = NChildG
label define  lparity  0 "Mis clasified" 1 "Parity 1" 2  "Parity 2" 3 "Parity 3+" 
label value Parity lparity


sort hid wave



/******************************************************************************/
/*                 AP's                                                       */
/******************************************************************************/


/* Shares with children */
tab NChildG ageG if Highskilled==0, col
tab NChildG ageG if Highskilled==1, col

*keep if age>24

/* Unintended births  */
tab lExpChildUpdate Parity if Highskilled==0 & Birth==1 , col 
tab lExpChildUpdate Parity if Highskilled==1 & Birth==1 , col 

/* number of children 5 years ahead condition on expectations */
gen dNnChildren5=(f4.NnChildren-l.NnChildren)
bys Highskilled lExpChildUpdate: tab dNnChildren5

 
sort hid wave


/* characteristics of households with */
gen lIncome=l.Income
gen l2Income=l2.Income
gen lWealth=l.Wealth
gen dIncome=Income-l.Income
gen dWorkHours1=WorkHours1-l.WorkHours1
gen dWorkHours2=WorkHours2-l.WorkHours2
gen lBirth=l.Birth
gen lNChildG=l.NChildG


label value lNChildG lNChildg

/* changes around birth */

gen UnExpTemp=Birth*(1-lExpChildUpdate)
bysort hid: gen UnExpBirth=sum(UnExpTemp)
gen lnIncome=ln(Income)  
gen dlnIncome=d.lnIncome
tab NChildG, gen(DD)
gen dNChildG1=d.DD2
gen dNChildG2=d.DD3
gen dNChildG3=d.DD4

gen dNChildA1=d.DD2+d.DD3+d.DD4
gen dNChildA2=d.DD3+d.DD4
gen dNChildA3=d.DD4


gen dNChildG=Birth*NChildG
gen dUnExpBirth=d.UnExpBirth
gen dBirth=d.Birth
gen dSavingRate=d.SavingRate

gen dNChild=d.NChildG


reg dSavingRate i.age dNChildA1-dNChildA3 dUnExpBirth dBirth i.wave if Highskilled==0 & !missing(lExpChildUpdate)
eststo SavFlow
reg dSavingRate i.age dNChild dUnExpBirth dBirth i.wave if Highskilled==0 & !missing(lExpChildUpdate)
eststo SavSlow
reg dSavingRate i.age dNChildA1-dNChildA3 dUnExpBirth dBirth i.wave if Highskilled==1 & !missing(lExpChildUpdate)
eststo SavFhigh
reg dSavingRate i.age dNChild dUnExpBirth dBirth i.wave if Highskilled==1 & !missing(lExpChildUpdate)
eststo SavShigh


/* Table - Saving around births  - Data supplement*/
estout SavFlow SavFhigh SavSlow SavShigh using $output_fig\TabSavFD.tex ,  cells("b(fmt(3) star)" "se(par fmt(3))"  ) ////
   label collabels(none) mlabels(, none )  varlabel(_cons "Constant" dNChildA1 "First Child" dNChildA2 "Second Child" dNChildA3 "Third Child" dNChild "Add. Child" dUnExpBirth "Unexpected Birth" dBirth "Wave with Birth") stats(N r2, fmt(0 3) labels("\hline Obs" "$ R^2 $")) indicate("Age dummies=*age*" "Wave dummies=*wave*") style(tex) replace

   
/************************************************************************************************************************************************************/
/*                                 INCOME                                                                                                                   */
/************************************************************************************************************************************************************/


reg dlnIncome i.age dNChildA1-dNChildA3 dUnExpBirth dBirth i.wave if Highskilled==0 , robust
eststo dIncLow

reg dWorkHours1 i.age dNChildA1-dNChildA3 dUnExpBirth dBirth i.wave if Highskilled==0 , robust
eststo dWH1Low
reg dWorkHours2 i.age dNChildA1-dNChildA3 dUnExpBirth dBirth i.wave if Highskilled==0 , robust
eststo dWH2Low
reg dlnIncome i.age dNChildA1-dNChildA3 dUnExpBirth dBirth i.wave if Highskilled==1 , robust
eststo dIncHigh
reg dWorkHours1 i.age dNChildA1-dNChildA3 dUnExpBirth dBirth i.wave if Highskilled==1 , robust
eststo dWH1High
reg dWorkHours2 i.age dNChildA1-dNChildA3 dUnExpBirth dBirth i.wave if Highskilled==1 , robust
eststo dWH2High

/* Table: Income and working Hours around Birth FD - Data supplement   */
estout dIncLow dIncHigh dWH1Low dWH1High dWH2Low dWH2High using $output_fig\TabRegAroundFD.tex ,  cells("b(fmt(3) star)" "se(par fmt(3))"  ) ////
   label collabels(none) mlabels(, none )   varlabel(_cons "Constant" dNChildA1 "First Child" dNChildA2 "Second Child" dNChildA3 "Third Child" dUnExpBirth "Unexpected Birth" dBirth "Wave with Birth") stats(N r2, fmt(0 3) labels("\hline Obs" "$ R^2 $")) indicate("Age dummies=*age*" "Wave dummies=*wave*") style(tex) replace

   
/*      Income and     working hours */

/*
label value NChildG lNChildg

xtreg lnIncome i.age i.NChildG UnExpBirth Birth i.wave if  Highskilled==0 & !missing(lExpChildUpdate), fe 
eststo IncLow

xtreg WorkHours1 i.age i.NChildG UnExpBirth  Birth i.wave if  Highskilled==0 & !missing(lExpChildUpdate),fe 
eststo WH1Low
xtreg WorkHours2 i.age i.NChildG UnExpBirth  Birth i.wave if  Highskilled==0 & !missing(lExpChildUpdate),fe 
eststo WH2Low

xtreg lnIncome i.age i.NChildG UnExpBirth Birth i.wave if  Highskilled==1 & !missing(lExpChildUpdate),fe 
eststo IncHigh
xtreg WorkHours1 i.age i.NChildG UnExpBirth  Birth i.wave if  Highskilled==1 & !missing(lExpChildUpdate),fe 
eststo WH1High
xtreg WorkHours2 i.age i.NChildG UnExpBirth  Birth i.wave if  Highskilled==1 & !missing(lExpChildUpdate),fe 
eststo WH2High

/* Table - Income and Working Hours around birth - FE  Data supplement*/
estout IncLow IncHigh WH1Low WH1High WH2Low WH2High using $graphout\TabRegAround.tex ,  cells("b(fmt(3) star)" "se(par fmt(3))"  ) ////
   label collabels(none) mlabels(, none ) drop(0.NChildG)  varlabel(_cons "Constant" 1.NChildG "1 child" 2.NChildG "2 children"  3.NChildG ">2 children" UnExpBirth "Unwanted Birth" Birth "Wave with Birth") stats(N r2, fmt(0 3) labels("\hline Obs" "$ R^2 $")) indicate("Age dummies=*age*" "Wave dummies=*wave*") style(tex) replace
*/
   
/************************************************************************************************************************************************************************/
/*                    Tables on expectations                                                                                                                            */
/************************************************************************************************************************************************************************/

   
/* extra tables on expectations */
   
replace lIncome=lIncome/1000
replace lWealth=lWealth/1000

reg ExpChildUpdate i.age  i.lNChildG lIncome  i.wave if Highskilled==0, robust 
eststo ExpL
reg ExpChildUpdate i.age  i.lNChildG lIncome  i.wave if Highskilled==1, robust 
eststo ExpH

/* Fertility Intentions - data Supplement */ 
estout ExpL ExpH using $output_fig\regExp.tex , cells("b(fmt(3) star)" "se(par fmt(3))"  ) ////
   label collabels(none) mlabels(, none ) drop(0.lNChildG)  varlabel(_cons "Constant" 1.lNChildG "1 child" 2.lNChildG "2 children"  3.lNChildG ">2 children" lIncome "Income (lagged)" ) stats(N r2, fmt(0 3) labels("\hline Obs" "$ R^2 $")) indicate("Age=*age*" "Wave dummies=*wave*") style(tex) replace

/* check same sex instruments */
/* Generate numbers to footnote */

gen Samesex=0 if inlist(wave, 2, 9, 11) &  NnChildren==2 & NoGirls==1

replace Samesex=1 if inlist(wave, 2, 9, 11) & NnChildren==2 & NoGirls==2 

replace Samesex=1 if inlist(wave, 2, 9, 11) & NnChildren==2 &  NoGirls==0
tab Samesex ExpChildUpdate if NnChildren==2 & Highskilled==0, row chi


/* Realized fertility and Expectations */
 
   
reg Birth lExpChildUpdate i.age i.lNChildG lIncome  i.wave if Highskilled==0 , robust
eststo FerL
reg Birth lExpChildUpdate i.age i.lNChildG lIncome  i.wave if Highskilled==1 , robust
eststo FerH

/* Table realized Fertility and Intentions - Data supplement */

estout FerL FerH using $output_fig\\FerExp.tex, cells("b(fmt(3) star)" "se(par fmt(3))"  ) ////
   label collabels(none) mlabels(, none ) drop(0.lNChildG) varlabel(_cons "Constant" lExpChildUpdate "Exp. Child (lagged)" 1.lNChildG "1 child" 2.lNChildG "2 children"  3.lNChildG ">2 children" lIncome "Income (lagged)") stats(N r2, fmt(0 3) labels("\hline Obs" "$ R^2 $")) indicate("Age dummies=*age*" "Wave dummies=*wave*") style(tex) replace


 /* Involunatary infertility */
/* Numbers to footnote - Data supplement */ 
 
 gen InVol=(TargetChildUpdate>NnChildren) if !missing(TargetChildUpdate) & !missing(NnChildren) 
 
 bys Highskilled: tab InVol if age==39
 
 drop InVol

 preserve
  /* Table Household Characteristics before birth  Data Supplement*/
sort hid wave
 gen v1=age
 gen v2=l.NnChildren
 gen v4=l.Income/1000
 gen v5=l.WorkHours1
 gen v6=l.WorkHours2
 gen v7=l.OwnHouse 
 gen v8=l.SaveForChildren 

 label var v1 "Age"
 label var v2 "No. children"
 label var v4 "Income (000s)"
 label var v5 "Husband's hours"
 label var v6 "Wife's hours"
 label var v7 "House owner"
 label var v8 "Saving for Children"

 keep if Birth==1 & !missing(lExpChildUpdate) & !missing(Highskilled)

 eststo drop s*
forvalues educ=0/1 {
forvalues exp=0/1 {
	eststo s`educ'`exp': 		 estpost sum v1-v8 if  lExpChildUpdate==`exp' & Highskilled==`educ' 
	
	sum lExpChildUpdate if  lExpChildUpdate==`exp' & Highskilled==`educ' 

}
}

estout s00 s01 s10 s11 using $output_fig\TabComExpChild.tex , replace cells("mean(fmt(3))") stats(N, fmt(0) labels("\hline No. obs")) style(tex) ///
	label  collabels(none) mlabels(, none )

restore	


* Descriptive table - main text
sort hid wave
 gen v1=age
 gen v2=NnChildren
 gen v3=Income/1000
 gen v4=SavingRate
 gen v5=WorkHours1
 gen v6=WorkHours2
 gen v7=OwnHouse 
 *gen v8=Highskilled 
 gen v9 = lExpChildUpdate

 label var v1 "Age"
 label var v2 "No. children"
 label var v3 "Income (000s)"
 label var v4 "Saving rate"
 
 label var v5 "Husband's hours"
 label var v6 "Wife's hours"
 label var v7 "House owner"
 *label var v8 "High skilled"
 label var v9 "Expect more children"

 eststo drop s*
forvalues educ=0/1 {
	eststo s`educ': 		 estpost sum v1-v9 if  Highskilled==`educ' 

}

estout s0 s1 using $output_fig\TabDescriptive.tex , replace cells("mean(fmt(3)) sd(par fmt(3))") stats(N, fmt(0) labels("\hline No. obs")) style(tex) ///
	label  collabels(none) mlabels(, none )

/*****************************************************************************************/ 
/* Check DIVORCE                                                                         */
/*****************************************************************************************/



/* check sample size */

xtsum NnChildren if Highskilled==1 & Divorce==1
xtsum NnChildren if Highskilled==0 & Divorce==1

sort hid wave
drop UnExpTemp UnExpBirth
gen UnExpTemp=Birth*(1-lExpChildUpdate)
bysort hid: gen UnExpBirth=sum(UnExpTemp)

gen UnExpBirthD=(UnExpBirth>=1)


bys Divorce: means NnChildren ExpChildUpdate TargetChildUpdate Income age UnExpBirth if Highskilled==0
bys Divorce: means NnChildren ExpChildUpdate TargetChildUpdate Income age UnExpBirth if Highskilled==1

bys hid: egen LastWave=max(wave)
bys hid: egen FirstWave=min(wave)

gen duration=wave-FirstWave
gen duration2=duration^2

tab Divorce Highskilled if wave==LastWave, col

gen DivLogit=0
replace DivLogit=1 if wave==LastWave & Divorce==1


logit DivLogit i.NChildG Income i.age  duration duration2 UnExpBirthD  if Highskilled==0, robust
eststo DivorceL
logit DivLogit i.NChildG Income i.age  duration duration2 UnExpBirthD if Highskilled==1, robust
eststo DivorceH


estout  DivorceL DivorceH using $output_fig\Tab_Reg_Divorce.tex , replace style(tex) cells("b(fmt(3) star)" "se(par fmt(3))"  ) /// 
label collabels(,none) mlabels(,none) eqlabel(,none) /*drop(0.NChildG)*/  varlabel(_cons "Constant" Income "Income(lagged)" /*NChildG "Number of children"*/ UnExpBirthD "Unexpected Childbirth"   )  stats(N , fmt(0) labels("\hline Obs" )) ///
 indicate("Age dummies=*age*"  "Duration of Marriage=*duration*") 

 /* count how many who want an additional child after having an unwanted child */

 forvalues educ=0/1 {
	tab UnExpBirth ExpChildUpdate if UnExpBirth>0 & Highskilled==`educ', row
}


drop UnExpBirthD

	

/****************************************************************************************/
/*              SAVING                                                                  */
/****************************************************************************************/


/* saving rate */


tab wave, gen(dwave)

global var_fd " ExpBaby UnExpBaby age agesq dwave* "

sort hid wave
gen dSavingRated=d.SavingRate  
gen agesq=age^2

/* overall effect of arrival of children on saving rate */
 
reg dSavingRate Birth age agesq dwave* if Highskilled==0, robust

gen SRL=_b[Birth] if Highskilled==0 & wave==10
gen SRL_L=_b[Birth]-1.96*_se[Birth] if Highskilled==0 & wave==10
gen SRL_H=_b[Birth]+1.96*_se[Birth] if Highskilled==0 & wave==10

reg dSavingRate Birth age agesq dwave* if Highskilled==1, robust
gen SRH=_b[Birth] if Highskilled==1 & wave==10
gen SRH_L=_b[Birth]-1.96*_se[Birth] if Highskilled==1 & wave==10
gen SRH_H=_b[Birth]+1.96*_se[Birth] if Highskilled==1 & wave==10




/* Interaction effects of arrival of children on saving rate */

gen UnExpBaby=Birth*(lExpChildUpdate==0)
gen ExpBaby=Birth*(lExpChildUpdate==1)

reg dSavingRate $var_fd if Highskilled==0 , robust
eststo sav_wantedL, title("Low skilled")

replace SRL=_b[ExpBaby] if Highskilled==0 & wave==2
replace SRL_L=_b[ExpBaby]-1.96*_se[ExpBaby] if Highskilled==0 & wave==2
replace SRL_H=_b[ExpBaby]+1.96*_se[ExpBaby] if Highskilled==0 & wave==2


replace SRL=_b[UnExpBaby] if Highskilled==0 & wave==5
replace SRL_L=_b[UnExpBaby]-1.96*_se[UnExpBaby] if Highskilled==0 & wave==5
replace SRL_H=_b[UnExpBaby]+1.96*_se[UnExpBaby] if Highskilled==0 & wave==5

reg dSavingRate $var_fd if Highskilled==1 , robust
eststo sav_wantedH, title("High skilled")

replace SRH=_b[ExpBaby] if Highskilled==1 & wave==2
replace SRH_L=_b[ExpBaby]-1.96*_se[ExpBaby] if Highskilled==1 & wave==2
replace SRH_H=_b[ExpBaby]+1.96*_se[ExpBaby] if Highskilled==1 & wave==2

replace SRH=_b[UnExpBaby] if Highskilled==1 & wave==5
replace SRH_L=_b[UnExpBaby]-1.96*_se[UnExpBaby] if Highskilled==1 & wave==5
replace SRH_H=_b[UnExpBaby]+1.96*_se[UnExpBaby] if Highskilled==1 & wave==5




estout sav_* using $output_fig\TabSavWanted.tex , replace style(tex) cells("b(fmt(3) star)" "se(par fmt(3))"  ) /// 
label collabels(,none) mlabels(,none) varlabel( ExpBaby "Expected childbirth" UnExpBaby "Unexpected childbirth" lExpChildUpdate "Expects more children" _cons "Constant")  stats(N , fmt(0) labels("\hline Obs" )) ///
 indicate("Wave dummies=*wave*"  "Age polynomial=*age*") 


********************************************************************************
*        Graphs for the main text                                              *
*                                                                              *
******************************************************************************** 

preserve 

keep if !missing(NChildG)

sort ageG Highskilled
tab NChildG, gen(dd)
collapse dd*, by(ageG Highskilled)

* graphs showing the ap's for fractions of children
 
graph  bar (sum) dd4 dd3 dd2 dd1 if Highskilled==1, over(ageG) stack ///
    ytitle("Fraction") b1title("Age") graphregion(color(white))  bar(1, fcolor(blue) lcolor(black) fintensity(100) ) bar(2, fcolor(gray) lcolor(black) fintensity(80) ) bar(3, fcolor(blue) lcolor(black) fintensity(20) ) bar(4, fcolor(white) lcolor(black) fintensity(20) ) ///
		legend(on order(4 "0 Children" 3 "1 Child" 2 "Two Children"  1 ">2 Children" ) row(1) )  	
graph export $output_fig\ChildrenH.eps, as(eps) preview(off) replace
		 
		 
graph  bar (sum) dd4 dd3 dd2 dd1 if Highskilled==0, over(ageG) stack ///
    ytitle("Fraction") b1title("Age") graphregion(color(white))  bar(1, fcolor(blue) lcolor(black) fintensity(100) ) bar(2, fcolor(gray) lcolor(black) fintensity(80) ) bar(3, fcolor(blue) lcolor(black) fintensity(20) ) bar(4, fcolor(white) lcolor(black) fintensity(20) ) ///
		legend(on order(4 "0 Children" 3 "1 Child" 2 "Two Children"  1 ">2 Children" ) row(1) )  
graph export $output_fig\ChildrenL.eps, as(eps) preview(off) replace

* graphs for intended births  
restore 
preserve
keep if Birth==1 & NChildG>0

gen UnIntendedL=1-lExpChildUpdate if Highskilled==0
gen UnIntendedH=1-lExpChildUpdate if Highskilled==1

graph bar (mean) UnIntendedL UnIntendedH, over(Parity) ///
    b1title("Parity") ytitle("Share of unexpected births") legend(label (1 "Low Skilled") label(2 "High Skilled") pos(11) ring(0) col(1)) bar(1, fcolor(black) lcolor(black) fintensity(100) ) bar(2, fcolor(gray) lcolor(black) fintensity(80) )  
graph export $output_fig\Unintended.eps, as(eps) preview(off) replace	

* graphs for impact on saving rates
restore 

preserve
keep if wave==2|wave==5
label define GLabel 2 "Expected Births" 5 "Unexpected Births" 10 "All Births"
label value wave GLabel

graph bar (mean) SRL SRH, over(wave) ///
 ytitle("Change in saving rate")    legend(label (1 "Low Skilled") label(2 "High Skilled")) bar(1, fcolor(black) lcolor(black) fintensity(100) ) bar(2, fcolor(gray) lcolor(black) fintensity(80) )  
 graph export $output_fig\Saving_Reg.eps, as(eps) preview(off) replace	

 

collapse SRL* SRH*, by(wave)

replace wave=0 if wave==2
gen ttL=wave-0.5
gen ttH=wave+0.5

twoway (bar SRL ttL, color(black) fcolor(black) fintensity(100)) ///
       (bar SRH ttH, color(black) fcolor(grey) fintensity(50)  )  ///
      (rcap SRL_L SRL_H ttL) ///
       (rcap SRH_L SRH_H ttH)	   , ///
	   yline(0) ////
	    ytitle("Change in saving rate")    legend(order(1 "Low Skilled" 2 "High Skilled" 3 "Conf. interval") rows(1))  xlabel(0 "Exptected Births" 5 "Unexpected Births" 10 "All Births")
		
   graph export $output_fig\Saving_RegB.eps, as(eps) preview(off) replace	

*legend(label (1 "Low Skilled") label(2 "High Skilled") label(3 "Conf. interval") label(4 "Conf. interval"))

restore

 
preserve
sort ageG Highskilled
keep if !missing(ExpChild)

gen ExpChildUpdateL=ExpChildUpdate if Highskilled==0
gen ExpChildUpdateH=ExpChildUpdate if Highskilled==1

graph bar (mean) ExpChildUpdateL ExpChildUpdateH, over(ageG) ///
 b1title("Age") ytitle("Share expecting more children")  legend(off) bar(1, fcolor(black) lcolor(black) fintensity(100) ) bar(2, fcolor(grey) lcolor(black) fintensity(60) )  
graph export $output_fig\ExpChildAge.eps, as(eps) preview(off) replace

graph bar (mean) ExpChildUpdateL ExpChildUpdateH, over(NChildG) ///
b1title("Number of Children") ytitle("Share expecting more children")  legend(label (1 "Low Skilled") label(2 "High Skilled") pos(1) ring(0) col(1)) bar(1, fcolor(black) lcolor(black) fintensity(100) ) bar(2, fcolor(grey) lcolor(black) fintensity(60) )  
graph export $output_fig\ExpChildParity.eps, as(eps) preview(off) replace

restore


/*********************************************************************************************************************************************************************************/
*validation of the expectations variable
/*********************************************************************************************************************************************************************************/

sort hid wave

bys hid: egen TBaby=sum(noBaby)
bys hid: gen SBaby=sum(noBaby)

gen FBaby=TBaby-SBaby

gen FBabyE=FBaby if ExpChildUpdate==1
gen FBabyU=FBaby if ExpChildUpdate==0

tab FBabyE Highskilled,  col
tab FBabyU Highskilled,  col

preserve

tab ExpChild NChildG if Highskilled==1
tab ExpChild NChildG if Highskilled==0


sort NChildG Highskilled


collapse FBabyE FBabyU , by(NChildG Highskilled)

twoway (line FBabyE NChildG if Highskilled==0,lc(black) clwidth(.8)) (line FBabyU NChildG if Highskilled==0,lc(black) lp("--")  clwidth(.8) ) (line FBabyE NChildG if Highskilled==1,lc(red)  clwidth(.8)) (line FBabyU NChildG if Highskilled==1,lc(red) lp("--") clwidth(.8)) , ///
        xlabel(0 1 2 3 , valuelabel) ylabel(0(.2)1) xtitle("number of Children") ytitle("Fraction having more children") graphregion(color(white)) saving(expect2,replace) ///
		legend(on order(1 "Low - Exp. children" 2 "Low - Not Exp. children" 3 "High - Exp. children" 4 "High Not Exp. children" ) ring(0) pos(1) col(1) region(lwidth(none)))
graph export $output_fig\ExpChildParity2.eps, as(eps) preview(off) replace

restore

preserve
tab ExpChild ageG if Highskilled==1
tab ExpChild ageG if Highskilled==0


sort ageG Highskilled


collapse FBabyE FBabyU , by(ageG Highskilled)

twoway (line FBabyE ageG if Highskilled==0,lc(black) clwidth(.8)) (line FBabyU ageG if Highskilled==0,lc(black) clwidth(.8)) (line FBabyE ageG if Highskilled==1,lc(red) lp("--") clwidth(.8)) (line FBabyU ageG if Highskilled==1,lc(red) lp("--") clwidth(.8)) , ///
        xlabel(1 2 3 4, valuelabel) ylabel(0(.2)1) xtitle("Age") ytitle("Fraction having more children") graphregion(color(white)) saving(expect2,replace) ///
		legend(on order(1 "Low skilled" 3 "High skilled" ) ring(0) pos(1) col(1) region(lwidth(none)))
graph export $output_fig\ExpChildage2.eps, as(eps) preview(off) replace


cap log close

restore


preserve

drop if !inlist(wave,2,8,12,13,17)
*br wave hid  NnChild ExpChild TargetChildUpdate ExpNChild age
gen tt=(wave==2)+2*(wave==8)+3*(wave==12)+4*(wave==13)+5*(wave==17)
sort hid tt
xtset hid tt

g dNnChild = d.NnChildren
g dage=d.age
forvalues educ=0/1 {
	eststo dyn`educ': qui reg d.ExpNChild dNnChild dage if Highskilled==`educ', nocons robust
}

restore

estout dyn0 dyn1 using $output_fig\tab_ExpDynamics.tex , replace style(tex) cells("b(fmt(3) star)" "se(par fmt(3))"  ) /// 
label collabels(,none) mlabels(,none) varlabel( dNnChild "$\Delta$ Children" dage "$\Delta$ Age" )  stats(N , fmt(0) labels("\hline Obs" ))
 

/***********************************************************************************************************************/
/*              GRAPHS FOR DATA APPENDIX                                                                               */
/***********************************************************************************************************************/


/* additional graphs */

clear 
use ${output_data}\BHPSpanelAdjustedHouseholds
gen ageG=floor(age/5)*5 +2.5
 
sort ageG Highskilled


label define HS 0 "Low Skilled" 1 "High Skilled"
label value Highskilled HS

gen NChildG = NnChildren
replace NChildG=3 if NnChildren>3 & !missing(NnChildren)
label var NChildG "Number of Children"
label define  lNChildg  0 "0 children" 1 "One child" 2  "Two children" 3 "More than two children" 
label value NChildG lNChildg

twoway hist SavingRate , by(Highskilled)
graph export $output_fig\HistSavingRate.eps, as(eps) preview(off) replace


/* initial distribution */

twoway hist Income if Initial24==1 , frac bin(20) by(Highskilled, note(""))
graph export $output_fig\HistIncome.eps, as(eps) preview(off) replace


twoway hist NChildG if Initial24==1 , discrete   by(Highskilled, note("")) xlabel(0 "0 " 1 "1 " 2 "2" 3 "more than 2")  

graph export $output_fig\HistChild.eps, as(eps) preview(off) replace


graph matrix NChildG Income Wealth  if age==24 & Highskilled==1, half ms(p)
graph export $output_fig\krydsh.eps, as(eps) preview(off) replace

 graph matrix NChildG Income Wealth  if age==24 & Highskilled==0, half ms(p)
graph export $output_fig\krydsl.eps, as(eps) preview(off) replace

twoway hist Income if Initial24==1 , frac bin(20) by(Highskilled, note(""))
graph export $output_fig\HistIncome.eps, as(eps) preview(off) replace


twoway hist NChildG if Initial24==1 , discrete   by(Highskilled, note("")) xlabel(0 "0 " 1 "1 " 2 "2" 3 "more than 2")  
graph export $output_fig\HistChild.eps, as(eps) preview(off) replace


graph matrix NChildG Income Wealth  if age==24 & Highskilled==1, half ms(p)
graph export $output_fig\krydsh.eps, as(eps) preview(off) replace


 graph matrix NChildG Income Wealth  if age==24 & Highskilled==0, half ms(p)
graph export $output_fig\krydsl.eps, as(eps) preview(off) replace

/****************************************************************************************************************************/
/*             GRAPHS FOR THE MAIN VARIABLES                                                                                */
/****************************************************************************************************************************/

preserve
collapse NnChildren SavingRate Income NChild TargetChildUpdate nkids, by(ageG Highskilled)

twoway (line NnChildren ageG if Highskilled==0,lc(black) clwidth(.8)) (line nkids ageG if Highskilled==0,lc(black) clwidth(.4)) (line NnChildren ageG if Highskilled==1,lc(gray) lp("--") clwidth(.8)) (line nkids ageG if Highskilled==1,lc(gray) lp("--") clwidth(.4)) , ///
       xlabel(22.5 "20-24" 27.5 "25-29" 32.5 "30-34" 37.5 "35-39" 42.5 "40-44" 47.5 "45-49" 52.5 "50-54" 57.5 "55-59" 62.5 "60-64") /*xlabel(20 (5) 45)*/ ylabel(0(.5)3) xtitle("Age") ytitle("Average number of children") graphregion(color(white)) saving(expect2,replace) ///
		legend(on order(1 "Low skilled, all children" 2 "Low skilled, children in HH" 3 "High skilled, all children" 4 "High skilled, children in HH") ring(0) pos(1) col(1) region(lwidth(none)))
graph export $output_fig\Children.eps, as(eps) preview(off) replace

twoway (line Income ageG if Highskilled==0,lc(black) clwidth(.8))  (line Income ageG if Highskilled==1,lc(gray) lp("--") clwidth(.8))  , ///
        xlabel(22.5 "20-24" 27.5 "25-29" 32.5 "30-34" 37.5 "35-39" 42.5 "40-44" 47.5 "45-49" 52.5 "50-54" 57.5 "55-59" 62.5 "60-64") /*xlabel(20 (5) 45)*/ ylabel(20000(5000)50000) xtitle("Age") ytitle("Average Income (in 2000 £)") graphregion(color(white)) saving(expect2,replace) ///
		legend(on order(1 "Low skilled" 2 "High skilled" ) ring(0) pos(1) col(1) region(lwidth(none)))
graph export $output_fig\Income.eps, as(eps) preview(off) replace



twoway (line SavingRate ageG if Highskilled==0,lc(black) clwidth(.8))  (line SavingRate ageG if Highskilled==1,lc(gray) lp("--") clwidth(.8))  , ///
        xlabel(22.5 "20-24" 27.5 "25-29" 32.5 "30-34" 37.5 "35-39" 42.5 "40-44" 47.5 "45-49" 52.5 "50-54" 57.5 "55-59" 62.5 "60-64") /*xlabel(20 (5) 45)*/ ylabel(0.04(0.01)0.09) xtitle("Age") ytitle("Average Saving Rate") graphregion(color(white)) saving(expect2,replace) ///
		legend(on order(1 "Low skilled" 2 "High skilled" ) ring(0) pos(1) col(1) region(lwidth(none)))
graph export $output_fig\SavingRate.eps, as(eps) preview(off) replace


twoway (line NnChildren ageG if Highskilled==0 & ageG<=45,lc(black) clwidth(.4)) (line TargetChildUpdate ageG if Highskilled==0 & ageG<=45 ,lc(black) clwidth(.8)) ///
       (line NnChildren ageG if Highskilled==1 & ageG<=45 ,lc(gray) lp("--") clwidth(.4))   (line TargetChildUpdate ageG if Highskilled==1& ageG<=45 ,lc(gray) lp("--") clwidth(.8)) , ///
        xlabel(22.5 "20-24" 27.5 "25-29" 32.5 "30-34" 37.5 "35-39" 42.5 "40-44") /*xlabel(20 (5) 45)*/ ylabel(0(.5)2.5) xtitle("Age") ytitle("Average number of children") graphregion(color(white)) saving(expect2,replace) ///
		legend(on order(1 "Low skilled, Actual no. children" 2 "Low skilled, Expected no. children" 3 "High skilled, Actual no. children" 4 "High skilled, Expected no. children") ring(0) pos(5) col(1) region(lwidth(none)))
graph export $output_fig\TargetChild.eps, as(eps) preview(off) replace
restore
